/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.GwtGenericsUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtDeprecatedPropertyKeyJavadocTagInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtDeprecatedPropertyKeyJavadocTagInspection");

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtDeprecatedPropertyKeyJavadocTagInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null || !gwtFacet.getSdkVersion().isGenericsSupported()) {
            return null;
        }
        PropertiesFile[] files = GwtI18nManager.getInstance(manager.getProject()).getPropertiesFiles(aClass);
        if (files.length == 0) {
            return null;
        }
        return GwtDeprecatedPropertyKeyJavadocTagInspection.checkInterface(aClass, manager, isOnTheFly);
    }

    private static ProblemDescriptor[] checkInterface(PsiClass anInterface, InspectionManager manager, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod method : anInterface.getMethods()) {
            PsiDocTag tag;
            PsiDocComment comment = method.getDocComment();
            if (comment == null || (tag = comment.findTagByName("gwt.key")) == null) continue;
            ReplaceTagByAnnotationQuickFix fix = new ReplaceTagByAnnotationQuickFix(tag, method);
            String message = GwtBundle.message("problem.description.gwt.key.tag.is.deprecated.in.gwt.1.5", new Object[0]);
            problems.add(manager.createProblemDescriptor((PsiElement)tag, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.deprecated.gwt.key.tag.in.javadoc.comments", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtDeprecatedPropertyKeyJavadocTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection", "getShortName"));
        }
        return "GwtDeprecatedPropertyKeyJavadocTag";
    }

    private static class ReplaceTagByAnnotationQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.replace.gwt.key.tag.with.key.annotation", new Object[0]);
        private final PsiDocTag myTag;
        private final PsiMethod myMethod;

        public ReplaceTagByAnnotationQuickFix(PsiDocTag tag, PsiMethod method) {
            super(GwtBundle.message("quickfix.name.replace.gwt.key.tag.with.key.annotation.in.method.0", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2)));
            this.myTag = tag;
            this.myMethod = method;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection$ReplaceTagByAnnotationQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection$ReplaceTagByAnnotationQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtDeprecatedPropertyKeyJavadocTagInspection$ReplaceTagByAnnotationQuickFix", "applyFix"));
            }
            String propertyName = this.myTag.getValueElement().getText();
            try {
                GwtI18nUtil.addKeyAnnotation(propertyName, this.myMethod, JavaPsiFacade.getInstance((Project)project).getElementFactory());
                GwtGenericsUtil.removeJavadocTags(this.myMethod, "gwt.key");
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

