/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.refactorings.rename;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.refactorings.rename.CssClassRenameHandler;
import com.intellij.gwt.refactorings.rename.GwtAssociatedElementRenameHandler;
import com.intellij.gwt.refactorings.rename.MethodForCssClassRenameHandler;
import com.intellij.gwt.uiBinder.mapping.UiBinderClassRenameHandler;
import com.intellij.gwt.uiBinder.mapping.UiXmlFileRenameHandler;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GwtRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/refactorings/rename/GwtRenameProcessor", "canProcessElement"));
        }
        if (GwtFacet.findFacetByPsiElement(element) == null) {
            return false;
        }
        for (GwtAssociatedElementRenameHandler handler : GwtRenameHandlersHolder.HANDLERS) {
            if (handler.getAssociatedElements(element).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        for (GwtAssociatedElementRenameHandler handler : GwtRenameHandlersHolder.HANDLERS) {
            for (PsiElement associatedElement : handler.getAssociatedElements(element)) {
                allRenames.put(associatedElement, handler.getNewAssociatedElementName(newName));
            }
        }
    }

    private static class GwtRenameHandlersHolder {
        public static final GwtAssociatedElementRenameHandler[] HANDLERS = new GwtAssociatedElementRenameHandler[]{new CssClassRenameHandler(), new MethodForCssClassRenameHandler(), new UiXmlFileRenameHandler(), new UiBinderClassRenameHandler()};

        private GwtRenameHandlersHolder() {
        }
    }
}

