/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;

@com.intellij.openapi.components.State(name="TerminalOptionsProvider", storages={@Storage(value="terminal.xml")})
public class TerminalOptionsProvider
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static TerminalOptionsProvider getInstance() {
        return (TerminalOptionsProvider)ServiceManager.getService(TerminalOptionsProvider.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState.myShellPath = state.myShellPath;
        this.myState.myCloseSessionOnLogout = state.myCloseSessionOnLogout;
        this.myState.myReportMouse = state.myReportMouse;
        this.myState.mySoundBell = state.mySoundBell;
        this.myState.myTabName = state.myTabName;
        this.myState.myCopyOnSelection = state.myCopyOnSelection;
        this.myState.myPasteOnMiddleMouseButton = state.myPasteOnMiddleMouseButton;
        this.myState.myOverrideIdeShortcuts = state.myOverrideIdeShortcuts;
        this.myState.myShellIntegration = state.myShellIntegration;
    }

    public boolean closeSessionOnLogout() {
        return this.myState.myCloseSessionOnLogout;
    }

    public boolean enableMouseReporting() {
        return this.myState.myReportMouse;
    }

    public boolean audibleBell() {
        return this.myState.mySoundBell;
    }

    public String getTabName() {
        return this.myState.myTabName;
    }

    public boolean overrideIdeShortcuts() {
        return this.myState.myOverrideIdeShortcuts;
    }

    public void setOverrideIdeShortcuts(boolean overrideIdeShortcuts) {
        this.myState.myOverrideIdeShortcuts = overrideIdeShortcuts;
    }

    public boolean shellIntegration() {
        return this.myState.myShellIntegration;
    }

    public void setShellIntegration(boolean shellIntegration) {
        this.myState.myShellIntegration = shellIntegration;
    }

    public String getShellPath() {
        return this.myState.myShellPath;
    }

    private static String getDefaultShellPath() {
        String shell = System.getenv("SHELL");
        if (shell != null && new File(shell).canExecute()) {
            return shell;
        }
        if (SystemInfo.isUnix) {
            return "/bin/bash";
        }
        return "cmd.exe";
    }

    public void setShellPath(String shellPath) {
        this.myState.myShellPath = shellPath;
    }

    public void setTabName(String tabName) {
        this.myState.myTabName = tabName;
    }

    public void setCloseSessionOnLogout(boolean closeSessionOnLogout) {
        this.myState.myCloseSessionOnLogout = closeSessionOnLogout;
    }

    public void setReportMouse(boolean reportMouse) {
        this.myState.myReportMouse = reportMouse;
    }

    public void setSoundBell(boolean soundBell) {
        this.myState.mySoundBell = soundBell;
    }

    public boolean copyOnSelection() {
        return this.myState.myCopyOnSelection;
    }

    public void setCopyOnSelection(boolean copyOnSelection) {
        this.myState.myCopyOnSelection = copyOnSelection;
    }

    public boolean pasteOnMiddleMouseButton() {
        return this.myState.myPasteOnMiddleMouseButton;
    }

    public void setPasteOnMiddleMouseButton(boolean pasteOnMiddleMouseButton) {
        this.myState.myPasteOnMiddleMouseButton = pasteOnMiddleMouseButton;
    }

    static /* synthetic */ String access$000() {
        return TerminalOptionsProvider.getDefaultShellPath();
    }

    public static class State {
        public String myShellPath = TerminalOptionsProvider.access$000();
        public String myTabName = "Local";
        public boolean myCloseSessionOnLogout = true;
        public boolean myReportMouse = true;
        public boolean mySoundBell = true;
        public boolean myCopyOnSelection = true;
        public boolean myPasteOnMiddleMouseButton = true;
        public boolean myOverrideIdeShortcuts = true;
        public boolean myShellIntegration = true;
    }
}

