/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishConfigBase;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfigProcessor;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishNetworkConfigProcessor;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class GlassfishSecuredConfig
extends GlassfishConfigBase {
    private static final GlassfishConfigBase.GlassfishConfigFactoryBase<GlassfishSecuredConfig> FACTORY = new GlassfishConfigBase.GlassfishConfigFactoryBase<GlassfishSecuredConfig>(){

        @NotNull
        public GlassfishSecuredConfig createConfig(GlassfishLocalModel data) {
            GlassfishSecuredConfig glassfishSecuredConfig = new GlassfishSecuredConfig(data);
            if (glassfishSecuredConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/glassfish/server/GlassfishSecuredConfig$1", "createConfig"));
            }
            return glassfishSecuredConfig;
        }
    };
    private boolean mySecured = false;

    public GlassfishSecuredConfig(GlassfishLocalModel model) {
        super(model);
    }

    protected void update(GlassfishLocalModel data) {
        this.mySecured = false;
        new GlassfishDomainConfigProcessor(this.getDomainConfig()){

            @Override
            protected void doProcessConfig(File file, Document doc, Element serverConfig) throws IOException {
                new GlassfishNetworkConfigProcessor(){

                    @Override
                    protected void doProcessConfig(Element networkConfig, Element networkListener) {
                        String protocolName = networkListener.getAttributeValue("protocol");
                        if (protocolName == null) {
                            return;
                        }
                        Element protocols = networkConfig.getChild("protocols");
                        if (protocols == null) {
                            return;
                        }
                        this.checkProtocol(protocols, protocolName);
                    }
                }.processServerConfig(serverConfig, "admin-listener");
            }

            private void checkProtocol(Element protocols, String protocolName) {
                Element protocol = 2.getChild((Element)protocols, (String)"protocol", (String)"name", (String)protocolName);
                if (protocol == null) {
                    return;
                }
                if ("true".equalsIgnoreCase(protocol.getAttributeValue("security-enabled"))) {
                    GlassfishSecuredConfig.this.mySecured = true;
                } else {
                    Element portUnificaton = protocol.getChild("port-unification");
                    if (portUnificaton != null) {
                        for (Element protocolFinder : 2.getChildren((Element)portUnificaton, (String)"protocol-finder")) {
                            String subProtocolName = protocolFinder.getAttributeValue("protocol");
                            if (subProtocolName == null) continue;
                            this.checkProtocol(protocols, subProtocolName);
                        }
                    }
                }
            }
        }.processConfig();
    }

    public static boolean get(GlassfishLocalModel model) {
        GlassfishSecuredConfig config = FACTORY.get(model);
        return config != null && config.mySecured;
    }
}

