/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcLoader;
import com.intellij.database.dataSource.srcStorage.DbSrcMapping;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceActions {

    public static class Edit
    extends AnAction {
        public void update(AnActionEvent e) {
            DbElement edit = Edit.getObjectToEdit(e);
            e.getPresentation().setEnabledAndVisible(DbSrcStorage.isEnabled() && edit != null);
        }

        @Nullable
        private static DbElement getObjectToEdit(AnActionEvent e) {
            DbElement object = Edit.getObject(e);
            return object == null || !DbSrcStorage.isStored((DasObject)object) ? null : object;
        }

        @Nullable
        private static DbElement getObject(AnActionEvent e) {
            DbDataSource dataSource;
            DbElement item = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            if (item != null) {
                return item;
            }
            VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (file == null || project == null) {
                return null;
            }
            DbSrcStorage storage = DbSrcStorage.getInstance(project);
            String dataSourceId = storage.getDataSourceId(file);
            DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
            if (dataSource == null) {
                return null;
            }
            DbDataSourceLayout layout = storage.getLayout(dataSource.getUniqueId());
            return DbSrcMapping.getElement(layout.getPath(layout.getObject(file, null), false), dataSource);
        }

        public void actionPerformed(AnActionEvent e) {
            final DbElement edit = Edit.getObjectToEdit(e);
            if (edit == null) {
                return;
            }
            DbSrcStorage storage = DbSrcStorage.getInstance(edit.getProject());
            try {
                final DbDataSourceLayout sourceStorage = storage.getLayout(edit.getDataSource().getUniqueId());
                sourceStorage.initForce();
                DbSrcPath object = DbSrcPath.of((DasObject)edit);
                final DbSrcStorageLayout.Item source = sourceStorage.getPath(object, false);
                final DbSrcStorageLayout.Item staging = sourceStorage.getPath(object, true);
                if (source == null || staging == null) {
                    return;
                }
                if (source.getSrcFile() == null) {
                    new Task.Backgroundable(edit.getProject(), "Opening Object for Edit", true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/SourceActions$Edit$1", "run"));
                            }
                            indicator.setText("Loading sources for " + edit.getName());
                            try {
                                if (!DbSrcLoader.load(sourceStorage, ConnectionProvider.forElement(edit), edit)) {
                                    return;
                                }
                            }
                            catch (IOException ex) {
                                DataSourceUiUtil.showNotification(edit.getProject(), "Failed to store sources", ex.getMessage(), true);
                            }
                            ApplicationManager.getApplication().invokeLater(() -> this.openForEdit(edit.getProject(), source, staging));
                        }
                    }.queue();
                } else {
                    this.openForEdit(edit.getProject(), source, staging);
                }
            }
            catch (IOException ex) {
                DataSourceUiUtil.showNotification(edit.getProject(), "Failed to initialize storage", ex.getMessage(), true);
            }
        }

        private void openForEdit(Project project, DbSrcStorageLayout.Item source, DbSrcStorageLayout.Item staging) {
            VirtualFile stagingPath;
            VirtualFile sourcePath = source.getSrcFile();
            if (sourcePath == null) {
                return;
            }
            if (staging.getSrcFile() == null) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try (OutputStream stream = staging.getOutputStream((Object)this);){
                        stream.write(sourcePath.contentsToByteArray());
                    }
                    catch (IOException ex) {
                        DataSourceUiUtil.showNotification(project, "Failed to move file to staging", ex.getMessage(), true);
                    }
                });
            }
            if ((stagingPath = staging.getSrcFile()) == null) {
                return;
            }
            FileEditorManager.getInstance((Project)project).openFile(stagingPath, true);
        }
    }

    public static class Sync
    extends AnAction {
        public void update(AnActionEvent e) {
            Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            e.getPresentation().setEnabledAndVisible(DbSrcStorage.isEnabled() && !elements.isEmpty());
        }

        public void actionPerformed(AnActionEvent e) {
            final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (project == null) {
                return;
            }
            Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            final MultiMap grouped = MultiMap.createSet();
            for (DbElement element : elements) {
                grouped.putValue((Object)element.getDataSource(), (Object)element);
            }
            if (grouped.isEmpty()) {
                return;
            }
            new Task.Backgroundable(project, "Synchronizing Sources", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/SourceActions$Sync$1", "run"));
                    }
                    try {
                        for (Map.Entry entry : grouped.entrySet()) {
                            indicator.setText("Loading sources for " + ((DbDataSource)entry.getKey()).getName());
                            indicator.setFraction(0.0);
                            Set<DbElement> failed = DbSrcLoader.load(indicator, (DbDataSource)entry.getKey(), (Collection)entry.getValue());
                            if (failed.isEmpty()) continue;
                            DataSourceUiUtil.showNotification(project, "Failed to load some (" + failed.size() + ") objects from " + ((DbDataSource)entry.getKey()).getName(), StringUtil.join(failed, (Function)DasUtil.TO_NAME, (String)", "), true);
                        }
                    }
                    catch (IOException ex) {
                        DataSourceUiUtil.showNotification(project, "Failed to store sources", ex.getMessage(), true);
                    }
                }
            }.queue();
        }
    }
}

