/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CsvRecordFormat {
    public final String prefix;
    public final String suffix;
    public final String nullText;
    public final ImmutableList<Quotes> quotes;
    public final QuotationPolicy quotationPolicy;
    public final String valueSeparator;
    public final String recordSeparator;
    public final boolean trimWhitespace;

    public CsvRecordFormat(@NotNull String prefix, @NotNull String suffix, @NotNull String nullText, @NotNull List<Quotes> quotes, @NotNull QuotationPolicy quotationPolicy, @NotNull String valueSeparator, @NotNull String recordSeparator, boolean trimWhitespace) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        if (nullText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullText", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        if (quotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotes", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        if (quotationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotationPolicy", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        if (valueSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueSeparator", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        if (recordSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordSeparator", "com/intellij/database/csv/CsvRecordFormat", "<init>"));
        }
        this.prefix = prefix;
        this.suffix = suffix;
        this.nullText = nullText;
        this.quotes = ContainerUtil.immutableList(quotes);
        this.quotationPolicy = quotationPolicy;
        this.valueSeparator = valueSeparator;
        this.recordSeparator = recordSeparator;
        this.trimWhitespace = trimWhitespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvRecordFormat)) {
            return false;
        }
        CsvRecordFormat format = (CsvRecordFormat)o;
        if (this.trimWhitespace != format.trimWhitespace) {
            return false;
        }
        if (!this.prefix.equals(format.prefix)) {
            return false;
        }
        if (!this.suffix.equals(format.suffix)) {
            return false;
        }
        if (!this.nullText.equals(format.nullText)) {
            return false;
        }
        if (!this.quotes.equals(format.quotes)) {
            return false;
        }
        if (this.quotationPolicy != format.quotationPolicy) {
            return false;
        }
        if (!this.valueSeparator.equals(format.valueSeparator)) {
            return false;
        }
        return this.recordSeparator.equals(format.recordSeparator);
    }

    public int hashCode() {
        int result = this.prefix.hashCode();
        result = 31 * result + this.suffix.hashCode();
        result = 31 * result + this.nullText.hashCode();
        result = 31 * result + this.quotes.hashCode();
        result = 31 * result + this.quotationPolicy.hashCode();
        result = 31 * result + this.valueSeparator.hashCode();
        result = 31 * result + this.recordSeparator.hashCode();
        result = 31 * result + (this.trimWhitespace ? 1 : 0);
        return result;
    }

    public static enum QuotationPolicy {
        ALWAYS,
        AS_NEEDED;

    }

    public static final class Quotes {
        public final String leftQuote;
        public final String rightQuote;
        public final String leftQuoteEscaped;
        public final String rightQuoteEscaped;

        public Quotes(@NotNull String leftQuote, @NotNull String rightQuote, @NotNull String leftQuoteEscaped, @NotNull String rightQuoteEscaped) {
            if (leftQuote == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftQuote", "com/intellij/database/csv/CsvRecordFormat$Quotes", "<init>"));
            }
            if (rightQuote == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightQuote", "com/intellij/database/csv/CsvRecordFormat$Quotes", "<init>"));
            }
            if (leftQuoteEscaped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftQuoteEscaped", "com/intellij/database/csv/CsvRecordFormat$Quotes", "<init>"));
            }
            if (rightQuoteEscaped == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightQuoteEscaped", "com/intellij/database/csv/CsvRecordFormat$Quotes", "<init>"));
            }
            this.leftQuote = leftQuote;
            this.rightQuote = rightQuote;
            this.leftQuoteEscaped = leftQuoteEscaped;
            this.rightQuoteEscaped = rightQuoteEscaped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Quotes)) {
                return false;
            }
            Quotes quotes = (Quotes)o;
            if (!this.leftQuote.equals(quotes.leftQuote)) {
                return false;
            }
            if (!this.rightQuote.equals(quotes.rightQuote)) {
                return false;
            }
            if (!this.leftQuoteEscaped.equals(quotes.leftQuoteEscaped)) {
                return false;
            }
            return this.rightQuoteEscaped.equals(quotes.rightQuoteEscaped);
        }

        public int hashCode() {
            int result = this.leftQuote.hashCode();
            result = 31 * result + this.rightQuote.hashCode();
            result = 31 * result + this.leftQuoteEscaped.hashCode();
            result = 31 * result + this.rightQuoteEscaped.hashCode();
            return result;
        }
    }
}

