/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.plan.ExplainPlanProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceExplainPlanConfiguration {
    public static final String ELEMENT_NAME = "explain-plan-config";
    @Nullable
    private String myProviderClass;
    @NotNull
    private Map<String, String> myProviderConfig = ContainerUtil.newHashMap();

    @Nullable
    public String getProviderClass() {
        return this.myProviderClass;
    }

    public void setProviderClass(@Nullable String providerClass) {
        this.myProviderClass = providerClass;
    }

    @NotNull
    public Map<String, String> getProviderConfig() {
        Map<String, String> map = this.myProviderConfig;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "getProviderConfig"));
        }
        return map;
    }

    public void setProviderConfig(@NotNull Map<String, String> providerConfig) {
        if (providerConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerConfig", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "setProviderConfig"));
        }
        this.myProviderConfig = providerConfig;
    }

    public boolean equalConfiguration(@NotNull DataSourceExplainPlanConfiguration cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "equalConfiguration"));
        }
        if (!Comparing.equal((String)this.myProviderClass, (String)cfg.myProviderClass)) {
            return false;
        }
        return ContainerUtil.diff(this.myProviderConfig, cfg.myProviderConfig).isEmpty();
    }

    public void serialize(@NotNull HierarchicalStreamWriter serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "serialize"));
        }
        if (!this.isEmpty()) {
            LocalDataSource.writeTag(serializer, "provider", this.myProviderClass);
            if (!this.myProviderConfig.isEmpty()) {
                serializer.startNode("parameters");
                for (Map.Entry<String, String> entry : this.myProviderConfig.entrySet()) {
                    serializer.startNode("parameter");
                    serializer.addAttribute("name", entry.getKey());
                    serializer.addAttribute("value", entry.getValue());
                    serializer.endNode();
                }
                serializer.endNode();
            }
        }
    }

    public void deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "deserialize"));
        }
        String providerClass = null;
        HashMap config = ContainerUtil.newHashMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String name = reader.getNodeName();
            if ("provider".equals(name)) {
                providerClass = reader.getValue();
            } else if ("parameters".equals(name)) {
                while (reader.hasMoreChildren()) {
                    String param;
                    reader.moveDown();
                    if ("parameter".equals(reader.getNodeName()) && (param = reader.getAttribute("name")) != null) {
                        config.put(param, reader.getAttribute("value"));
                    }
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        this.setProviderClass(providerClass);
        this.setProviderConfig(config);
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty((String)this.myProviderClass);
    }

    @NotNull
    public static String resetToDefaultIfInvalid(@Nullable String providerClass, @Nullable LocalDataSource dataSource) {
        String className = ExplainPlanProvider.getProviderByClassName(providerClass).getClass().getCanonicalName();
        if (className.equals(providerClass)) {
            String string = providerClass;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "resetToDefaultIfInvalid"));
            }
            return string;
        }
        String string = DataSourceExplainPlanConfiguration.getDefaultProviderClass(dataSource);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "resetToDefaultIfInvalid"));
        }
        return string;
    }

    @NotNull
    public static String getDefaultProviderClass(@Nullable LocalDataSource dataSource) {
        String string = ExplainPlanProvider.getDefaultProvider(dataSource).getClass().getCanonicalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceExplainPlanConfiguration", "getDefaultProviderClass"));
        }
        return string;
    }
}

