/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DbSrcPath {
    private final int mySize;
    private final List<String> myNames;
    private final List<String> myKinds;

    public DbSrcPath(@NotNull List<String> names, @NotNull List<String> kinds) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        this(names, kinds, names.size());
    }

    public DbSrcPath(@NotNull List<String> names, @NotNull List<String> kinds, int size) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        if (size > names.size() || size > kinds.size()) {
            throw new AssertionError((Object)"names and kinds less than size");
        }
        this.mySize = size;
        this.myNames = names;
        this.myKinds = kinds;
    }

    public int size() {
        return this.mySize;
    }

    public String getName() {
        return this.myNames.get(this.mySize - 1);
    }

    public String getKind() {
        return this.myKinds.get(this.mySize - 1);
    }

    public String name(int i) {
        return this.myNames.get(i);
    }

    public String kind(int i) {
        return this.myKinds.get(i);
    }

    public DbSrcPath getPath(int i) {
        if (i >= this.mySize) {
            throw new IndexOutOfBoundsException();
        }
        return new DbSrcPath(this.myNames, this.myKinds, i + 1);
    }

    @NotNull
    public Iterable<String> names() {
        JBIterable jBIterable = JBIterable.from(this.myNames).take(this.mySize);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "names"));
        }
        return jBIterable;
    }

    @NotNull
    public static DbSrcPath of(@NotNull DasObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "of"));
        }
        ArrayList names = ContainerUtil.newArrayList();
        ArrayList kinds = ContainerUtil.newArrayList();
        for (DasObject tmp = obj; tmp != null && tmp.getKind() != ObjectKind.NONE && tmp.getKind() != ObjectKind.ROOT; tmp = tmp.getDbParent()) {
            names.add(tmp.getName());
            kinds.add(tmp.getKind().code());
        }
        Collections.reverse(names);
        Collections.reverse(kinds);
        DbSrcPath dbSrcPath = new DbSrcPath(names, kinds);
        if (dbSrcPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "of"));
        }
        return dbSrcPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbSrcPath path = (DbSrcPath)o;
        if (!this.myNames.equals(path.myNames)) {
            return false;
        }
        return this.myKinds.equals(path.myKinds);
    }

    public int hashCode() {
        int result = this.myNames.hashCode();
        result = 31 * result + this.myKinds.hashCode();
        return result;
    }

    public String toString() {
        return StringUtil.join((Iterable)JBIterable.generate((Object)0, i -> i + 1).take(this.size()).transform(i -> this.myNames.get((int)i) + ":" + this.myKinds.get((int)i)), (String)", ");
    }
}

