/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageDsMetadata
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageDsMetadata.class);
    private final PersistentHashMap<DbSrcPath, MetaData> myObjects;

    public DbSrcStorageDsMetadata(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "<init>"));
        }
        this.myObjects = new PersistentHashMap(file, (KeyDescriptor)new KeyDescriptor<DbSrcPath>(){

            public int getHashCode(DbSrcPath value) {
                return Comparing.hashcode((Object)value);
            }

            public boolean isEqual(DbSrcPath val1, DbSrcPath val2) {
                return Comparing.equal((Object)val1, (Object)val2);
            }

            public void save(@NotNull DataOutput out, DbSrcPath value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$1", "save"));
                }
                int size = value.size();
                out.write(size);
                for (int i = 0; i < size; ++i) {
                    out.writeUTF(value.name(i));
                    out.writeUTF(value.kind(i));
                }
            }

            public DbSrcPath read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$1", "read"));
                }
                int size = in.readInt();
                ArrayList names = ContainerUtil.newArrayListWithCapacity((int)size);
                ArrayList kinds = ContainerUtil.newArrayListWithCapacity((int)size);
                for (int i = 0; i < size; ++i) {
                    names.add(DbUtil.intern((String)in.readUTF()));
                    kinds.add(DbUtil.intern((String)in.readUTF()));
                }
                return new DbSrcPath(names, kinds);
            }
        }, (DataExternalizer)new DataExternalizer<MetaData>(){

            public void save(@NotNull DataOutput out, MetaData value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$2", "save"));
                }
                out.writeUTF(value.srcVersion);
            }

            public MetaData read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$2", "read"));
                }
                return new MetaData(in.readUTF());
            }
        });
    }

    @Nullable
    public MetaData getMetaData(@NotNull DbSrcPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "getMetaData"));
        }
        try {
            return (MetaData)this.myObjects.get((Object)path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void putMetaData(@NotNull DbSrcPath object, @Nullable MetaData data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "putMetaData"));
        }
        try {
            if (data == null || data.equals(MetaData.EMPTY)) {
                this.myObjects.remove((Object)object);
            } else {
                this.myObjects.put((Object)object, (Object)data);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.myObjects.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static final class MetaData {
        private static MetaData EMPTY = new MetaData(null);
        public final String srcVersion;

        public MetaData(String srcVersion) {
            this.srcVersion = srcVersion;
        }
    }
}

