/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbSrcStorageLayout {
    @NotNull
    public abstract String getId();

    @NotNull
    public abstract Item getLocation(@NotNull VirtualFile var1, @NotNull DbSrcPath var2);

    @Nullable
    public abstract DbSrcPath getObject(@NotNull VirtualFile var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract Iterable<DbSrcPath> getExistingChildren(@NotNull VirtualFile var1, @Nullable DbSrcPath var2);

    @NotNull
    public abstract DbSrcStorage.FsAccess getFsAccess();

    @NotNull
    public static Item convert(@NotNull Item src, @NotNull DbSrcStorageLayout tgt, @NotNull VirtualFile root) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayout", "convert"));
        }
        if (tgt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tgt", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayout", "convert"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayout", "convert"));
        }
        Item item = tgt.getLocation(root, src.getObject());
        if (item == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayout", "convert"));
        }
        return item;
    }

    public static interface Item {
        @NotNull
        public DbSrcStorageLayout getLayout();

        @NotNull
        public DbSrcPath getObject();

        @Nullable
        public VirtualFile getSrcFile();

        @NotNull
        public String getSrcPath();

        public boolean hasChildren();

        @NotNull
        public OutputStream getOutputStream(@Nullable Object var1) throws IOException;
    }
}

