/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageLayouts {
    public static final Map<String, Function<DbSrcStorage.FsAccess, DbSrcStorageLayout>> ourLayouts = ContainerUtil.immutableMapBuilder().put((Object)"schema-zip", SchemaZipLayout::new).put((Object)"plain", PlainLayout::new).build();
    public static final String[] ESCAPE_FROM = new String[]{"/", "&", ".", "!"};
    public static final String[] ESCAPE_TO = new String[]{"&slash;", "&amp;", "&dot;", "&#33;"};

    @Nullable
    public static DbSrcStorageLayout createLayout(@Nullable String id, @NotNull DbSrcStorage.FsAccess fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts", "createLayout"));
        }
        Function<DbSrcStorage.FsAccess, DbSrcStorageLayout> function = ourLayouts.get(id);
        return function == null ? null : (DbSrcStorageLayout)function.fun((Object)fs);
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        return StringUtil.replace((String)s, (String[])ESCAPE_FROM, (String[])ESCAPE_TO);
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return StringUtil.replace((String)s, (String[])ESCAPE_TO, (String[])ESCAPE_FROM);
    }

    public static abstract class PathLayout
    extends DbSrcStorageLayout {
        private final DbSrcStorage.FsAccess myFsAccess;

        public PathLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "<init>"));
            }
            this.myFsAccess = fs;
        }

        @Override
        @NotNull
        public DbSrcStorageLayout.Item getLocation(@NotNull VirtualFile root, @NotNull DbSrcPath object) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            Pair<String, String> path = this.buildPath(object, true);
            Pair<String, String> path2 = this.buildPath(object, false);
            String rootPath = root.getPath();
            FileItem fileItem = new FileItem((Pair<String, String>)Pair.create((Object)(rootPath + "/" + (String)path.first), (Object)path.second), object, (Pair<String, String>)Pair.create((Object)(rootPath + "/" + (String)path2.first), (Object)path2.second), this);
            if (fileItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            return fileItem;
        }

        @NotNull
        protected abstract Pair<String, String> buildPath(@Nullable DbSrcPath var1, boolean var2);

        @Nullable
        protected VirtualFile compose(@NotNull VirtualFile root, @Nullable Pair<String, String> path) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "compose"));
            }
            if (path == null || !root.isValid()) {
                return null;
            }
            VirtualFile local = root.findFileByRelativePath((String)path.first);
            if (local == null || !local.isValid()) {
                return null;
            }
            if (path.second == null) {
                return local;
            }
            VirtualFile zip = this.getZipRoot(local);
            return zip == null || !zip.isValid() ? null : zip.findFileByRelativePath((String)path.second);
        }

        @Nullable
        protected VirtualFile getZipRoot(@NotNull VirtualFile f) {
            if (f == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getZipRoot"));
            }
            return this.myFsAccess.getJarRootForLocalFile(f);
        }

        @Override
        @Nullable
        public DbSrcPath getObject(@NotNull VirtualFile root, @NotNull VirtualFile file) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getObject"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getObject"));
            }
            Pair<List<String>, List<String>> path = this.splitPath(root.getPath(), file.getPath());
            if (path == null) {
                return null;
            }
            return this.detectObject((List)path.first, (List)path.second);
        }

        @Nullable
        protected abstract DbSrcPath detectObject(@NotNull List<String> var1, @Nullable List<String> var2);

        @Override
        @NotNull
        public DbSrcStorage.FsAccess getFsAccess() {
            DbSrcStorage.FsAccess fsAccess = this.myFsAccess;
            if (fsAccess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getFsAccess"));
            }
            return fsAccess;
        }

        @Nullable
        protected Pair<List<String>, List<String>> splitPath(@NotNull String root, @NotNull String child) {
            String zipPath;
            String localPath;
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "splitPath"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "splitPath"));
            }
            if (!child.startsWith(root)) {
                return null;
            }
            if (child.length() == root.length()) {
                return Pair.create(Collections.emptyList(), null);
            }
            if (root.endsWith("/")) {
                child = child.substring(root.length());
            } else if (child.charAt(root.length()) == '/') {
                child = child.substring(root.length() + 1);
            } else {
                return null;
            }
            int idx = child.indexOf("!/");
            if (idx != -1) {
                localPath = child.substring(0, idx);
                zipPath = child.substring(idx + "!/".length());
            } else {
                localPath = child;
                zipPath = null;
            }
            return Pair.create(PathLayout.splitPath(localPath), PathLayout.splitPath(zipPath));
        }

        @Contract(value="null->null")
        private static List<String> splitPath(@Nullable String localPath) {
            if (localPath == null) {
                return null;
            }
            return localPath.isEmpty() ? Collections.emptyList() : FileUtil.splitPath((String)localPath);
        }
    }

    public static abstract class UniformPathLayout
    extends PathLayout {
        public UniformPathLayout(DbSrcStorage.FsAccess fs) {
            super(fs);
        }

        @Override
        @Nullable
        protected DbSrcPath detectObject(@NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "detectObject"));
            }
            Iterable<String> path = this.glue(null, local, zip);
            if (path == null) {
                return null;
            }
            return this.detectObject(null, path);
        }

        @Nullable
        protected abstract DbSrcPath detectObject(@Nullable DbSrcPath var1, @NotNull Iterable<String> var2);

        @Nullable
        protected abstract Iterable<String> glue(@Nullable DbSrcPath var1, @NotNull List<String> var2, @Nullable List<String> var3);

        @Override
        @NotNull
        public Iterable<DbSrcPath> getExistingChildren(@NotNull VirtualFile root, @Nullable DbSrcPath object) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            Pair<String, String> path = this.buildPath(object, false);
            VirtualFile file = this.compose(root, path);
            if (file == null) {
                List<DbSrcPath> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
                }
                return list;
            }
            JBIterable<VirtualFile> children = this.getExistingChildren(object, file);
            Set set = children.transform(f -> {
                Pair<List<String>, List<String>> subPath = this.splitPath(file.getPath(), f.getPath());
                if (subPath == null) {
                    return null;
                }
                Iterable<String> sub = this.glue(object, (List)subPath.first, (List)subPath.second);
                if (sub == null) {
                    return null;
                }
                return this.detectObject(object, sub);
            }).filter(Conditions.notNull()).toSet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            return set;
        }

        @NotNull
        protected abstract JBIterable<VirtualFile> getExistingChildren(@Nullable DbSrcPath var1, @NotNull VirtualFile var2);
    }

    public static abstract class GroupedByKindLayout
    extends UniformPathLayout {
        private final String myZipStart;

        public GroupedByKindLayout(@Nullable String zipStart, DbSrcStorage.FsAccess fs) {
            super(fs);
            this.myZipStart = zipStart;
        }

        @Override
        @Nullable
        protected DbSrcPath detectObject(@Nullable DbSrcPath parent, @NotNull Iterable<String> path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "detectObject"));
            }
            if (!path.iterator().hasNext()) {
                return parent;
            }
            ArrayList kinds = ContainerUtil.newArrayListWithCapacity((int)(parent == null ? 1 : parent.size() + 1));
            ArrayList names = ContainerUtil.newArrayListWithCapacity((int)(parent == null ? 1 : parent.size() + 1));
            if (parent != null) {
                for (int i = 0; i < parent.size(); ++i) {
                    kinds.add(parent.kind(i));
                    names.add(parent.name(i));
                }
            }
            Iterator<String> it = path.iterator();
            while (it.hasNext()) {
                kinds.add(it.next());
                if (!it.hasNext()) {
                    return null;
                }
                names.add(it.next());
            }
            return names.isEmpty() ? null : new DbSrcPath(names, kinds);
        }

        @Override
        @Nullable
        protected Iterable<String> glue(@Nullable DbSrcPath parent, @NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "glue"));
            }
            if (zip == null) {
                String last = (String)ContainerUtil.getLastItem(local);
                if (last != null && last.endsWith(".zip")) {
                    return null;
                }
                return JBIterable.from(GroupedByKindLayout.trimExt(local, ".sql")).transform(s -> DbSrcStorageLayouts.unescape(s));
            }
            if (local.isEmpty()) {
                return JBIterable.from(GroupedByKindLayout.trimExt(zip, ".sql")).transform(s -> DbSrcStorageLayouts.unescape(s));
            }
            return JBIterable.from(GroupedByKindLayout.trimExt(local, ".zip")).append(GroupedByKindLayout.trimExt(zip, ".sql")).transform(s -> DbSrcStorageLayouts.unescape(s));
        }

        @NotNull
        private static Iterable<String> trimExt(@NotNull List<String> list, @NotNull String ext) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            if (ext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            String last = (String)ContainerUtil.getLastItem(list);
            if (last == null) {
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
                }
                return list2;
            }
            if (!last.endsWith(ext)) {
                List<String> list3 = list;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
                }
                return list3;
            }
            JBIterable jBIterable = JBIterable.from(list).take(list.size() - 1).append((Object)StringUtil.trimEnd((String)last, (String)ext));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected JBIterable<VirtualFile> getExistingChildren(@Nullable DbSrcPath object, @NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingChildren"));
            }
            JBIterable jBIterable = JBIterable.of((Object[])file.getChildren()).flatten(f -> JBIterable.of((Object[])f.getChildren())).transform(f -> f.getName().endsWith(".zip") ? this.getZipRoot((VirtualFile)f) : f).filter(Conditions.notNull());
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingChildren"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected Pair<String, String> buildPath(@Nullable DbSrcPath object, boolean src) {
            if (object == null) {
                Pair pair = Pair.create((Object)"", null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
                }
                return pair;
            }
            StringBuilder res = new StringBuilder();
            String local = null;
            int end = object.size();
            for (int i = 0; i < end; ++i) {
                String kind = object.kind(i);
                String name = object.name(i);
                if (res.length() != 0) {
                    res.append("/");
                }
                res.append(DbSrcStorageLayouts.escape(kind)).append("/").append(DbSrcStorageLayouts.escape(name));
                if (!kind.equals(this.myZipStart) || i == end - 1 && src) continue;
                if (local != null) {
                    throw new AssertionError((Object)"passed zip start twice");
                }
                res.append(".zip");
                local = res.toString();
                res.setLength(0);
            }
            if (src) {
                res.append(".sql");
            }
            Pair pair = local == null ? Pair.create((Object)res.toString(), null) : Pair.create(local, (Object)res.toString());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
            }
            return pair;
        }
    }

    public static class SchemaZipLayout
    extends GroupedByKindLayout {
        public static final String ID = "schema-zip";

        public SchemaZipLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$SchemaZipLayout", "<init>"));
            }
            super(ObjectKind.SCHEMA.code(), fs);
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$SchemaZipLayout", "getId"));
            }
            return ID;
        }
    }

    public static class PlainLayout
    extends GroupedByKindLayout {
        public static final String ID = "plain";

        public PlainLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PlainLayout", "<init>"));
            }
            super(null, fs);
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PlainLayout", "getId"));
            }
            return ID;
        }
    }

    public static class FileItem
    implements DbSrcStorageLayout.Item {
        protected final Pair<String, String> myPath;
        protected final Pair<String, String> myChildrenPath;
        private final DbSrcPath myObject;
        protected final DbSrcStorageLayout myLayout;

        public FileItem(@NotNull Pair<String, String> path, @NotNull DbSrcPath object, @Nullable Pair<String, String> childrenPath, @NotNull DbSrcStorageLayout layout) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            if (layout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            this.myPath = path;
            this.myChildrenPath = childrenPath;
            this.myObject = object;
            this.myLayout = layout;
        }

        @Override
        @NotNull
        public DbSrcStorageLayout getLayout() {
            DbSrcStorageLayout dbSrcStorageLayout = this.myLayout;
            if (dbSrcStorageLayout == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getLayout"));
            }
            return dbSrcStorageLayout;
        }

        @Override
        @NotNull
        public DbSrcPath getObject() {
            DbSrcPath dbSrcPath = this.myObject;
            if (dbSrcPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getObject"));
            }
            return dbSrcPath;
        }

        @Override
        @Nullable
        public VirtualFile getSrcFile() {
            return this.toVirtualFile(this.myPath);
        }

        @Override
        public boolean hasChildren() {
            return this.toVirtualFile(this.myChildrenPath) != null;
        }

        @Nullable
        private VirtualFile toVirtualFile(@Nullable Pair<String, String> path) {
            if (path == null) {
                return null;
            }
            VirtualFile local = this.myLayout.getFsAccess().findFileByPath((String)path.first);
            if (local == null || path.second == null) {
                return local;
            }
            VirtualFile root = this.myLayout.getFsAccess().getJarRootForLocalFile(local);
            if (root == null) {
                return null;
            }
            return root.findFileByRelativePath((String)path.second);
        }

        @Override
        @NotNull
        public OutputStream getOutputStream(final @Nullable Object requestor) throws IOException {
            if (this.myPath.second == null) {
                OutputStream outputStream = FileItem.ensureExists(this.myLayout.getFsAccess(), (String)this.myPath.first, requestor).getOutputStream(requestor);
                if (outputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getOutputStream"));
                }
                return outputStream;
            }
            final BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            final int idx = ((String)this.myPath.second).indexOf(47);
            final String subName = idx == -1 ? (String)this.myPath.second : ((String)this.myPath.second).substring(0, idx);
            OutputStream outputStream = new OutputStream(){
                private FileSystem myFs = null;
                private OutputStream myOutputStream = null;
                {
                    Files.createDirectories(FileSystems.getDefault().getPath((String)myPath.first, new String[0]).getParent(), new FileAttribute[0]);
                    this.myFs = FileSystems.newFileSystem(URI.create("jar:file:" + (String)myPath.first), Collections.singletonMap("create", "true"));
                    try {
                        Path path = this.myFs.getPath((String)myPath.second, new String[0]);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        this.myOutputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);
                    }
                    finally {
                        if (this.myOutputStream == null) {
                            this.myFs.close();
                        }
                    }
                }

                @Override
                public void write(int b) throws IOException {
                    this.myOutputStream.write(b);
                }

                @Override
                public void close() throws IOException {
                    VirtualFile root;
                    try {
                        this.myOutputStream.close();
                    }
                    finally {
                        this.myFs.close();
                    }
                    VirtualFile zip = myLayout.getFsAccess().findFileByPath((String)myPath.first);
                    VirtualFile virtualFile = root = zip == null ? null : myLayout.getFsAccess().getJarRootForLocalFile(zip);
                    if (root != null) {
                        root = root.findFileByRelativePath((String)myPath.second);
                    }
                    if (root != null) {
                        List<VFileCreateEvent> events = Collections.singletonList(new VFileCreateEvent(requestor, root, subName, idx != -1, false));
                        publisher.before(events);
                        publisher.after(events);
                    }
                }
            };
            if (outputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getOutputStream"));
            }
            return outputStream;
        }

        @Override
        @NotNull
        public String getSrcPath() {
            String string = this.myPath.second == null ? (String)this.myPath.first : (String)this.myPath.first + "!/" + (String)this.myPath.second;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getSrcPath"));
            }
            return string;
        }

        @NotNull
        protected static VirtualFile ensureExists(@NotNull DbSrcStorage.FsAccess fs, @NotNull String filePath, @Nullable Object requestor) throws IOException {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExists"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExists"));
            }
            VirtualFile path = fs.findFileByPath(filePath);
            if (path == null) {
                VirtualFile parent;
                String dir = VfsUtil.getParentDir((String)filePath);
                VirtualFile virtualFile = parent = dir == null ? null : VfsUtil.createDirectories((String)dir);
                if (parent == null) {
                    throw new IOException("Directory creation failed");
                }
                path = parent.findOrCreateChildData(requestor, PathUtil.getFileName((String)filePath));
            }
            VirtualFile virtualFile = path;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExists"));
            }
            return virtualFile;
        }
    }
}

