/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseGridDataHookUp
extends DataBusGridDataHookUp
implements DataRequest.OwnerEx {
    protected final DatabaseMutator myMutator;
    private DasTable myDatabaseTable;
    private DbDataSource myDataSource;
    private SqlTableType myTableType;
    private boolean myReadOnly;

    DatabaseGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "<init>"));
        }
        super(project, messageBus);
        this.myMutator = new DatabaseMutator();
    }

    @Nullable
    public DatabaseMutator getMutator() {
        return this.myMutator;
    }

    @Override
    @NotNull
    protected DatabaseLoader createLoader() {
        DatabaseLoader databaseLoader = new DatabaseLoader();
        if (databaseLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "createLoader"));
        }
        return databaseLoader;
    }

    @Override
    public boolean isReadOnly() {
        if (this.myReadOnly) {
            return true;
        }
        DbDataSource dataSource = this.getDataSource();
        if (dataSource == null || !dataSource.isWritable()) {
            return true;
        }
        ObjectKind kind = this.myDatabaseTable != null ? this.myDatabaseTable.getKind() : null;
        return kind != ObjectKind.TABLE;
    }

    @Nullable
    public DasTable getDatabaseTable() {
        if (this.myDatabaseTable instanceof DbElement) {
            return ((DbElement)this.myDatabaseTable).isValid() ? this.myDatabaseTable : null;
        }
        return this.myDatabaseTable;
    }

    public void setDatabaseTable(@Nullable DasTable databaseTable) {
        this.myDatabaseTable = databaseTable;
    }

    @Nullable
    public DbDataSource getDataSource() {
        if (this.myDataSource != null && this.myDataSource.isValid()) {
            return this.myDataSource;
        }
        DasTable dbTable = this.getDatabaseTable();
        return dbTable instanceof DbElement ? ((DbElement)dbTable).getDataSource() : null;
    }

    public void setDataSource(@Nullable DbDataSource dataSource) {
        this.myDataSource = dataSource;
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DbDataSource dataSource = this.getDataSource();
        DatabaseDialectEx databaseDialectEx = dataSource != null ? DbImplUtil.getDatabaseDialect((DbElement)dataSource) : GenericDialect.INSTANCE;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    private DatabaseDialectEx getDatabaseDialectForSelectQuery() {
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        DbDataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            DatabaseDialectEx databaseDialectEx = dialect;
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "getDatabaseDialectForSelectQuery"));
            }
            return databaseDialectEx;
        }
        RawConnectionConfig config = dataSource.getConnectionConfig();
        if (dialect != GenericDialect.INSTANCE || config == null) {
            DatabaseDialectEx databaseDialectEx = dialect;
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "getDatabaseDialectForSelectQuery"));
            }
            return databaseDialectEx;
        }
        String url = config.getUrl();
        DatabaseDialectEx databaseDialectEx = StringUtil.containsIgnoreCase((String)url, (String)"redshift") ? PostgresDialect.INSTANCE : dialect;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp", "getDatabaseDialectForSelectQuery"));
        }
        return databaseDialectEx;
    }

    @Nullable
    public DasColumn getDatabaseColumn(@Nullable DataConsumer.Column column) {
        if (column == null) {
            return null;
        }
        DasTable dasTable = this.getDatabaseTable();
        return dasTable != null ? (DasColumn)JBIterable.from((Iterable)DasUtil.getColumns((DasObject)dasTable)).filter(DasUtil.byName((String)column.name)).first() : null;
    }

    @Nullable
    public SqlTableType getTableType() {
        if (this.myTableType == null || this.myTableType.getColumnCount() != this.myModel.getColumnCount()) {
            return null;
        }
        List columns = this.myModel.getColumns();
        for (DataConsumer.Column column : columns) {
            String nameFromColumn;
            String nameFromType = StringUtil.nullize((String)this.myTableType.getColumnName(column.columnNum));
            if (StringUtil.equals((CharSequence)nameFromType, (CharSequence)(nameFromColumn = StringUtil.nullize((String)column.name)))) continue;
            return null;
        }
        return this.myTableType;
    }

    protected class DatabaseMutator
    implements GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> {
        private ModelIndex<DataConsumer.Row> myInsertedRowIndex;

        protected DatabaseMutator() {
            this.myInsertedRowIndex = ModelIndex.forRow(DatabaseGridDataHookUp.this.myModel, -1);
        }

        @Override
        public void update(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "update"));
            }
            if (rowIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "update"));
            }
            if (columnIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "update"));
            }
            if (DatabaseGridDataHookUp.this.isReadOnly() || DatabaseGridDataHookUp.this.myModel.allValuesEqualTo(rowIndices, columnIndices, newValue)) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, !DatabaseGridDataHookUp.this.isReadOnly());
                return;
            }
            if (this.myInsertedRowIndex.isValid(DatabaseGridDataHookUp.this.myModel) && rowIndices.asIterable().contains(this.myInsertedRowIndex)) {
                DatabaseGridDataHookUp.this.myModel.setValueAt(ModelIndexSet.forRows(DatabaseGridDataHookUp.this.myModel, this.myInsertedRowIndex.asInteger()), columnIndices, newValue);
            }
            List<DataConsumer.Column> columnsToUpdate = this.getPhysicalColumns(columnIndices);
            List<DataConsumer.Row> rowsToUpdate = this.getPhysicalRows(rowIndices);
            if (columnsToUpdate.isEmpty() || rowsToUpdate.isEmpty()) {
                DatabaseGridDataHookUp.this.notifyUpdateCountReceived(source, rowIndices.size());
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, true);
                return;
            }
            DasTable table = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (table == null) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            List<DataConsumer.Column> allColumns = DatabaseGridDataHookUp.this.myModel.getColumns();
            DatabaseGridDataHookUp owner = DatabaseGridDataHookUp.this;
            DataRequest request = DataRequest.newUpdateRequest((DataRequest.OwnerEx)owner, table, allColumns, rowsToUpdate, columnsToUpdate, newValue);
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.WHEN_PROCESSED);
        }

        @Override
        public boolean isUpdateSafe(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue) {
            if (rowIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "isUpdateSafe"));
            }
            if (columnIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "isUpdateSafe"));
            }
            if (!this.hasPendingChanges()) {
                return true;
            }
            ModelIndex materialRow = (ModelIndex)rowIndices.asIterable().filter(index -> !this.myInsertedRowIndex.equals(index)).first();
            return materialRow == null || DatabaseGridDataHookUp.this.myModel.allValuesEqualTo(rowIndices, columnIndices, newValue);
        }

        @Override
        public boolean hasPendingChanges() {
            return this.myInsertedRowIndex.isValid(DatabaseGridDataHookUp.this.myModel);
        }

        @Override
        public void deleteRows(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "deleteRows"));
            }
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "deleteRows"));
            }
            if (DatabaseGridDataHookUp.this.isReadOnly()) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            List<DataConsumer.Row> rowsToDelete = this.getPhysicalRows(rows);
            DatabaseGridDataHookUp.this.myModel.removeRows(rows);
            if (rowsToDelete.isEmpty()) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, true);
                return;
            }
            DasTable table = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (table == null) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            List<DataConsumer.Column> columns = DatabaseGridDataHookUp.this.myModel.getColumns();
            DataRequest request = DataRequest.newDeleteRequest(DatabaseGridDataHookUp.this, table, columns, rowsToDelete);
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.WHEN_PROCESSED);
        }

        @Override
        public void insertRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "insertRow"));
            }
            if (!DatabaseGridDataHookUp.this.isReadOnly() && !this.myInsertedRowIndex.isValid(DatabaseGridDataHookUp.this.myModel)) {
                this.doInsertRow(this.createRow(null));
            }
            DatabaseGridDataHookUp.this.notifyRequestFinished(source, !DatabaseGridDataHookUp.this.isReadOnly());
        }

        @Override
        public void cloneRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Row> toClone) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "cloneRow"));
            }
            if (toClone == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toClone", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "cloneRow"));
            }
            DataConsumer.Row rowToClone = DatabaseGridDataHookUp.this.myModel.getRow(toClone);
            if (DatabaseGridDataHookUp.this.isReadOnly() || rowToClone == null) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DataConsumer.Row newRow = this.createRow(rowToClone);
            if (this.myInsertedRowIndex.isValid(DatabaseGridDataHookUp.this.myModel)) {
                DatabaseGridDataHookUp.this.myModel.setRows(this.myInsertedRowIndex.asInteger(), ContainerUtil.newSmartList((Object)newRow));
            } else {
                this.doInsertRow(newRow);
            }
            DatabaseGridDataHookUp.this.notifyRequestFinished(source, true);
        }

        private void doInsertRow(@NotNull DataConsumer.Row newRow) {
            if (newRow == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRow", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "doInsertRow"));
            }
            int newRowIdx = DatabaseGridDataHookUp.this.myModel.getRowCount();
            this.myInsertedRowIndex = ModelIndex.forRow(DatabaseGridDataHookUp.this.myModel, newRowIdx);
            DatabaseGridDataHookUp.this.myModel.addRows(ContainerUtil.newSmartList((Object)newRow));
        }

        @NotNull
        protected DataConsumer.Row createRow(@Nullable DataConsumer.Row template) {
            DataConsumer.Row newRow = new DataConsumer.Row(DatabaseGridDataHookUp.this.myPageModel.getPageEnd() + 1, new Object[DatabaseGridDataHookUp.this.myModel.getColumnCount()]);
            for (DataConsumer.Column column : DatabaseGridDataHookUp.this.myModel.getColumns()) {
                Object existing;
                DasColumn dbColumn = DatabaseGridDataHookUp.this.getDatabaseColumn(column);
                Object object = existing = template == null ? null : column.getValue(template);
                ReservedCellValue value = DbImplUtil.isComputedColumn(column) ? ReservedCellValue.GENERATED : (template != null && !DasUtil.isPrimary((DasColumn)dbColumn) ? existing : DataGridUtil.getDefaultNullValue(dbColumn));
                column.setValue(newRow, (Object)value);
            }
            DataConsumer.Row row = newRow;
            if (row == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "createRow"));
            }
            return row;
        }

        @Override
        @NotNull
        public ModelIndex<DataConsumer.Row> getInsertedRow() {
            ModelIndex<DataConsumer.Row> modelIndex = this.myInsertedRowIndex;
            if (modelIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "getInsertedRow"));
            }
            return modelIndex;
        }

        @Override
        public void submitInsertedRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "submitInsertedRow"));
            }
            DasTable table = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (DatabaseGridDataHookUp.this.isReadOnly() || !this.myInsertedRowIndex.isValid(DatabaseGridDataHookUp.this.myModel) || table == null) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            List rowToInsert = ContainerUtil.newSmartList((Object)ObjectUtils.assertNotNull((Object)DatabaseGridDataHookUp.this.myModel.getRow(this.myInsertedRowIndex)));
            List<DataConsumer.Column> columns = this.getPhysicalColumns(DatabaseGridDataHookUp.this.myModel.getColumnIndices());
            DataRequest request = DataRequest.newInsertRequest(DatabaseGridDataHookUp.this, table, columns, rowToInsert);
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.WHEN_DONE);
        }

        public void clearPendingChanges() {
            this.myInsertedRowIndex = ModelIndex.forRow(DatabaseGridDataHookUp.this.myModel, -1);
        }

        @NotNull
        protected List<DataConsumer.Row> getPhysicalRows(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices) {
            if (rowIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "getPhysicalRows"));
            }
            List list = rowIndices.asIterable().transform(rowIndex -> this.myInsertedRowIndex.isValid(DatabaseGridDataHookUp.this.myModel) && this.myInsertedRowIndex.equals(rowIndex) ? null : (DataConsumer.Row)DatabaseGridDataHookUp.this.myModel.getRow(rowIndex)).filter(Condition.NOT_NULL).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "getPhysicalRows"));
            }
            return list;
        }

        @NotNull
        protected List<DataConsumer.Column> getPhysicalColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnIndices) {
            if (columnIndices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "getPhysicalColumns"));
            }
            List list = columnIndices.asIterable().transform(columnIndex -> {
                DataConsumer.Column column = (DataConsumer.Column)DatabaseGridDataHookUp.this.myModel.getColumn(columnIndex);
                return DbImplUtil.isComputedColumn(column) ? null : column;
            }).filter(Condition.NOT_NULL).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseMutator", "getPhysicalColumns"));
            }
            return list;
        }
    }

    public class DatabaseLoader
    extends DataBusGridDataHookUp.DataBusLoader {
        private boolean myLastColumnIsRowId;

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "setColumns"));
            }
            boolean sameQuery = Comparing.equal((String)this.getQueryText(), (String)context.getQuery());
            DatabaseGridDataHookUp.this.myReadOnly = sameQuery ? DatabaseGridDataHookUp.this.myReadOnly : !DbSqlUtil.isResultEditable(context.request, DatabaseGridDataHookUp.this.myDatabaseTable);
            ConsoleDataRequest request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
            DatabaseGridDataHookUp.this.myTableType = request != null ? (SqlTableType)ObjectUtils.tryCast((Object)request.resultType, SqlTableType.class) : null;
            DatabaseGridDataHookUp.this.myMutator.clearPendingChanges();
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
        }

        @Override
        protected DataConsumer.Column[] prepareColumns(@NotNull DataConsumer.Column[] columns) {
            if (columns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "prepareColumns"));
            }
            for (int i = 0; i < columns.length; ++i) {
                DataConsumer.Column column = columns[i];
                DasColumn databaseColumn = DatabaseGridDataHookUp.this.getDatabaseColumn(column);
                if (databaseColumn != null && (column.type == 0 || column.type == 1111)) {
                    columns[column.columnNum] = column = new DataConsumer.Column(column.columnNum, column.name, databaseColumn.getDataType().jdbcType, column.typeName, column.clazz);
                    continue;
                }
                if (i != columns.length - 1 || !this.myLastColumnIsRowId) continue;
                columns[i] = DbImplUtil.makeComputedColumn(column);
            }
            return columns;
        }

        @Override
        protected void setQueryText(String query) {
            super.setQueryText(query);
            boolean updateable = StringUtil.isNotEmpty((String)query) && DbImplUtil.createSelectCountQuery(DatabaseGridDataHookUp.this.getProject(), DatabaseGridDataHookUp.this.getDatabaseDialect(), query, null) != null;
            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCountUpdateable(updateable);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "updateTotalRowCount"));
            }
            this.updateQueryText(null);
            if (!DatabaseGridDataHookUp.this.myPageModel.isTotalRowCountUpdateable()) {
                DatabaseGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            final String countQuery = (String)ObjectUtils.assertNotNull((Object)DbImplUtil.createSelectCountQuery(DatabaseGridDataHookUp.this.getProject(), DatabaseGridDataHookUp.this.getDatabaseDialect(), this.getQueryText(), DatabaseGridDataHookUp.this.getDataSource()));
            DataRequest.RawRequest request = new DataRequest.RawRequest(DatabaseGridDataHookUp.this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void processRaw(DataRequest.Context context, Connection connection) throws Exception {
                    Statement statement = connection.createStatement();
                    try {
                        boolean resultSetAvailable = statement.execute(countQuery);
                        if (!resultSetAvailable) {
                            throw new AssertionError((Object)"Incorrect count query!");
                        }
                        ResultSet resultSet = statement.getResultSet();
                        try {
                            if (!resultSet.next()) {
                                throw new AssertionError((Object)"Incorrect count query!");
                            }
                            DatabaseGridDataHookUp.this.myPageModel.setTotalRowCount(resultSet.getInt(1), true);
                        }
                        finally {
                            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
                        }
                    }
                    finally {
                        JdbcUtil.closeStatementSafe((Statement)statement);
                    }
                }
            };
            DatabaseGridDataHookUp.this.processRequest(source, request, DataBusGridDataHookUp.ReloadPolicy.DO_NOT_RELOAD);
        }

        @Override
        protected boolean canUpdateQueryText() {
            return DatabaseGridDataHookUp.this.getDatabaseTable() != null && (this.getQueryText() == null || this.isQueryInvalidated());
        }

        @Override
        @Nullable
        protected String createQueryText(@Nullable Integer limit) {
            Pair<String, Boolean> pure = this.createQueryTextPure(limit);
            if (pure == null) {
                return null;
            }
            this.myLastColumnIsRowId = (Boolean)pure.getSecond();
            return (String)pure.getFirst();
        }

        @Nullable
        public Pair<String, Boolean> createQueryTextPure(@Nullable Integer limit) {
            DasTable dbTable = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (dbTable == null) {
                return null;
            }
            DatabaseDialectEx forQuery = DatabaseGridDataHookUp.this.getDatabaseDialectForSelectQuery();
            DdlBuilder builder = limit != null ? DbImplUtil.createSelectAllQuery(dbTable, forQuery, (Consumer<DdlBuilder>)((Consumer)this::appendOrderByClause), this::appendWhereClause, this::appendRowId, limit) : this.createUnlimitedBuilder(forQuery, dbTable);
            DatabaseDialectEx dbDialect = DatabaseGridDataHookUp.this.getDatabaseDialect();
            return Pair.create((Object)builder.getStatement(), (Object)this.hasRowId(dbTable, dbDialect));
        }

        @NotNull
        private DdlBuilder createUnlimitedBuilder(@NotNull DatabaseDialectEx dialect, @NotNull DasTable table) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "createUnlimitedBuilder"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "createUnlimitedBuilder"));
            }
            DdlBuilder builder = DbImplUtil.createSelectAllQuery(table, dialect, this::appendRowId);
            this.appendWhereClause(null, builder);
            this.appendOrderByClause(builder);
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "createUnlimitedBuilder"));
            }
            return ddlBuilder;
        }

        private boolean hasRowId(@NotNull DasTable dbTable, @NotNull DatabaseDialectEx dialect) {
            if (dbTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbTable", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "hasRowId"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "hasRowId"));
            }
            if (dbTable.getKind() != ObjectKind.TABLE || DasUtil.getPrimaryKey((DasTable)dbTable) != null) {
                return false;
            }
            DbDataSource source = DatabaseGridDataHookUp.this.getDataSource();
            String productVersion = source == null ? "" : StringUtil.notNullize((String)source.getDatabaseProductVersion());
            DatabaseFamilyId id = dialect.getFamilyId();
            Version version = Version.parseVersion((String)productVersion);
            return id.isOracle() || id.isDb2() || id.isPostgres() && version != null && version.major > 8 || id.isMicrosoft() && DataSourceUiUtil.isMsSql2008(productVersion);
        }

        private void appendRowId(@NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dbDialect) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "appendRowId"));
            }
            if (dbDialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbDialect", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "appendRowId"));
            }
            DasTable table = DatabaseGridDataHookUp.this.getDatabaseTable();
            if (table == null || !this.hasRowId(table, dbDialect)) {
                return;
            }
            DbDataSource dataSource = DatabaseGridDataHookUp.this.getDataSource();
            String productVersion = dataSource == null ? "" : StringUtil.notNullize((String)dataSource.getDatabaseProductVersion());
            DbImplUtil.appendRowId(builder, dbDialect, productVersion);
        }

        protected void appendOrderByClause(@NotNull DdlBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "appendOrderByClause"));
            }
        }

        protected void appendWhereClause(@Nullable String alias, @NotNull DdlBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseGridDataHookUp$DatabaseLoader", "appendWhereClause"));
            }
        }
    }
}

