/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridMutator<Row, Column> {
    public void update(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndexSet<Row> var2, @NotNull ModelIndexSet<Column> var3, @Nullable Object var4);

    public boolean isUpdateSafe(@NotNull ModelIndexSet<Row> var1, @NotNull ModelIndexSet<Column> var2, @Nullable Object var3);

    public boolean hasPendingChanges();

    public static interface ColumnsMutator<Row, Column>
    extends GridMutator<Row, Column> {
        public void deleteColumns(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndexSet<Column> var2);

        public void insertColumn(@NotNull GridRequestSource<Row, Column> var1);

        public void cloneColumn(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndex<Column> var2);
    }

    public static interface RowsMutator<Row, Column>
    extends GridMutator<Row, Column> {
        public void deleteRows(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndexSet<Row> var2);

        public void insertRow(@NotNull GridRequestSource<Row, Column> var1);

        public void cloneRow(@NotNull GridRequestSource<Row, Column> var1, @NotNull ModelIndex<Row> var2);

        @NotNull
        public ModelIndex<Row> getInsertedRow();

        public void submitInsertedRow(@NotNull GridRequestSource<Row, Column> var1);
    }
}

