/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatForm;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dbimport.AbstractTableFormatMapper;
import com.intellij.database.dbimport.DeColumnWithState;
import com.intellij.database.dbimport.ImportDatabaseTableEditorWrapper;
import com.intellij.database.dbimport.ImportDeTable;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportTablePreview;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NewTableFormatMapper
extends AbstractTableFormatMapper
implements DataGridListener,
EditorModelBase.Listener,
Disposable {
    @NotNull
    private final Map<CsvFormat, DeTable> myFormatMap;
    @NotNull
    private final ImportManager myManager;
    @NotNull
    private final String myName;
    @Nullable
    private final DeNamespace myNamespace;
    @NotNull
    private Disposable myEditorListenerDisposable;

    NewTableFormatMapper(@NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper editor, @NotNull CsvFormatsSelectionUI formats, @NotNull ImportManager manager, @NotNull DeModel model, @NotNull String name, @Nullable DeNamespace namespace, @NotNull Disposable parent) {
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dbimport/NewTableFormatMapper", "<init>"));
        }
        super(preview, editor, formats, model, parent);
        this.myName = name;
        this.myNamespace = namespace;
        this.myFormatMap = ContainerUtil.newHashMap();
        this.myManager = manager;
        this.myEditorListenerDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myParent, (Disposable)this);
        this.init();
    }

    @Override
    @NotNull
    DeTable createInitialTable() {
        DeTable deTable = this.createTable(this.myName, null);
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/NewTableFormatMapper", "createInitialTable"));
        }
        return deTable;
    }

    @Override
    void onShowNotify() {
        this.getDatabaseEditor().addListener(this, this.myEditorListenerDisposable);
        this.myEditor.addEditorListener(this::onEditorChanged);
        this.myPreview.getGrid().addDataGridListener(this, this.myParent);
        super.onShowNotify();
    }

    private void onEditorChanged(@Nullable DatabaseTableEditor old, @NotNull DatabaseTableEditor newEditor) {
        if (newEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/NewTableFormatMapper", "onEditorChanged"));
        }
        Disposer.dispose((Disposable)this.myEditorListenerDisposable);
        this.myEditorListenerDisposable = Disposer.newDisposable();
        newEditor.addListener(this, this.myEditorListenerDisposable);
    }

    @Override
    int getColumnNumber(@NotNull DeColumn column, int index) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/NewTableFormatMapper", "getColumnNumber"));
        }
        return ((DeColumnWithState)column).getNumber();
    }

    @Override
    public void changed() {
        this.run(() -> this.myPreview.setColumns(this.createColumnsFromEditor(), this.getDatabaseEditor().getTable().columns));
    }

    private void updateColumnsState(@NotNull DeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/NewTableFormatMapper", "updateColumnsState"));
        }
        DataGrid grid = this.myPreview.getGrid();
        for (ModelIndex columnModelIndex : grid.getDataModel().getColumnIndices().asIterable()) {
            NewTableFormatMapper.updateColumn(table.columns, columnModelIndex.asInteger(), grid.isColumnEnabled(columnModelIndex));
        }
    }

    private static void updateColumn(@NotNull List<DeColumn> columns, int index, boolean enabled) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dbimport/NewTableFormatMapper", "updateColumn"));
        }
        for (DeColumn column : columns) {
            DeColumnWithState withState = (DeColumnWithState)column;
            if (withState.getNumber() != index) continue;
            withState.setEnabled(enabled);
        }
    }

    @NotNull
    private List<DeColumn> createDeColumns(@NotNull DeTable table, @NotNull DeModel model) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/NewTableFormatMapper", "createDeColumns"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/NewTableFormatMapper", "createDeColumns"));
        }
        DataGrid grid = this.myPreview.getGrid();
        List columns = grid.getDataModel().getColumns();
        List<DataConsumer.Row> rows = grid.getDataModel().getRows();
        ArrayList result = ContainerUtil.newArrayList();
        for (DataConsumer.Column column : columns) {
            DeColumnWithState deColumn = new DeColumnWithState(column.name, table, model, column.columnNum, true);
            deColumn.dataType = this.getColumnType(column, rows);
            result.add(deColumn);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/NewTableFormatMapper", "createDeColumns"));
        }
        return arrayList;
    }

    private String getColumnType(@NotNull DataConsumer.Column column, @NotNull List<DataConsumer.Row> rows) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/NewTableFormatMapper", "getColumnType"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/dbimport/NewTableFormatMapper", "getColumnType"));
        }
        TypeMerger merger = null;
        for (DataConsumer.Row row : rows) {
            String value = (String)column.getValue(row);
            TypeMerger nextMerger = this.myManager.getType(value);
            merger = merger == null ? nextMerger : merger.merge(nextMerger);
        }
        return merger == null ? this.myManager.getStringMerger().getName() : merger.getName();
    }

    @Override
    public void onSelectionChanged(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/dbimport/NewTableFormatMapper", "onSelectionChanged"));
        }
    }

    @Override
    public void onContentChanged(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/dbimport/NewTableFormatMapper", "onContentChanged"));
        }
        this.run(() -> {
            DatabaseTableEditor editor = this.myEditor.getEditor();
            DeTable table = editor == null ? null : editor.getTable();
            this.myEditor.setTable(this.createTable(table == null ? this.myName : table.name, table == null ? null : table.getComment()));
        });
    }

    @NotNull
    private DeTable createTable(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/NewTableFormatMapper", "createTable"));
        }
        if (this.myFormatMap.containsKey(this.myPreview.getFormat())) {
            DeTable table = this.myFormatMap.get(this.myPreview.getFormat());
            table.name = name;
            table.comment = comment;
            this.updateColumnsState(table);
            DeTable deTable = table;
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/NewTableFormatMapper", "createTable"));
            }
            return deTable;
        }
        DeModel model = new DeModel(this.myModel.getModel(), this.myModel.getExportHelper());
        ImportDeTable table = new ImportDeTable(name, this.myNamespace, model);
        table.name = name;
        table.comment = comment;
        table.columns.addAll(this.createDeColumns(table, model));
        this.myFormatMap.put(this.myPreview.getFormat(), table);
        ImportDeTable importDeTable = table;
        if (importDeTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/NewTableFormatMapper", "createTable"));
        }
        return importDeTable;
    }

    @Override
    protected void onFormatChanged(@NotNull CsvFormatForm source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/NewTableFormatMapper", "onFormatChanged"));
        }
        if (this.myFormatMap.containsKey(source.getFormat())) {
            DeTable table = this.myFormatMap.get(source.getFormat());
            table.name = this.getDatabaseEditor().getTable().name;
            table.comment = this.getDatabaseEditor().getTable().comment;
            this.myPreview.setFormatAndColumns(source.getFormat(), this.createColumns(table), table.columns);
            this.myEditor.setTable(table);
            return;
        }
        this.myPreview.setFormat(source.getFormat());
        DatabaseTableEditor editor = this.myEditor.getEditor();
        DeTable table = editor == null ? null : editor.getTable();
        this.myEditor.setTable(this.createTable(table == null ? this.myName : table.name, table == null ? null : table.comment));
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditorListenerDisposable);
    }
}

