/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeNames {
    private static final Pattern SCALE_OPT = Pattern.compile("\\[([^\\[\\]]*)\\$s([^\\[\\]]*)\\]");
    private final MultiMap<String, Integer> myTypeNames = MultiMap.createSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final TIntObjectHashMap<TreeMap<Integer, String>> myTypeMap = new TIntObjectHashMap();

    protected String get(int jdbcType) {
        return this.getImpl(jdbcType, false).get(Integer.MAX_VALUE);
    }

    private Map<Integer, String> getImpl(int jdbcType, boolean createIfMissing) {
        TreeMap map = (TreeMap)this.myTypeMap.get(jdbcType);
        if (map == null && createIfMissing) {
            map = new TreeMap();
            this.myTypeMap.put(jdbcType, map);
        }
        return map == null ? Collections.emptyMap() : map;
    }

    @Nullable
    public String get(int jdbcType, int size, int precision, int scale) {
        Map map = (Map)this.myTypeMap.get(jdbcType);
        if (map != null && map.size() > 0) {
            for (Map.Entry o : map.entrySet()) {
                if (size > (Integer)o.getKey()) continue;
                return TypeNames.replace((String)o.getValue(), size, precision, scale);
            }
        }
        return TypeNames.replace(this.get(jdbcType), size, precision, scale);
    }

    @Nullable
    private static String replace(String type, int size, int precision, int scale) {
        type = TypeNames.replaceOnceOrOpt(type, "$s", SCALE_OPT, scale);
        type = TypeNames.replaceOnce(type, "$l", size);
        return TypeNames.replaceOnce(type, "$p", precision);
    }

    public void put(int jdbcType, int capacity, String value) {
        this.myTypeNames.putValue((Object)DataTypeFactory.of((String)value).typeName, (Object)jdbcType);
        TreeMap<Integer, String> map = (TreeMap<Integer, String>)this.myTypeMap.get(jdbcType);
        if (map == null) {
            map = new TreeMap<Integer, String>();
            this.myTypeMap.put(jdbcType, map);
        }
        map.put(capacity, value);
    }

    public void put(int jdbcType, String value) {
        this.myTypeNames.putValue((Object)DataTypeFactory.of((String)value).typeName, (Object)jdbcType);
        this.getImpl(jdbcType, true).put(Integer.MAX_VALUE, value);
    }

    @NotNull
    public String getType(@NotNull String name, int length, int precision, int scale) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/TypeNames", "getType"));
        }
        String result = name;
        for (Integer jdbcType : this.myTypeNames.get((Object)name)) {
            TreeMap map = (TreeMap)this.myTypeMap.get(jdbcType.intValue());
            for (Map.Entry e : map.entrySet()) {
                String replace;
                if (length > 0 && length > (Integer)e.getKey() || (replace = TypeNames.replace((String)e.getValue(), length, precision, scale)) == null || replace.length() <= result.length()) continue;
                result = replace;
            }
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/TypeNames", "getType"));
        }
        return string;
    }

    @Nullable
    static String replaceOnce(@Nullable String template, @NotNull String placeholder, int replacement) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/database/dialects/TypeNames", "replaceOnce"));
        }
        if (template == null) {
            return null;
        }
        if (template.contains(placeholder) && replacement < 0) {
            return null;
        }
        return template.replace(placeholder, String.valueOf(replacement));
    }

    @Nullable
    static String replaceOnceOrOpt(@Nullable String template, @NotNull String placeholder, @NotNull Pattern pattern, int replacement) {
        if (placeholder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeholder", "com/intellij/database/dialects/TypeNames", "replaceOnceOrOpt"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/dialects/TypeNames", "replaceOnceOrOpt"));
        }
        if (template == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(template);
        if (!matcher.find()) {
            return TypeNames.replaceOnce(template, placeholder, replacement);
        }
        return matcher.replaceFirst(replacement <= 0 ? "" : "$1" + Matcher.quoteReplacement(String.valueOf(replacement)) + "$2");
    }

    public int findTypeCode(@NotNull String spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/intellij/database/dialects/TypeNames", "findTypeCode"));
        }
        DataType dataType = DataTypeFactory.of(spec);
        int length = dataType.getLength();
        int def = 1111;
        for (Integer jdbcType : this.myTypeNames.get((Object)dataType.typeName)) {
            TreeMap map = (TreeMap)this.myTypeMap.get(jdbcType.intValue());
            for (Map.Entry e : map.entrySet()) {
                if (length > 0 && length > (Integer)e.getKey()) continue;
                if (((String)e.getValue()).equalsIgnoreCase(spec)) {
                    return jdbcType;
                }
                if ((Integer)e.getKey() == Integer.MAX_VALUE) {
                    def = jdbcType;
                    continue;
                }
                return jdbcType;
            }
        }
        return def;
    }
}

