/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.component;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpArgumentGroup;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpComponent;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.argument.DefaultValueDumpArgument;
import com.intellij.database.dump.dbdump.argument.DumpArgument;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpComboBox
extends DumpComponent {
    private final DumpArgumentGroup<DefaultValueDumpArgument> myGroup;
    private final ComboBox<DumpArgument> myCombo;

    public DumpComboBox(@NotNull DumpArgumentGroup<DefaultValueDumpArgument> group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/dump/dbdump/component/DumpComboBox", "<init>"));
        }
        if (((DefaultValueDumpArgument[])group.getArguments()).length == 0) {
            throw new IllegalArgumentException("Empty argument group");
        }
        this.myGroup = group;
        this.myCombo = new ComboBox(new DefaultComboBoxModel<DumpArgument>(group.getArguments()));
        this.myCombo.setRenderer((ListCellRenderer)((Object)new DumpComboRenderer()));
        this.myCombo.addItemListener(e -> this.fireComponentChanged());
        this.myCombo.setSelectedItem((Object)this.getDefault());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ComboBox<DumpArgument> comboBox = this.myCombo;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getComponent"));
        }
        return comboBox;
    }

    @Override
    @Nullable
    public String getLabel() {
        return this.myGroup.getUiName();
    }

    @Override
    @NotNull
    public DefaultValueDumpArgument getArgument() {
        DefaultValueDumpArgument defaultValueDumpArgument = (DefaultValueDumpArgument)this.myCombo.getSelectedItem();
        if (defaultValueDumpArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getArgument"));
        }
        return defaultValueDumpArgument;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getFullArgument"));
        }
        String string = this.getArgument().getCommandLineArgument(cd);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getFullArgument"));
        }
        return string;
    }

    @Override
    public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/component/DumpComboBox", "isMyLexeme"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/component/DumpComboBox", "isMyLexeme"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/component/DumpComboBox", "isMyLexeme"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpComboBox", "isMyLexeme"));
        }
        return !ContainerUtil.filter((Object[])this.myGroup.getArguments(), DbDumpUtil.argumentFinder(text, current, next, cd)).isEmpty();
    }

    @Override
    public void changeState(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/component/DumpComboBox", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/component/DumpComboBox", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/component/DumpComboBox", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpComboBox", "changeState"));
        }
        DumpArgument arg = (DumpArgument)ContainerUtil.find((Object[])this.myGroup.getArguments(), DbDumpUtil.argumentFinder(text, current, next, cd));
        this.myCombo.setSelectedItem((Object)(arg == null ? this.getFirst() : arg));
    }

    @Override
    public void reset(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpComboBox", "reset"));
        }
        this.myCombo.setSelectedItem((Object)this.getDefault());
    }

    @NotNull
    public DumpArgument getDefault() {
        DumpArgument arg = (DumpArgument)ContainerUtil.find((Object[])this.myGroup.getArguments(), DefaultValueDumpArgument::isOnByDefault);
        DumpArgument dumpArgument = arg == null ? this.getFirst() : arg;
        if (dumpArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getDefault"));
        }
        return dumpArgument;
    }

    @NotNull
    private DumpArgument getFirst() {
        DumpArgument dumpArgument = (DumpArgument)ObjectUtils.assertNotNull((Object)ArrayUtil.getFirstElement((Object[])this.myGroup.getArguments()));
        if (dumpArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getFirst"));
        }
        return dumpArgument;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myGroup.getUiName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpComboBox", "getName"));
        }
        return string;
    }

    private static class DumpComboRenderer
    extends ListCellRendererWrapper<DumpArgument> {
        private DumpComboRenderer() {
        }

        public void customize(JList list, DumpArgument value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.setText(value.getUiName());
            }
        }
    }
}

