/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorHelper
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DatabaseEditorHelper.class);
    private static final String DDL_EDITOR_DISPLAY_NAME = "DDL";
    private static final Key<Object> DB_EDITOR_LISTENER_INSTALLED = Key.create((String)"DB_EDITOR_LISTENER_INSTALLED");
    private static final Key<Boolean> FILE_CONTENT_LOADED = Key.create((String)"DBE_CONTENT_LOADED");

    public static void installEditorFactoryListener(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "installEditorFactoryListener"));
        }
        if (project.getUserData(DB_EDITOR_LISTENER_INSTALLED) != null) {
            return;
        }
        project.putUserData(DB_EDITOR_LISTENER_INSTALLED, (Object)Boolean.TRUE);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditorManagerAdapter listener = new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper$1", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper$1", "fileOpened"));
                }
                if (file instanceof DatabaseElementVirtualFileImpl) {
                    DatabaseElementVirtualFileImpl vFile = (DatabaseElementVirtualFileImpl)file;
                    DatabaseEditorHelper.configureToolbar(vFile, source);
                    DatabaseEditorHelper.setDdlEditorsDisplayName(vFile, source);
                } else if (LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) instanceof SqlLanguageDialect) {
                    DatabaseEditorHelper.restoreAttachedConsole(source, file);
                }
            }
        };
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            listener.fileOpened(fileEditorManager, virtualFile);
        }
        DataBus.addRootAuditor(project, new DataAuditor.Adapter(){

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobSubmitted"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobSubmitted"));
                }
                this.updateToolbars(request);
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobFinished"));
                }
                if (producer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/editor/DatabaseEditorHelper$2", "jobFinished"));
                }
                this.updateToolbars(request);
            }

            void updateToolbars(@NotNull DataRequest request) {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/editor/DatabaseEditorHelper$2", "updateToolbars"));
                }
                if (request.owner instanceof DataGrid || request.owner instanceof AbstractQueryLanguageConsole) {
                    UIUtil.invokeLaterIfNeeded(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
                }
            }

            @Override
            public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
                String content;
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/editor/DatabaseEditorHelper$2", "error"));
                }
                String query = context.getQuery();
                if (!StringUtil.isEmptyOrSpaces((String)query)) {
                    DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(query, MessageType.INFO).notify(project);
                }
                if (StringUtil.isEmptyOrSpaces((String)(content = (message == null ? "" : message) + (th == null ? "" : ExceptionUtil.getUserStackTrace((Throwable)th, (Logger)AbstractQueryLanguageConsole.LOG))))) {
                    content = "<missing error message>";
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(content, MessageType.ERROR).notify(project);
            }
        }, (Disposable)project);
    }

    private static void restoreAttachedConsole(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file) {
        DbDataSource dataSource;
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/intellij/database/editor/DatabaseEditorHelper", "restoreAttachedConsole"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "restoreAttachedConsole"));
        }
        Project project = fileEditorManager.getProject();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || JdbcConsoleProvider.getAttachedConsole(psiFile) != null) {
            return;
        }
        String dataSourceId = JdbcConsoleProvider.getAttachedDataSourceId(file);
        DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource == null || !DbImplUtil.canConnectTo((DbElement)dataSource)) {
            return;
        }
        JdbcConsole jdbcConsole = null;
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (console.getDataSource() != dataSource.getDelegate()) continue;
            jdbcConsole = console;
            break;
        }
        if (jdbcConsole == null) {
            jdbcConsole = JdbcConsole.newConsole(project).fromDataSource((DatabaseSystem)dataSource).build();
            jdbcConsole.showConsole(false);
        }
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            JdbcConsoleProvider.attachConsole(jdbcConsole, editor, psiFile, true);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        JdbcConsole console;
        LocalDataSource dataSource;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "configureConsole"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper", "configureConsole"));
        }
        Project project = source.getProject();
        DbDataSource dbDataSource = DbConsoleRootType.getDataSource(project, file);
        DatabaseSystem delegate = dbDataSource == null ? null : dbDataSource.getDelegate();
        LocalDataSource localDataSource = dataSource = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        if (dataSource == null) {
            return;
        }
        if (FileIndexFacade.getInstance((Project)project).isUnderIgnored(file)) {
            LOG.warn(file.getPresentableUrl() + " is under ignored root, console not initialized");
            return;
        }
        JdbcConsole existing = JdbcConsole.getConsole(source.getProject(), file);
        if (existing != null) {
            console = existing;
        } else {
            console = JdbcConsole.newConsole(project).forFile(file).fromDataSource((DatabaseSystem)dataSource).build();
            console.showConsole(false);
            ChooseSchemaAction.scheduleSchemaSwitch(console, null);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            EditorEx editor;
            if (!(fileEditor instanceof TextEditor) || (editor = (EditorEx)((TextEditor)fileEditor).getEditor()).getPermanentHeaderComponent() != null) continue;
            console.buildConsoleHeaderComponent((Editor)editor);
        }
    }

    public static void disposeConsole(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "disposeConsole"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper", "disposeConsole"));
        }
        if (!source.getProject().isOpen()) {
            return;
        }
        if (source.getAllEditors(file).length > 0) {
            return;
        }
        JdbcConsole console = JdbcConsole.getConsole(source.getProject(), file);
        if (console == null) {
            return;
        }
        if (console.isToolWindowContentPresent()) {
            return;
        }
        Disposer.dispose((Disposable)((Disposable)ObjectUtils.notNull((Object)console.getContent().getDisposer(), (Object)console)));
    }

    private static void configureToolbar(final @NotNull DatabaseElementVirtualFileImpl file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        boolean fileContentLoaded = Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)file));
        for (FileEditor fileEditor : source.getAllEditors((VirtualFile)file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            DatabaseEditorHelper.configureToolbar(file, editor);
            JComponent editorComponent = fileEditor.getComponent();
            if (editorComponent instanceof JBLoadingPanel && file.isBusy()) {
                ((JBLoadingPanel)editorComponent).startLoading();
            }
            if (fileContentLoaded || file.isBusy()) continue;
            new UiNotifyConnector.Once((Component)editorComponent, (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    if (!file.isBusy() && !Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)file))) {
                        FILE_CONTENT_LOADED.set((UserDataHolder)file, (Object)Boolean.TRUE);
                        DatabaseEditorHelper.scheduleReload(file);
                    }
                }
            });
        }
    }

    private static void setDdlEditorsDisplayName(@NotNull DatabaseElementVirtualFileImpl file, @NotNull FileEditorManager fem) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "setDdlEditorsDisplayName"));
        }
        if (fem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fem", "com/intellij/database/editor/DatabaseEditorHelper", "setDdlEditorsDisplayName"));
        }
        for (EditorWithProviderComposite composite : ((FileEditorManagerEx)fem).getSplitters().findEditorComposites((VirtualFile)file)) {
            for (FileEditor editor : composite.getEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                composite.setDisplayName(editor, DDL_EDITOR_DISPLAY_NAME);
            }
        }
    }

    public static boolean isTableDataAvailable(@Nullable DbElement element) {
        return element != null && DbImplUtil.isDataTable(element.getKind()) && DbImplUtil.canConnectTo((DbElement)element.getDataSource());
    }

    public static boolean isDefinitionAvailable(@Nullable DbElement element) {
        return element instanceof DbTable && element.getKind() == ObjectKind.TABLE ? DbImplUtil.canConnectTo(element) : DatabaseEditorHelper.isRawDefinitionAvailable(element);
    }

    public static boolean isRawDefinitionAvailable(@Nullable DbElement element) {
        if (element == null || !DbImplUtil.canConnectTo(element)) {
            return false;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        ObjectKind kind = element.getKind();
        if (kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element.getDbParent() instanceof DbPackage) {
            return dialect.supportsPackageDefinition();
        }
        if (kind == ObjectKind.ROUTINE) {
            return dialect.supportsProcedureDefinition();
        }
        if (element instanceof DbTable) {
            boolean system = ((DbTable)element).isSystem();
            if (kind == ObjectKind.VIEW) {
                return system ? dialect.supportsSystemViewDefinition() : dialect.supportsViewDefinition();
            }
            if (kind == ObjectKind.SEQUENCE) {
                return dialect.supportsSequenceDefinition();
            }
            if (kind == ObjectKind.SYNONYM) {
                return dialect.supportsSynonymDefinition();
            }
            if (kind == ObjectKind.TABLE) {
                return dialect.supportsTableDefinition();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<String> loadDatabaseList(@NotNull ConnectionProvider provider, @NotNull DatabaseDialectEx dialect) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/editor/DatabaseEditorHelper", "loadDatabaseList"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/editor/DatabaseEditorHelper", "loadDatabaseList"));
        }
        if (!provider.acquire()) {
            Exception exception = provider.getLastException();
            if (exception != null) {
                throw exception;
            }
            List<String> list = Collections.emptyList();
            List<String> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDatabaseList"));
            }
            return list2;
        }
        List<String> list = dialect.tryToLoadDatabaseList(provider.getConnection());
        List<String> list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDatabaseList"));
        }
        return list3;
        finally {
            provider.release();
        }
    }

    @NotNull
    public static StringBuilder generateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinition"));
        }
        DdlBuilder builder = new DdlBuilder(sb).configureFor(element);
        builder.element((DasObject)element);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "generateDefinition"));
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder loadOrGenerateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        StringBuilder stringBuilder;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
        }
        try {
            stringBuilder = DatabaseEditorHelper.loadDefinition(element, sb);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            new DdlBuilder(sb).configureFor(element).comment("Failed to load definition\n").comment(ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"") + "\n").comment("auto-generated definition\n");
            StringBuilder stringBuilder2 = DatabaseEditorHelper.generateDefinition(element, sb);
            if (stringBuilder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
            }
            return stringBuilder2;
        }
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadOrGenerateDefinition"));
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder loadDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        StringBuilder stringBuilder = DatabaseEditorHelper.loadDefinition(ConnectionProvider.forElement(element), element, sb);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static StringBuilder loadDefinition(@NotNull ConnectionProvider provider, @NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        if (!provider.acquire()) {
            Exception exception = provider.getLastException();
            if (exception != null) {
                throw exception;
            }
            StringBuilder stringBuilder = sb;
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
            }
            return stringBuilder2;
        }
        DatabaseEditorHelper.setCurrentSchemaSafe(element, provider.getConnection());
        StringBuilder stringBuilder = DatabaseEditorHelper.loadDefinitionImpl(provider, element, sb);
        StringBuilder stringBuilder3 = stringBuilder;
        if (stringBuilder3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinition"));
        }
        return stringBuilder3;
        finally {
            provider.release();
        }
    }

    public static void setCurrentSchemaSafe(@NotNull DbElement element, @NotNull Connection connection) {
        String statement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/editor/DatabaseEditorHelper", "setCurrentSchemaSafe"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/editor/DatabaseEditorHelper", "setCurrentSchemaSafe"));
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        SearchPath searchPath = SearchPath.of(ObjectPath.of((DasObject)DasUtil.getNamespace((DasObject)element)));
        String string = statement = searchPath == null ? null : dialect.sqlSetSearchPath(searchPath);
        if (statement == null) {
            return;
        }
        Statement st = null;
        try {
            st = connection.createStatement();
            st.execute(statement);
        }
        catch (Exception e) {
            DataSourceUiUtil.LOG.warn(statement, (Throwable)e);
        }
        JdbcUtil.closeStatementSafe((Statement)st);
    }

    @NotNull
    private static StringBuilder loadDefinitionImpl(@NotNull ConnectionProvider provider, DbElement element, @NotNull StringBuilder sb) throws Exception {
        DbPackage pkg;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinitionImpl"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinitionImpl"));
        }
        ObjectKind kind = element.getKind();
        Object object = pkg = kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element.getDbParent() instanceof DbPackage ? (DbPackage)DasUtil.getParentOfClass((DasObject)element, DbPackage.class, (boolean)false) : null;
        if (pkg != null) {
            DbImplUtil.tryLoadPackageDefinition(provider, pkg, kind == ObjectKind.PACKAGE, sb);
        } else if (element instanceof DbRoutine) {
            DbImplUtil.tryLoadProcedureDefinition(provider, (DbRoutine)element, sb);
        } else if (element instanceof DbTable) {
            if (kind == ObjectKind.TABLE) {
                DbImplUtil.tryLoadTableDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.VIEW) {
                DbImplUtil.tryLoadViewDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.SEQUENCE) {
                DbImplUtil.tryLoadSequenceDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.SYNONYM) {
                DbImplUtil.tryLoadSynonymDefinition(provider, (DbTable)element, sb);
            }
        } else {
            throw new IllegalArgumentException("unknown element: " + element);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper", "loadDefinitionImpl"));
        }
        return stringBuilder;
    }

    public static void scheduleReload(@NotNull DatabaseElementVirtualFileImpl virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "scheduleReload"));
        }
        virtualFile.setBusy(true);
        Project project = virtualFile.getProject();
        Runnable runnable = () -> {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$scheduleReload$3"));
            }
            if (project.isDisposed()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            try {
                DbElement element = virtualFile.findElement();
                if (element == null || !DbImplUtil.canConnectTo(element)) {
                    sb.append("-- invalid target or connection is not properly configured");
                } else {
                    if (DatabaseEditorHelper.isRawDefinitionAvailable(element)) {
                        DatabaseEditorHelper.loadOrGenerateDefinition(element, sb);
                    } else {
                        sb.append("-- auto-generated definition\n");
                        DatabaseEditorHelper.generateDefinition(element, sb);
                    }
                    if (sb.length() == 0) {
                        sb.append("-- definition is not available or empty");
                    }
                }
            }
            catch (Exception e) {
                String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)DataSourceUiUtil.LOG);
                for (String s : trace.split("\n")) {
                    sb.append("-- ").append(s).append("\n");
                }
            }
            finally {
                String content = StringUtil.convertLineSeparators((String)sb.toString());
                virtualFile.setContent(content);
                virtualFile.setBusy(false);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$null$2"));
                }
                if (project.isDisposed()) {
                    return;
                }
                if (!virtualFile.isValid()) {
                    return;
                }
                Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
                if (document == null) {
                    return;
                }
                Runnable docUpdateRunnable = () -> {
                    boolean reformatOnPaste;
                    if (virtualFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$null$0"));
                    }
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                    DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)file, Collections.singletonList(DasUtil.getNamespace((DasObject)virtualFile.findElement())));
                    document.setText((CharSequence)virtualFile.getContent());
                    boolean bl = reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
                    if (file != null && reformatOnPaste) {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                    }
                };
                boolean writable = virtualFile.isWritable();
                try {
                    virtualFile.setWritableInner(true);
                    document.setReadOnly(false);
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        if (document.getTextLength() == 0) {
                            DocumentReference reference = DocumentReferenceManager.getInstance().create(document);
                            UndoManager.getInstance((Project)project).nonundoableActionPerformed(reference, false);
                        }
                        docUpdateRunnable.run();
                    });
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                }
                catch (Throwable throwable) {
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                    throw throwable;
                }
                DatabaseEditorHelper.setVisualProgress(virtualFile.getProject(), virtualFile, false);
            });
        };
        StartupManager.getInstance((Project)virtualFile.getProject()).runWhenProjectIsInitialized(() -> {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$scheduleReload$5"));
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "lambda$null$4"));
                }
                if (project.isDisposed()) {
                    return;
                }
                DatabaseEditorHelper.setVisualProgress(project, virtualFile, true);
            });
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        });
    }

    private static void setVisualProgress(@NotNull Project project, @NotNull VirtualFile file, boolean flag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "setVisualProgress"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseEditorHelper", "setVisualProgress"));
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            JComponent editorComponent;
            if (!(fileEditor instanceof TextEditor) || !((editorComponent = fileEditor.getComponent()) instanceof JBLoadingPanel)) continue;
            JBLoadingPanel component = (JBLoadingPanel)editorComponent;
            if (flag) {
                component.startLoading();
                continue;
            }
            component.stopLoading();
        }
    }

    private static void configureToolbar(final @NotNull DatabaseElementVirtualFileImpl virtualFile, @NotNull Editor editor) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/DatabaseEditorHelper", "configureToolbar"));
        }
        if (((EditorEx)editor).getPermanentHeaderComponent() != null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction runAction = actionManager.getAction("Jdbc.RunSqlScript");
        group.add(runAction);
        group.addSeparator();
        RefreshAction reloadAction = new RefreshAction("Reload", "", PlatformIcons.SYNCHRONIZE_ICON){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$4", "update"));
                }
                e.getPresentation().setEnabled(!virtualFile.isBusy());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/editor/DatabaseEditorHelper$4", "actionPerformed"));
                }
                DatabaseEditorHelper.scheduleReload(virtualFile);
            }
        };
        reloadAction.registerShortcutOn(editor.getComponent());
        group.add((AnAction)reloadAction);
        ActionToolbar actionToolbar = actionManager.createActionToolbar("unknown", (ActionGroup)group, true);
        actionToolbar.setTargetComponent(editor.getContentComponent());
        JComponent component = actionToolbar.getComponent();
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        headerComponent.add((Component)component, "West");
        DatabaseEditorHelper.updateToolbarColor(virtualFile.getProject(), virtualFile, (JComponent)headerComponent);
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
    }

    public static void openConsoleFile(@Nullable DbElement element) {
        DatabaseEditorHelper.openConsoleFile(element, false);
    }

    public static void openConsoleFile(@Nullable DbElement element, boolean newInstance) {
        LocalDataSource dataSource;
        LocalDataSource localDataSource = dataSource = element == null ? null : DbImplUtil.getLocalDataSource((DatabaseSystem)element.getDataSource());
        if (dataSource == null) {
            return;
        }
        DatabaseEditorHelper.openConsoleFile(element.getProject(), (DatabaseSystem)dataSource, (DasNamespace)DasUtil.getParentOfClass((DasObject)element, DasNamespace.class, (boolean)false), newInstance);
    }

    public static void openConsoleFile(@NotNull Project project, @NotNull DatabaseSystem dataSource, @Nullable DasNamespace schema, boolean newInstance) {
        VirtualFile file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "openConsoleFile"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "openConsoleFile"));
        }
        VirtualFile virtualFile = file = newInstance ? DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource) : DatabaseEditorHelper.getConsoleVirtualFile(dataSource);
        if (file == null) {
            return;
        }
        FileEditorManager.getInstance((Project)project).openFile(file, true);
        if (schema == null) {
            return;
        }
        List<DasNamespace> namespaces = Collections.singletonList(schema);
        JdbcConsole console = JdbcConsole.getConsole(project, file);
        SearchPath searchPath = (SearchPath)ObjectUtils.assertNotNull((Object)SearchPath.of(namespaces));
        if (console != null) {
            console.switchSchema(searchPath, false);
        } else {
            ChooseSchemaAction.setSelectedSearchPath(file, searchPath);
        }
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)PsiManager.getInstance((Project)project).findFile(file), namespaces);
    }

    @Nullable
    public static VirtualFile getConsoleVirtualFile(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "getConsoleVirtualFile"));
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_if_missing);
    }

    @Nullable
    public static VirtualFile findExistingConsoleVirtualFile(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "findExistingConsoleVirtualFile"));
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.existing_only);
    }

    @Nullable
    public static VirtualFile createNewConsoleVirtualFile(@NotNull DatabaseSystem dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/editor/DatabaseEditorHelper", "createNewConsoleVirtualFile"));
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
    }

    public static void updateToolbarColor(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable JComponent headerComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "updateToolbarColor"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/editor/DatabaseEditorHelper", "updateToolbarColor"));
        }
        if (headerComponent == null) {
            return;
        }
        Color color = null;
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        if (state.useColors && state.useInToolbars) {
            color = DatabaseColorManager.getColorImpl(project, virtualFile);
        }
        headerComponent.setBackground(color);
    }

    @Nullable
    public static List<DasNamespace> getSearchPath(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/editor/DatabaseEditorHelper", "getSearchPath"));
        }
        List res = (List)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)psiFile);
        if (res != null && res.stream().allMatch(e -> !(e instanceof PsiElement) || ((PsiElement)e).isValid())) {
            return res;
        }
        return DatabaseEditorHelper.initSearchPath(psiFile);
    }

    @Nullable
    public static DasNamespace getForcedContext(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/editor/DatabaseEditorHelper", "getForcedContext"));
        }
        return (DasNamespace)ContainerUtil.getFirstItem(DatabaseEditorHelper.getSearchPath(psiFile));
    }

    @Nullable
    public static List<DasNamespace> initSearchPath(@NotNull PsiFile psiFile) {
        DbDataSource forcedDataSource;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/editor/DatabaseEditorHelper", "initSearchPath"));
        }
        VirtualFile vfile = psiFile.getVirtualFile();
        if (vfile != null && vfile.getFileSystem() instanceof DbSrcFileSystem) {
            DbSrcPath path;
            DbDataSource dataSource;
            String dataSourceId = DbSrcFileSystem.getDataSource(vfile);
            DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)psiFile.getProject()).findDataSource(dataSourceId);
            if (dataSource != null && (path = DbSrcFileSystem.getFullPath(vfile.getPath())) != null) {
                int sz = path.size();
                for (int i = 0; i < sz; ++i) {
                    ObjectKind nsKind;
                    int idx = sz - i - 1;
                    String kind = path.kind(idx);
                    if (ObjectKind.DATABASE.code().equals(kind)) {
                        nsKind = ObjectKind.DATABASE;
                    } else {
                        if (!ObjectKind.SCHEMA.code().equals(kind)) continue;
                        nsKind = ObjectKind.SCHEMA;
                    }
                    List nsPath = JBIterable.from(path.names()).take(idx + 1).toList();
                    List searchPath = ContainerUtil.createMaybeSingletonList((Object)DatabaseEditorHelper.findNamespace(psiFile.getProject(), (DatabaseSystem)dataSource, new ObjectPath(nsKind, nsPath)));
                    DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)searchPath);
                    return searchPath;
                }
            }
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
            return null;
        }
        JdbcConsole console = JdbcConsoleProvider.getSelfOrAttachedConsole(psiFile);
        DbDataSource dbDataSource = forcedDataSource = console != null ? DbImplUtil.getDbDataSource(psiFile.getProject(), (LocalDataSource)((Object)console.getTarget())) : null;
        if (forcedDataSource != null) {
            SearchPath path = console.getSearchPath();
            List<Object> schemaNames = path == null ? Collections.emptyList() : path.elements;
            List forcedNamespaces = JBIterable.from(schemaNames).transform(p -> DatabaseEditorHelper.findNamespace(forcedDataSource.getProject(), (DatabaseSystem)forcedDataSource, p)).toList();
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)forcedNamespaces);
            return forcedNamespaces;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List forcedNamespaces = (List)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)psiFile.getVirtualFile());
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)forcedNamespaces);
            return forcedNamespaces;
        }
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
        return null;
    }

    @Nullable
    public static DasNamespace findNamespace(@NotNull Project project, @NotNull DatabaseSystem databaseSystem, @Nullable ObjectPath objectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseEditorHelper", "findNamespace"));
        }
        if (databaseSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseSystem", "com/intellij/database/editor/DatabaseEditorHelper", "findNamespace"));
        }
        DatabaseElementVirtualFileImpl file = DatabaseElementVirtualFileImpl.findFile(project, databaseSystem, objectPath);
        return file == null ? null : (DasNamespace)ObjectUtils.tryCast((Object)file.findElement(), DasNamespace.class);
    }
}

