/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import org.jetbrains.annotations.NotNull;

class DatabaseTableEditorLocation
implements FileEditorLocation {
    private final FileEditor myEditor;
    public final int myRow;
    public final int myColumn;

    public DatabaseTableEditorLocation(@NotNull FileEditor editor, int row, int column) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/editor/DatabaseTableEditorLocation", "<init>"));
        }
        this.myEditor = editor;
        this.myRow = row;
        this.myColumn = column;
    }

    @NotNull
    public FileEditor getEditor() {
        FileEditor fileEditor = this.myEditor;
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableEditorLocation", "getEditor"));
        }
        return fileEditor;
    }

    public int getRow() {
        return this.myRow;
    }

    public int getColumn() {
        return this.myColumn;
    }

    public int compareTo(FileEditorLocation location) {
        if (!(location instanceof DatabaseTableEditorLocation)) {
            return 0;
        }
        DatabaseTableEditorLocation that = (DatabaseTableEditorLocation)location;
        if (this.myRow != that.myRow) {
            return this.myRow - that.myRow;
        }
        if (this.myColumn != that.myColumn) {
            return this.myColumn - that.myColumn;
        }
        return 0;
    }
}

