/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractorScripts;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ScriptDataExtractor;
import com.intellij.database.extractors.SqlInsertValuesExtractor;
import com.intellij.database.extractors.SqlUpdateValuesExtractor;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataExtractorFactories {
    private DataExtractorFactories() {
    }

    @NotNull
    public static List<DataExtractorFactory> getLegacy() {
        List list = ContainerUtil.list((Object[])new DataExtractorFactory[]{new SqlInserts(), new SqlUpdates(), new Html()});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getLegacy"));
        }
        return list;
    }

    @NotNull
    public static List<DataExtractorFactory> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getSettings().getCsvFormats();
        List list = ContainerUtil.map(formats, format -> new Format((CsvFormat)format));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getCsvFormats"));
        }
        return list;
    }

    @NotNull
    public static List<DataExtractorFactory> getScripts() {
        List<VirtualFile> scriptFiles = ExtractorScripts.getScriptFiles();
        List list = ContainerUtil.map(scriptFiles, virtualFile -> new Script(virtualFile.getName()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getScripts"));
        }
        return list;
    }

    @NotNull
    public static DataExtractorFactory getDefault() {
        Format format = new Format(DatabaseSettings.TSV_FORMAT);
        if (format == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getDefault"));
        }
        return format;
    }

    @Nullable
    public static DataExtractorFactory find(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/extractors/DataExtractorFactories", "find"));
        }
        DataExtractorFactory f = DataExtractorFactories.find(name, DataExtractorFactories.getLegacy());
        f = f != null ? f : DataExtractorFactories.find(name, DataExtractorFactories.getCsvFormats());
        f = f != null ? f : DataExtractorFactories.find(name, DataExtractorFactories.getScripts());
        return f;
    }

    @NotNull
    public static DataExtractorFactory create(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/DataExtractorFactories", "create"));
        }
        Format format2 = new Format(format);
        if (format2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "create"));
        }
        return format2;
    }

    @Nullable
    private static DataExtractorFactory find(final @NotNull String name, @NotNull List<? extends DataExtractorFactory> factories) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/extractors/DataExtractorFactories", "find"));
        }
        if (factories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "com/intellij/database/extractors/DataExtractorFactories", "find"));
        }
        return (DataExtractorFactory)ContainerUtil.find(factories, (Condition)new Condition<DataExtractorFactory>(){

            public boolean value(DataExtractorFactory factory) {
                return name.equals(factory.getName());
            }
        });
    }

    @NotNull
    private static DatabaseDialectEx getDatabaseDialect(@NotNull DataContext dataContext, @Nullable DbTable table) {
        DatabaseDialectEx fromConsole;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/extractors/DataExtractorFactories", "getDatabaseDialect"));
        }
        if (table != null) {
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect((DbElement)table);
            if (databaseDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getDatabaseDialect"));
            }
            return databaseDialectEx;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        JdbcConsole console = project != null ? JdbcConsole.getConsole(project, file) : JdbcConsoleProvider.getAttachedConsole((PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        DatabaseDialectEx databaseDialectEx = fromConsole = console != null ? DbImplUtil.getDatabaseDialect(console) : null;
        if (fromConsole != null) {
            DatabaseDialectEx databaseDialectEx2 = fromConsole;
            if (databaseDialectEx2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getDatabaseDialect"));
            }
            return databaseDialectEx2;
        }
        GenericDialect genericDialect = GenericDialect.INSTANCE;
        if (genericDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories", "getDatabaseDialect"));
        }
        return genericDialect;
    }

    private static abstract class DasAwareFactory
    implements DataExtractorFactory {
        private DasAwareFactory() {
        }

        @Override
        @Nullable
        public final DataExtractor createExtractor(@NotNull DataContext context) {
            DasTable table;
            DatabaseDialectEx dialect;
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$DasAwareFactory", "createExtractor"));
            }
            DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(context);
            if (grid != null) {
                dialect = DataGridUtil.getDatabaseDialect(grid);
                table = DataGridUtil.getDatabaseTable(grid);
            } else {
                PsiElement contextElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
                DbTable dbTable = (DbTable)ObjectUtils.tryCast((Object)contextElement, DbTable.class);
                table = dbTable;
                dialect = DataExtractorFactories.getDatabaseDialect(context, dbTable);
            }
            return this.createExtractor(context, dialect, table);
        }

        @Nullable
        protected abstract DataExtractor createExtractor(@NotNull DataContext var1, @NotNull DatabaseDialectEx var2, @Nullable DasTable var3);
    }

    private static class Script
    extends DasAwareFactory {
        private final String myScriptFileName;

        public Script(@NotNull String scriptFileName) {
            if (scriptFileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFileName", "com/intellij/database/extractors/DataExtractorFactories$Script", "<init>"));
            }
            this.myScriptFileName = scriptFileName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myScriptFileName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories$Script", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        protected DataExtractor createExtractor(@NotNull DataContext context, @NotNull DatabaseDialectEx dialect, @Nullable DasTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$Script", "createExtractor"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DataExtractorFactories$Script", "createExtractor"));
            }
            VirtualFile script = ExtractorScripts.findScript(this.myScriptFileName);
            if (script == null) {
                return null;
            }
            ExtensionScriptsUtil.prepareScript(script);
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            DataGrid grid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(context);
            ObjectFormatter formatter = grid != null ? grid.getObjectFormatter() : new ObjectFormatter();
            boolean transposed = grid != null && grid.isTransposed();
            return new ScriptDataExtractor(project, script, formatter, table, transposed);
        }
    }

    private static class SqlInserts
    extends DasAwareFactory {
        private SqlInserts() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("SQL Inserts" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories$SqlInserts", "getName"));
            }
            return "SQL Inserts";
        }

        @Override
        @Nullable
        protected DataExtractor createExtractor(@NotNull DataContext context, @NotNull DatabaseDialectEx dialect, @Nullable DasTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$SqlInserts", "createExtractor"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DataExtractorFactories$SqlInserts", "createExtractor"));
            }
            return new SqlInsertValuesExtractor(new ObjectFormatter(), table);
        }
    }

    private static class SqlUpdates
    extends DasAwareFactory {
        private SqlUpdates() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("SQL Updates" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates", "getName"));
            }
            return "SQL Updates";
        }

        @Override
        @Nullable
        protected DataExtractor createExtractor(@NotNull DataContext context, @NotNull DatabaseDialectEx dialect, @Nullable DasTable table) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates", "createExtractor"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates", "createExtractor"));
            }
            return new SqlUpdateValuesExtractor(new ObjectFormatter(), table);
        }
    }

    private static class Format
    implements DataExtractorFactory {
        private final CsvFormat myFormat;

        public Format(@NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/DataExtractorFactories$Format", "<init>"));
            }
            this.myFormat = format;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFormat.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories$Format", "getName"));
            }
            return string;
        }

        @Override
        @Nullable
        public DataExtractor createExtractor(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$Format", "createExtractor"));
            }
            return new FormatBasedExtractor(this.myFormat, new ObjectFormatter());
        }
    }

    private static class Html
    implements DataExtractorFactory {
        private Html() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("HTML Table" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/DataExtractorFactories$Html", "getName"));
            }
            return "HTML Table";
        }

        @Override
        @Nullable
        public DataExtractor createExtractor(@NotNull DataContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/extractors/DataExtractorFactories$Html", "createExtractor"));
            }
            DatabaseSettings.StdState state = new DatabaseSettings.StdState();
            state.columnNames = true;
            return new HtmlValuesExtractor(state, new ObjectFormatter());
        }
    }
}

