/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMinorObject;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface BasicColumniation
extends BasicMinorObject,
DasTableChild {
    default public BasicLikeTable getTable() {
        return (BasicLikeTable)((Object)this.getMajorObject());
    }

    default public String getTableName() {
        BasicLikeTable table = this.getTable();
        return table != null ? table.getName() : null;
    }

    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getColNames"));
        }
        return list;
    }

    @NotNull
    default public List<? extends BasicColumn> getCols() {
        List<String> names = this.getColNames();
        if (names.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getCols"));
            }
            return list;
        }
        BasicLikeTable table = this.getTable();
        if (table == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getCols"));
            }
            return list;
        }
        List<? extends BasicColumn> list = table.getColumns().get(names);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "getCols"));
        }
        return list;
    }

    default public boolean dependsOnColumn(@NotNull String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/model/basic/BasicColumniation", "dependsOnColumn"));
        }
        return this.getColNames().contains(columnName);
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        String d;
        List<? extends BasicColumn> cols = this.getCols();
        int n = cols.size();
        switch (n) {
            case 0: {
                d = "\uffff";
                break;
            }
            case 1: {
                d = cols.get(0).getDisplayOrder() + '!' + this.getName();
                break;
            }
            default: {
                String name = this.getName();
                StringBuilder b = new StringBuilder(n * 8 + name.length());
                for (BasicColumn basicColumn : cols) {
                    b.append(basicColumn.getDisplayOrder()).append('!');
                }
                b.append(name);
                d = b.toString();
            }
        }
        String string = d;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicColumniation", "calculateDisplayOrder"));
        }
        return string;
    }
}

