/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.families;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Family<E extends BasicElement>
extends BasicNode,
Iterable<E> {
    @Override
    @Nullable
    public BasicModel getModel();

    @Nullable
    public BasicElement getOwner();

    @NotNull
    public E get(int var1);

    @NotNull
    public E first();

    @NotNull
    public E last();

    public int indexOf(@Nullable BasicElement var1);

    public boolean hasChildren();

    @Nullable
    public E find(@NotNull Predicate<? super E> var1);

    default public boolean has(@NotNull Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/database/model/families/Family", "has"));
        }
        return this.find(predicate) != null;
    }

    @Override
    @Nullable
    default public BasicElement getParentNode() {
        return this.getOwner();
    }

    @NotNull
    default public Iterable<? extends BasicElement> getChildNodes() {
        Family family = this;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/families/Family", "getChildNodes"));
        }
        return family;
    }
}

