/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModel
implements BasicModModel {
    private final THashSet<BaseElement> myLastCreatedElements = new THashSet();
    private final THashSet<BaseElement> myLastModifiedElements = new THashSet();
    private final THashSet<BaseElement> myLastRemovedElements = new THashSet();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private volatile long myModificationThreadId = Long.MIN_VALUE;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners = new CopyOnWriteArrayList();

    @Override
    @NotNull
    public abstract BasicRoot getRoot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/model/impl/BaseModel", "read"));
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            V v = reader.perform(this);
            return v;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public <R extends BasicModRoot> void modify(@NotNull Class<R> rootClass, @NotNull ModelModifier<? super R> modifier) {
        if (rootClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootClass", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        this.modify(this.getRoot(), rootClass, modifier);
    }

    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        if (element.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (element.getModel() != this) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element;
        this.modify(modElement, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BasicElement> void modify(@NotNull E element, @NotNull ModelModifier<? super E> modifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/database/model/impl/BaseModel", "modify"));
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        writeLock.lock();
        try {
            this.clearModifications();
            this.myModificationThreadId = Thread.currentThread().getId();
            modifier.perform(element);
        }
        finally {
            writeLock.unlock();
            this.myModificationThreadId = Integer.MIN_VALUE;
            this.notifyListeners();
        }
    }

    void doingObjectCreate(@NotNull BaseElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/model/impl/BaseModel", "doingObjectCreate"));
        }
        this.doingAnyModification();
        this.myLastCreatedElements.add((Object)element);
    }

    void doingObjectModify(@NotNull BaseElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/model/impl/BaseModel", "doingObjectModify"));
        }
        this.doingAnyModification();
        this.myLastModifiedElements.add((Object)element);
    }

    void doingObjectRemove(@NotNull BaseElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/model/impl/BaseModel", "doingObjectRemove"));
        }
        this.doingAnyModification();
        this.myLastRemovedElements.add((Object)element);
    }

    private void doingAnyModification() {
    }

    @Override
    public void addListener(BasicModelListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(BasicModelListener listener) {
        this.myListeners.remove(listener);
    }

    private void notifyListeners() {
        this.myLastCreatedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastCreatedElements);
        if (this.myLastCreatedElements.isEmpty() && this.myLastModifiedElements.isEmpty() && this.myLastRemovedElements.isEmpty()) {
            return;
        }
        Set<BasicElement> lastCreatedElements = Collections.unmodifiableSet(this.myLastCreatedElements);
        Set<BasicElement> lastModifiedElements = Collections.unmodifiableSet(this.myLastModifiedElements);
        Set<BasicElement> lastRemovedElements = Collections.unmodifiableSet(this.myLastRemovedElements);
        for (BasicModelListener listener : this.myListeners) {
            listener.modified(lastCreatedElements, lastModifiedElements, lastRemovedElements);
        }
    }

    private void clearModifications() {
        this.myLastCreatedElements.clear();
        this.myLastModifiedElements.clear();
        this.myLastRemovedElements.clear();
    }

    @Nullable
    @Contract(value="null,_ -> null", pure=true)
    protected static <X> X findFirst(@Nullable Iterable<X> items, @NotNull Predicate<X> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/database/model/impl/BaseModel", "findFirst"));
        }
        if (items == null) {
            return null;
        }
        for (X item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    protected static boolean eq(@Nullable Object value1, @Nullable Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public static abstract class BaseNamingIdentifyingFamily<E extends BaseElement & BasicModIdentifiedElement>
    extends BaseNamingFamily<E>
    implements ModNamingIdentifyingFamily<E> {
        public BaseNamingIdentifyingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BaseNamingIdentifyingFamily", "<init>"));
            }
            super(owner);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E renew(long objectId, @NotNull String string) {
            void name;
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BaseNamingIdentifyingFamily", "renew"));
            }
            List elements = this.myElements;
            if (elements != null) {
                BaseElement e;
                int i;
                int n = elements.size();
                if (objectId != Long.MIN_VALUE) {
                    for (i = 0; i < n; ++i) {
                        e = (BaseElement)elements.get(i);
                        if (((BasicIdentifiedElement)((Object)e)).getObjectId() != objectId) continue;
                        ((BasicModNamedElement)((Object)e)).setName((String)name);
                        return (E)e;
                    }
                }
                if (name != ModelConsts.NO_NAME) {
                    for (i = 0; i < n; ++i) {
                        e = (BaseElement)elements.get(i);
                        if (((BasicIdentifiedElement)((Object)e)).getObjectId() != Long.MIN_VALUE || !((BasicNamedElement)((Object)e)).getName().equals(name)) continue;
                        ((BasicModIdentifiedElement)((Object)e)).setObjectId(objectId);
                        return (E)e;
                    }
                }
            }
            BasicModElement e = this.createNewOne();
            ((BasicModIdentifiedElement)e).setObjectId(objectId);
            ((BasicModNamedElement)e).setName((String)name);
            return (E)e;
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object element = this.getByObjectId(objectId);
            if (element == null) {
                element = this.createNewOne();
                ((BasicModIdentifiedElement)element).setObjectId(objectId);
            }
            E e = element;
            if (e == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseNamingIdentifyingFamily", "createOrGet"));
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                BaseElement element = (BaseElement)elements.get(i);
                if (((BasicIdentifiedElement)((Object)element)).getObjectId() != objectId) continue;
                return (E)element;
            }
            return null;
        }
    }

    public static abstract class BasePositioningNamingFamily<E extends BaseElement & BasicModNamedElement>
    extends BaseNamingFamily<E>
    implements ModPositioningNamingFamily<E> {
        public BasePositioningNamingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BasePositioningNamingFamily", "<init>"));
            }
            super(owner);
        }

        @Override
        public E renewAt(short position, @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BasePositioningNamingFamily", "renewAt"));
            }
            List elements = this.myElements;
            BasicModElement e = BaseModel.findFirst(elements, x -> {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BasePositioningNamingFamily", "lambda$renewAt$0"));
                }
                return ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName().equals(name);
            });
            if (e != null) {
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName() == ModelConsts.NO_NAME);
            if (e != null) {
                ((BasicModNamedElement)e).setName(name);
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BasePositioningNamingFamily", "lambda$renewAt$2"));
                }
                return ((BasicArrangedElement)((Object)x)).getPosition() == 0 && ((BasicNamedElement)((Object)x)).getName().equals(name);
            });
            if (e != null) {
                ((BasicModArrangedElement)((Object)e)).setPosition(position);
                return (E)e;
            }
            e = this.createNewOne();
            ((BasicModArrangedElement)((Object)e)).setPosition(position);
            ((BasicModNamedElement)e).setName(name);
            return (E)e;
        }

        @Override
        public E createOrGetAt(short position) {
            int n;
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element = this.createNewOne();
                ((BasicModArrangedElement)((Object)element)).setPosition(position);
                this.myElements = new ArrayList();
                this.myElements.add(element);
                return (E)element;
            }
            int index = n = elements.size();
            for (int i = 0; i < n; ++i) {
                BaseElement element = (BaseElement)elements.get(i);
                short p = ((BasicArrangedElement)((Object)element)).getPosition();
                if (p == position) {
                    return (E)element;
                }
                if (p <= position) continue;
                index = i;
                break;
            }
            BasicModElement element = this.createNewOne();
            ((BasicModArrangedElement)((Object)element)).setPosition(position);
            this.myElements.add(index, element);
            return (E)element;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            return (E)BaseModel.findFirst(elements, e -> ((BasicArrangedElement)((Object)e)).getPosition() == position);
        }
    }

    public static abstract class BaseIdentifyingFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModIdentifyingFamily<E> {
        public BaseIdentifyingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BaseIdentifyingFamily", "<init>"));
            }
            super(owner);
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object element = this.getByObjectId(objectId);
            if (element == null) {
                element = this.createNewOne();
                ((BasicModIdentifiedElement)element).setObjectId(objectId);
            }
            E e = element;
            if (e == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseIdentifyingFamily", "createOrGet"));
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                BaseElement element = (BaseElement)elements.get(i);
                if (((BasicIdentifiedElement)((Object)element)).getObjectId() != objectId) continue;
                return (E)element;
            }
            return null;
        }
    }

    public static abstract class BaseNamingFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModNamingFamily<E> {
        public BaseNamingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BaseNamingFamily", "<init>"));
            }
            super(owner);
        }

        @Override
        public E createOrGet(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BaseNamingFamily", "createOrGet"));
            }
            Object element = this.get(name);
            if (element == null) {
                element = this.createNewOne();
                ((BasicModNamedElement)element).setName(name);
            }
            return element;
        }

        @Override
        @Nullable
        public E get(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BaseNamingFamily", "get"));
            }
            return this.get(name, true);
        }

        @Override
        @Nullable
        public E get(@NotNull String name, boolean caseSensitive) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/BaseModel$BaseNamingFamily", "get"));
            }
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                boolean matched;
                BaseElement element = (BaseElement)elements.get(i);
                boolean bl = matched = caseSensitive ? ((BasicNamedElement)((Object)element)).getName().equals(name) : ((BasicNamedElement)((Object)element)).getName().equalsIgnoreCase(name);
                if (!matched) continue;
                return (E)element;
            }
            return null;
        }
    }

    public static abstract class BasePositioningFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModPositioningFamily<E> {
        public BasePositioningFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BasePositioningFamily", "<init>"));
            }
            super(owner);
        }

        @Override
        public E createOrGetAt(short position) {
            int n;
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element = this.createNewOne();
                ((BasicModArrangedElement)((Object)element)).setPosition(position);
                this.myElements = new ArrayList();
                this.myElements.add(element);
                return (E)element;
            }
            int index = n = elements.size();
            for (int i = 0; i < n; ++i) {
                BaseElement element = (BaseElement)elements.get(i);
                short p = ((BasicArrangedElement)((Object)element)).getPosition();
                if (p == position) {
                    return (E)element;
                }
                if (p <= position) continue;
                index = i;
                break;
            }
            BasicModElement element = this.createNewOne();
            ((BasicModArrangedElement)((Object)element)).setPosition(position);
            this.myElements.add(index, element);
            return (E)element;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                BaseElement element = (BaseElement)elements.get(i);
                if (((BasicArrangedElement)((Object)element)).getPosition() != position) continue;
                return (E)element;
            }
            return null;
        }
    }

    public static abstract class BaseSingletonFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModSingletonFamily<E> {
        public BaseSingletonFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BaseSingletonFamily", "<init>"));
            }
            super(owner);
        }

        @Override
        @Nullable
        public E get() {
            return (E)this.first();
        }

        @Override
        @NotNull
        public E createNewOne() {
            this.owner.modifying();
            assert (this.myElements == null);
            Object newOne = this.instantiate();
            this.myElements = Collections.singletonList(newOne);
            Object e = newOne;
            if (e == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseSingletonFamily", "createNewOne"));
            }
            return e;
        }

        @Override
        @NotNull
        public E createOrGet() {
            BasicElement element = this.first();
            if (element == null) {
                element = this.createNewOne();
            }
            BasicElement basicElement = element;
            if (basicElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseSingletonFamily", "createOrGet"));
            }
            return (E)basicElement;
        }
    }

    public static abstract class BaseFamily<E extends BaseElement>
    implements ModFamily<E> {
        @NotNull
        protected final BaseElement owner;
        @Nullable
        protected volatile List<E> myElements;

        public BaseFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BaseFamily", "<init>"));
            }
            this.myElements = null;
            this.owner = owner;
        }

        @NotNull
        protected abstract E instantiate();

        @Override
        @NotNull
        public E createNewOne() {
            BaseModel model = (BaseModel)this.owner.getModel();
            this.owner.modifying();
            E newOne = this.instantiate();
            if (this.myElements == null) {
                this.myElements = new ArrayList();
            }
            this.myElements.add(newOne);
            model.doingObjectCreate((BaseElement)newOne);
            E e = newOne;
            if (e == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseFamily", "createNewOne"));
            }
            return e;
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            BasicModModel basicModModel = this.owner.getModel();
            if (basicModModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseFamily", "getModel"));
            }
            return basicModModel;
        }

        @Override
        @NotNull
        public BaseElement getOwner() {
            BaseElement baseElement = this.owner;
            if (baseElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseFamily", "getOwner"));
            }
            return baseElement;
        }

        @Override
        @NotNull
        public E get(int index) {
            List<E> elements = this.myElements;
            if (elements == null) {
                throw new IllegalStateException("The family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(index);
            if (baseElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseFamily", "get"));
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E first() {
            List<E> elements = this.myElements;
            if (elements == null) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(0);
            if (baseElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseFamily", "first"));
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E last() {
            List<E> elements = this.myElements;
            if (elements == null) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(elements.size() - 1);
            if (baseElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseFamily", "last"));
            }
            return (E)baseElement;
        }

        @Override
        public int indexOf(@Nullable BasicElement element) {
            if (element == null) {
                return -1;
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return -1;
            }
            return elements.indexOf(element);
        }

        @Override
        public boolean hasChildren() {
            List<E> elements = this.myElements;
            return elements != null;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/database/model/impl/BaseModel$BaseFamily", "find"));
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return null;
            }
            for (BaseElement element : elements) {
                if (!predicate.test(element)) continue;
                return (E)element;
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            List<E> elements = this.myElements;
            if (elements != null) {
                return elements.iterator();
            }
            return Collections.emptyListIterator();
        }

        @Override
        public void remove(@NotNull Predicate<? super E> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/model/impl/BaseModel$BaseFamily", "remove"));
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            int n = elements.size();
            boolean modificationSent = false;
            for (int i = n - 1; i >= 0; --i) {
                BaseElement e = (BaseElement)elements.get(i);
                if (!condition.test(e)) continue;
                if (!modificationSent) {
                    modificationSent = true;
                    this.owner.modifying();
                }
                e.internalDrop(false);
                elements.remove(i);
            }
            if (elements.isEmpty()) {
                this.myElements = null;
            }
        }

        @Override
        public void clear() {
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            this.owner.modifying();
            this.myElements = null;
            for (int i = elements.size() - 1; i >= 0; --i) {
                BaseElement e = (BaseElement)elements.get(i);
                e.internalDrop(false);
            }
        }
    }

    public abstract class BaseRegularElement
    extends BaseElement {
        @NotNull
        protected final BaseFamily<?> myParentFamily;
        @Nullable
        private transient String myDisplayOrder;
        private transient boolean myDropped;
        private transient boolean mySyncPending;

        public BaseRegularElement(BaseFamily<?> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/BaseModel$BaseRegularElement", "<init>"));
            }
            this.myDisplayOrder = null;
            this.myDropped = false;
            this.mySyncPending = false;
            this.myParentFamily = parentFamily;
        }

        @Override
        protected void modifying() {
            super.modifying();
            this.myDisplayOrder = null;
        }

        @Override
        @NotNull
        public final String getDisplayOrder() {
            String o = this.myDisplayOrder;
            if (o == null) {
                this.myDisplayOrder = o = this.calculateDisplayOrder();
            }
            String string = o;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseRegularElement", "getDisplayOrder"));
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            this.mySyncPending = true;
        }

        @Override
        public boolean isSyncPending() {
            return this.mySyncPending;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            BaseModel.this.doingObjectRemove(this);
            this.dropChildren();
            if (removeFromParent) {
                this.myParentFamily.remove(e -> e == this);
            }
            this.myDropped = true;
        }

        @Override
        public boolean isDropped() {
            return this.myDropped;
        }
    }

    public abstract class BaseRoot
    extends BaseElement
    implements BasicModRoot {
        @Override
        public void setSyncPending(boolean syncPending) {
            if (syncPending) {
                throw new IllegalStateException("Cannot set the root element as sync pending");
            }
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            throw new IllegalStateException("Cannot drop a root element");
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        @Override
        @NotNull
        public String calculateDisplayOrder() {
            if ("ROOT" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseRoot", "calculateDisplayOrder"));
            }
            return "ROOT";
        }
    }

    public abstract class BaseElement
    implements BasicModElement {
        @Override
        @NotNull
        public BasicModModel getModel() {
            BaseModel baseModel = BaseModel.this;
            if (baseModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseElement", "getModel"));
            }
            return baseModel;
        }

        protected void modifying() {
            BaseModel.this.doingObjectModify(this);
        }

        @Override
        public void drop() {
            this.internalDrop(true);
        }

        abstract void internalDrop(boolean var1);
    }
}

