/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.db2.DB2;
import com.intellij.database.model.derby.Derby;
import com.intellij.database.model.hsql.HsqlDB;
import com.intellij.database.model.impl.DB2ImplModel;
import com.intellij.database.model.impl.DerbyImplModel;
import com.intellij.database.model.impl.GenericImplModel;
import com.intellij.database.model.impl.H2ImplModel;
import com.intellij.database.model.impl.HsqlImplModel;
import com.intellij.database.model.impl.MssqlImplModel;
import com.intellij.database.model.impl.MysqlImplModel;
import com.intellij.database.model.impl.OracleImplModel;
import com.intellij.database.model.impl.PostgresImplModel;
import com.intellij.database.model.impl.SQLiteImplModel;
import com.intellij.database.model.impl.SybaseImplModel;
import com.intellij.database.model.sqlite.SQLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public final class ModelFactoryService
implements ModelFactory {
    @Override
    @NotNull
    public BasicModModel createModel(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
        }
        if (rdbms == Oracle.RDBMS) {
            OracleImplModel oracleImplModel = new OracleImplModel();
            if (oracleImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return oracleImplModel;
        }
        if (rdbms == Mssql.RDBMS) {
            MssqlImplModel mssqlImplModel = new MssqlImplModel();
            if (mssqlImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return mssqlImplModel;
        }
        if (rdbms == Sybase.RDBMS) {
            SybaseImplModel sybaseImplModel = new SybaseImplModel();
            if (sybaseImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return sybaseImplModel;
        }
        if (rdbms == Postgres.RDBMS) {
            PostgresImplModel postgresImplModel = new PostgresImplModel();
            if (postgresImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return postgresImplModel;
        }
        if (rdbms == Mysql.RDBMS) {
            MysqlImplModel mysqlImplModel = new MysqlImplModel();
            if (mysqlImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return mysqlImplModel;
        }
        if (rdbms == H2db.RDBMS) {
            H2ImplModel h2ImplModel = new H2ImplModel();
            if (h2ImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return h2ImplModel;
        }
        if (rdbms == HsqlDB.RDBMS) {
            HsqlImplModel hsqlImplModel = new HsqlImplModel();
            if (hsqlImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return hsqlImplModel;
        }
        if (rdbms == DB2.RDBMS) {
            DB2ImplModel dB2ImplModel = new DB2ImplModel();
            if (dB2ImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return dB2ImplModel;
        }
        if (rdbms == Derby.RDBMS) {
            DerbyImplModel derbyImplModel = new DerbyImplModel();
            if (derbyImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return derbyImplModel;
        }
        if (rdbms == SQLite.RDBMS) {
            SQLiteImplModel sQLiteImplModel = new SQLiteImplModel();
            if (sQLiteImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return sQLiteImplModel;
        }
        if (rdbms == UnknownDatabase.RDBMS) {
            GenericImplModel genericImplModel = new GenericImplModel();
            if (genericImplModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/ModelFactoryService", "createModel"));
            }
            return genericImplModel;
        }
        throw new IllegalArgumentException("Unknown how to create a model for " + rdbms);
    }
}

