/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.mssql.MsModAliasType;
import com.intellij.database.model.mssql.MsModArgument;
import com.intellij.database.model.mssql.MsModCheck;
import com.intellij.database.model.mssql.MsModDatabase;
import com.intellij.database.model.mssql.MsModForeignKey;
import com.intellij.database.model.mssql.MsModIndex;
import com.intellij.database.model.mssql.MsModKey;
import com.intellij.database.model.mssql.MsModModel;
import com.intellij.database.model.mssql.MsModRoot;
import com.intellij.database.model.mssql.MsModRoutine;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.mssql.MsModSequence;
import com.intellij.database.model.mssql.MsModTable;
import com.intellij.database.model.mssql.MsModTableColumn;
import com.intellij.database.model.mssql.MsModTableType;
import com.intellij.database.model.mssql.MsModTableTypeColumn;
import com.intellij.database.model.mssql.MsModView;
import com.intellij.database.model.mssql.MsModViewColumn;
import com.intellij.database.model.mssql.MsRoot;
import com.intellij.database.model.properties.CascadeRule;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MssqlImplModel
extends BaseModel
implements MsModModel {
    private final Root myRoot = new Root();

    MssqlImplModel() {
    }

    @Override
    @NotNull
    public MsRoot getRoot() {
        Root root = this.myRoot;
        if (root == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel", "getRoot"));
        }
        return root;
    }

    final class Argument
    extends BaseModel.BaseRegularElement
    implements MsModArgument {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private DasArgument.Direction myDirection;
        @NotNull
        private DataType myDataType;
        @Nullable
        private String myDefaultExpression;

        private Argument(BaseModel.BaseFamily<? extends Argument> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Argument", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDirection = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Routine getRoutine() {
            Routine routine = (Routine)this.myParentFamily.owner;
            if (routine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Argument", "getRoutine"));
            }
            return routine;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Argument> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Argument", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Argument", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Argument", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Argument", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public DasArgument.Direction getDirection() {
            return this.myDirection;
        }

        @Override
        public void setDirection(@Nullable DasArgument.Direction direction) {
            if (BaseModel.eq(this.myDirection, direction)) {
                return;
            }
            this.modifying();
            this.myDirection = direction;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Argument", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/MssqlImplModel$Argument", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Routine
    extends BaseModel.BaseRegularElement
    implements MsModRoutine {
        private final Arguments myArguments;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String mySourceText;

        private Routine(BaseModel.BaseFamily<? extends Routine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Routine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySourceText = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Routine", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<Routine> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Routine", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Routine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Routine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Routine", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Routine", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getSourceText() {
            return this.mySourceText;
        }

        @Override
        public void setSourceText(@Nullable String sourceText) {
            if (BaseModel.eq(this.mySourceText, sourceText)) {
                return;
            }
            this.modifying();
            this.mySourceText = sourceText;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(Routine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Routine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class Check
    extends BaseModel.BaseRegularElement
    implements MsModCheck {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myPredicate;

        private Check(BaseModel.BaseFamily<? extends Check> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Check", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPredicate = null;
        }

        @Override
        @NotNull
        public TableType getTableType() {
            TableType tableType = (TableType)this.myParentFamily.owner;
            if (tableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Check", "getTableType"));
            }
            return tableType;
        }

        @Override
        @NotNull
        public ModNamingFamily<Check> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Check", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Check", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Check", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Check", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Check", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getPredicate() {
            return this.myPredicate;
        }

        @Override
        public void setPredicate(@Nullable String predicate) {
            if (BaseModel.eq(this.myPredicate, predicate)) {
                return;
            }
            this.modifying();
            this.myPredicate = predicate;
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularElement
    implements MsModForeignKey {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private List<String> myRefColNames;
        @NotNull
        private CascadeRule myOnDelete;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myRefColNames = Collections.emptyList();
            this.myOnDelete = CascadeRule.restrict;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<ForeignKey> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public List<String> getRefColNames() {
            List<String> list = this.myRefColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "getRefColNames"));
            }
            return list;
        }

        @Override
        public void setRefColNames(@Nullable List<String> refColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = refColNames != null ? ImmutableList.copyOf(refColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColNames = x;
        }

        @Override
        @NotNull
        public CascadeRule getOnDelete() {
            CascadeRule cascadeRule = this.myOnDelete;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "getOnDelete"));
            }
            return cascadeRule;
        }

        @Override
        public void setOnDelete(@NotNull CascadeRule onDelete) {
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/model/impl/MssqlImplModel$ForeignKey", "setOnDelete"));
            }
            if (this.myOnDelete.equals((Object)onDelete)) {
                return;
            }
            this.modifying();
            this.myOnDelete = onDelete;
        }
    }

    final class Key
    extends BaseModel.BaseRegularElement
    implements MsModKey {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myUnderlyingIndexName;
        private boolean myPrimary;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myUnderlyingIndexName = null;
            this.myPrimary = false;
        }

        @Override
        @NotNull
        public TableType getTableType() {
            TableType tableType = (TableType)this.myParentFamily.owner;
            if (tableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Key", "getTableType"));
            }
            return tableType;
        }

        @Override
        @NotNull
        public ModNamingFamily<Key> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Key", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Key", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Key", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getUnderlyingIndexName() {
            return this.myUnderlyingIndexName;
        }

        @Override
        public void setUnderlyingIndexName(@Nullable String underlyingIndexName) {
            if (BaseModel.eq(this.myUnderlyingIndexName, underlyingIndexName)) {
                return;
            }
            this.modifying();
            this.myUnderlyingIndexName = underlyingIndexName;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }
    }

    final class Index
    extends BaseModel.BaseRegularElement
    implements MsModIndex {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @NotNull
        private Set<String> myReverseColNames;
        private boolean myUnique;

        private Index(BaseModel.BaseFamily<? extends Index> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Index", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myReverseColNames = Collections.emptySet();
            this.myUnique = false;
        }

        @Override
        @NotNull
        public TableType getTableType() {
            TableType tableType = (TableType)this.myParentFamily.owner;
            if (tableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Index", "getTableType"));
            }
            return tableType;
        }

        @Override
        @NotNull
        public ModNamingFamily<Index> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Index", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Index", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Index", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Index", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Index", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @NotNull
        public Set<String> getReverseColNames() {
            Set<String> set = this.myReverseColNames;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Index", "getReverseColNames"));
            }
            return set;
        }

        @Override
        public void setReverseColNames(@Nullable Set<String> reverseColNames) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = reverseColNames != null ? ImmutableSet.copyOf(reverseColNames) : Collections.emptySet();
            if (x.isEmpty() && this.myReverseColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myReverseColNames = x;
        }

        @Override
        public boolean isUnique() {
            return this.myUnique;
        }

        @Override
        public void setUnique(boolean unique) {
            if (this.myUnique == unique) {
                return;
            }
            this.modifying();
            this.myUnique = unique;
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularElement
    implements MsModViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public View getView() {
            View view = (View)this.myParentFamily.owner;
            if (view == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "getView"));
            }
            return view;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/MssqlImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class View
    extends BaseModel.BaseRegularElement
    implements MsModView {
        private final Columns myColumns;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String mySourceText;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySourceText = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<View> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$View", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$View", "getColumns"));
            }
            return columns;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$View", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$View", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getSourceText() {
            return this.mySourceText;
        }

        @Override
        public void setSourceText(@Nullable String sourceText) {
            if (BaseModel.eq(this.mySourceText, sourceText)) {
                return;
            }
            this.modifying();
            this.mySourceText = sourceText;
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularElement
    implements MsModTableColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        @Nullable
        private String myDefaultExpression;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/MssqlImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Table
    extends BaseModel.BaseRegularElement
    implements MsModTable {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private final Checks myChecks;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myChecks = new Checks(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<Table> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getChecks"));
            }
            return checks;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Table", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Table", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        private final class Checks
        extends BaseModel.BaseNamingFamily<Check> {
            private Checks(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Table$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BaseNamingFamily<Index> {
            private Indices(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Table$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class TableTypeColumn
    extends BaseModel.BaseRegularElement
    implements MsModTableTypeColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private TableTypeColumn(BaseModel.BaseFamily<? extends TableTypeColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public TableType getTableType() {
            TableType tableType = (TableType)this.myParentFamily.owner;
            if (tableType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "getTableType"));
            }
            return tableType;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableTypeColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/MssqlImplModel$TableTypeColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class TableType
    extends BaseModel.BaseRegularElement
    implements MsModTableType {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final Checks myChecks;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private int myTypeId;

        private TableType(BaseModel.BaseFamily<? extends TableType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$TableType", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myChecks = new Checks(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTypeId = 0;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<TableType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getChecks"));
            }
            return checks;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$TableType", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$TableType", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$TableType", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public int getTypeId() {
            return this.myTypeId;
        }

        @Override
        public void setTypeId(int typeId) {
            if (this.myTypeId == typeId) {
                return;
            }
            this.modifying();
            this.myTypeId = typeId;
        }

        private final class Checks
        extends BaseModel.BaseNamingFamily<Check> {
            private Checks(TableType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$TableType$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingFamily<Key> {
            private Keys(TableType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$TableType$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BaseNamingFamily<Index> {
            private Indices(TableType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$TableType$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableTypeColumn> {
            private Columns(TableType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$TableType$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableTypeColumn instantiate() {
                return new TableTypeColumn(this);
            }
        }
    }

    final class AliasType
    extends BaseModel.BaseRegularElement
    implements MsModAliasType {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private int myTypeId;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private AliasType(BaseModel.BaseFamily<? extends AliasType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTypeId = 0;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<AliasType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public int getTypeId() {
            return this.myTypeId;
        }

        @Override
        public void setTypeId(int typeId) {
            if (this.myTypeId == typeId) {
                return;
            }
            this.modifying();
            this.myTypeId = typeId;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/MssqlImplModel$AliasType", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class Sequence
    extends BaseModel.BaseRegularElement
    implements MsModSequence {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        @Nullable
        private SequenceIdentity myIdentity;

        private Sequence(BaseModel.BaseFamily<? extends Sequence> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myIdentity = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Sequence> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/MssqlImplModel$Sequence", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        @Nullable
        public SequenceIdentity getIdentity() {
            return this.myIdentity;
        }

        @Override
        public void setIdentity(@Nullable SequenceIdentity identity) {
            if (BaseModel.eq(this.myIdentity, identity)) {
                return;
            }
            this.modifying();
            this.myIdentity = identity;
        }
    }

    final class Schema
    extends BaseModel.BaseRegularElement
    implements MsModSchema {
        private final Sequences mySequences;
        private final AliasTypes myAliasTypes;
        private final TableTypes myTableTypes;
        private final Tables myTables;
        private final Views myViews;
        private final Routines myRoutines;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.mySequences = new Sequences(this);
            this.myAliasTypes = new AliasTypes(this);
            this.myTableTypes = new TableTypes(this);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myRoutines = new Routines(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Database getDatabase() {
            Database database = (Database)this.myParentFamily.owner;
            if (database == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getDatabase"));
            }
            return database;
        }

        @Override
        @NotNull
        public ModNamingFamily<Schema> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Sequences getSequences() {
            Sequences sequences = this.mySequences;
            if (sequences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getSequences"));
            }
            return sequences;
        }

        @Override
        @NotNull
        public AliasTypes getAliasTypes() {
            AliasTypes aliasTypes = this.myAliasTypes;
            if (aliasTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getAliasTypes"));
            }
            return aliasTypes;
        }

        @Override
        @NotNull
        public TableTypes getTableTypes() {
            TableTypes tableTypes = this.myTableTypes;
            if (tableTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getTableTypes"));
            }
            return tableTypes;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getRoutines"));
            }
            return routines;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.SEQUENCE) {
                return this.mySequences;
            }
            if (kind == ObjectKind.ALIAS_TYPE) {
                return this.myAliasTypes;
            }
            if (kind == ObjectKind.ALIAS_TYPE) {
                return this.myTableTypes;
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Schema", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Schema", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Routines
        extends BaseModel.BaseNamingFamily<Routine> {
            private Routines(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Schema$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Routine instantiate() {
                return new Routine(this);
            }
        }

        private final class Views
        extends BaseModel.BaseNamingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }

        private final class TableTypes
        extends BaseModel.BaseNamingIdentifyingFamily<TableType> {
            private TableTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Schema$TableTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableType instantiate() {
                return new TableType(this);
            }
        }

        private final class AliasTypes
        extends BaseModel.BaseNamingIdentifyingFamily<AliasType> {
            private AliasTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Schema$AliasTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected AliasType instantiate() {
                return new AliasType(this);
            }
        }

        private final class Sequences
        extends BaseModel.BaseNamingIdentifyingFamily<Sequence> {
            private Sequences(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Schema$Sequences", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Sequence instantiate() {
                return new Sequence(this);
            }
        }
    }

    final class Database
    extends BaseModel.BaseRegularElement
    implements MsModDatabase {
        private final Schemas mySchemas;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean myCurrent;
        private boolean myVisible;

        private Database(BaseModel.BaseFamily<? extends Database> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/MssqlImplModel$Database", "<init>"));
            }
            super(parentFamily);
            this.mySchemas = new Schemas(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root = (Root)this.myParentFamily.owner;
            if (root == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Database", "getRoot"));
            }
            return root;
        }

        @Override
        @NotNull
        public ModNamingFamily<Database> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Database", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas = this.mySchemas;
            if (schemas == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Database", "getSchemas"));
            }
            return schemas;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Database", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Database", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/MssqlImplModel$Database", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Schemas
        extends BaseModel.BaseNamingFamily<Schema> {
            private Schemas(Database owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Database$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements MsModRoot {
        private final Databases myDatabases = new Databases(this);

        private Root() {
        }

        @Override
        @NotNull
        public Databases getDatabases() {
            Databases databases = this.myDatabases;
            if (databases == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/MssqlImplModel$Root", "getDatabases"));
            }
            return databases;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/MssqlImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.DATABASE) {
                return this.myDatabases;
            }
            return null;
        }

        private final class Databases
        extends BaseModel.BaseNamingFamily<Database> {
            private Databases(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/MssqlImplModel$Root$Databases", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Database instantiate() {
                return new Database(this);
            }
        }
    }
}

