/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsModRoot;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsModDatabase
extends MsDatabase,
BasicModDatabase,
BasicModNamedElement {
    @Override
    @NotNull
    public MsModRoot getRoot();

    @Override
    @NotNull
    default public MsModRoot getDbParent() {
        MsModRoot msModRoot = this.getRoot();
        if (msModRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModDatabase", "getDbParent"));
        }
        return msModRoot;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends MsModDatabase> getParentFamily();

    @Override
    @NotNull
    public ModNamingFamily<? extends MsModSchema> getSchemas();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<NamingFamily> list = Collections.singletonList(this.getSchemas());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModDatabase", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getSchemas());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModDatabase", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mssql/MsModDatabase", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

