/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mysql;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.mysql.MysqlForeignKey;
import com.intellij.database.model.mysql.MysqlModConstraint;
import com.intellij.database.model.mysql.MysqlModSchema;
import com.intellij.database.model.mysql.MysqlModTable;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MysqlModForeignKey
extends MysqlForeignKey,
MysqlModConstraint {
    @Override
    @NotNull
    public MysqlModTable getTable();

    @Override
    @NotNull
    default public MysqlModTable getDbParent() {
        MysqlModTable mysqlModTable = this.getTable();
        if (mysqlModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModForeignKey", "getDbParent"));
        }
        return mysqlModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModForeignKey> getParentFamily();

    @Override
    @NotNull
    default public MysqlModSchema getSchema() {
        MysqlModSchema mysqlModSchema = this.getTable().getSchema();
        if (mysqlModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModForeignKey", "getSchema"));
        }
        return mysqlModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setDeferrable(boolean var1);

    @Override
    public void setInitiallyDeferred(boolean var1);

    public void setRefSchemaName(@Nullable String var1);

    public void setRefTableName(@Nullable String var1);

    public void setRefKeyName(@Nullable String var1);

    public void setRefColNames(@NotNull List<String> var1);

    default public void setRefColNames(String ... refColNames) {
        this.setRefColNames(Arrays.asList(refColNames));
    }

    public void setOnDelete(@NotNull CascadeRule var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mysql/MysqlModForeignKey", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String deferrable = properties.get("Deferrable");
        String initiallyDeferred = properties.get("InitiallyDeferred");
        String refSchemaName = properties.get("RefSchemaName");
        String refTableName = properties.get("RefTableName");
        String refKeyName = properties.get("RefKeyName");
        String refColNames = properties.get("RefColNames");
        String onDelete = properties.get("OnDelete");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (deferrable != null) {
            this.setDeferrable(PropertyConverter.importBoolean(deferrable));
        }
        if (initiallyDeferred != null) {
            this.setInitiallyDeferred(PropertyConverter.importBoolean(initiallyDeferred));
        }
        if (refSchemaName != null) {
            this.setRefSchemaName(PropertyConverter.importString(refSchemaName));
        }
        if (refTableName != null) {
            this.setRefTableName(PropertyConverter.importString(refTableName));
        }
        if (refKeyName != null) {
            this.setRefKeyName(PropertyConverter.importString(refKeyName));
        }
        if (refColNames != null) {
            this.setRefColNames(PropertyConverter.importListOfString(refColNames));
        }
        if (onDelete != null) {
            this.setOnDelete(PropertyConverter.importCascadeRule(onDelete));
        }
    }
}

