/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraConstraint;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraKey
extends OraConstraint,
BasicKey,
BasicIdentifiedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraTable getTable();

    @Override
    @Nullable
    default public OraTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public OraTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraKey> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public OraSchema getSchema() {
        OraTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraKey", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Nullable
    default public String getUnderlyingIndexName() {
        return null;
    }

    @Override
    default public boolean isPrimary() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean primary;
        String underlyingIndexName;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraKey", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((underlyingIndexName = this.getUnderlyingIndexName()) != null) {
            consumer.accept("UnderlyingIndexName", PropertyConverter.export(underlyingIndexName));
        }
        if (primary = this.isPrimary()) {
            consumer.accept("Primary", PropertyConverter.export(primary));
        }
    }
}

