/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresDefTypeAttribute
extends BasicMinorObject,
BasicTypedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefTypeAttribute", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public PostgresDefType getDefType();

    @Override
    @Nullable
    default public PostgresDefType getDbParent() {
        return this.getDefType();
    }

    @Override
    @Nullable
    default public PostgresDefType getMajorObject() {
        return this.getDefType();
    }

    default public @Nullable NamingFamily<@NotNull ? extends PostgresDefTypeAttribute> getParentFamily() {
        return null;
    }

    @Nullable
    default public PostgresSchema getSchema() {
        PostgresDefType defType = this.getDefType();
        return defType != null ? defType.getSchema() : null;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefTypeAttribute", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefTypeAttribute", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefTypeAttribute", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DataType getDataType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefTypeAttribute", "getDataType"));
        }
        return dataType;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        DataType dataType;
        String comment;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresDefTypeAttribute", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((dataType = this.getDataType()) != null && dataType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("DataType", PropertyConverter.export(dataType));
        }
    }
}

