/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresOperator
extends BasicMajorObject,
BasicOverloadable,
BasicIdentifiedElement,
BasicNamedElement,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OPERATOR;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresSchema getSchema();

    @Override
    @Nullable
    default public PostgresSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresOperator> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @NotNull
    default public PostgresOperatorKind getOperatorKind() {
        PostgresOperatorKind postgresOperatorKind = PostgresOperatorKind.UNKNOWN;
        if (postgresOperatorKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getOperatorKind"));
        }
        return postgresOperatorKind;
    }

    @Nullable
    default public String getCallRoutineName() {
        return null;
    }

    @NotNull
    default public DataType getLeftType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getLeftType"));
        }
        return dataType;
    }

    @NotNull
    default public DataType getRightType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getRightType"));
        }
        return dataType;
    }

    @NotNull
    default public DataType getResultType() {
        DataType dataType = ModelConsts.NO_DATA_TYPE;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresOperator", "getResultType"));
        }
        return dataType;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        DataType resultType;
        DataType rightType;
        DataType leftType;
        String callRoutineName;
        PostgresOperatorKind operatorKind;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresOperator", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((operatorKind = this.getOperatorKind()) != null && operatorKind != PostgresOperatorKind.UNKNOWN) {
            consumer.accept("OperatorKind", PropertyConverter.export(operatorKind));
        }
        if ((callRoutineName = this.getCallRoutineName()) != null) {
            consumer.accept("CallRoutineName", PropertyConverter.export(callRoutineName));
        }
        if ((leftType = this.getLeftType()) != null && leftType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("LeftType", PropertyConverter.export(leftType));
        }
        if ((rightType = this.getRightType()) != null && rightType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("RightType", PropertyConverter.export(rightType));
        }
        if ((resultType = this.getResultType()) != null && resultType != ModelConsts.NO_DATA_TYPE) {
            consumer.accept("ResultType", PropertyConverter.export(resultType));
        }
    }
}

