/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresCheck;
import com.intellij.database.model.postgres.PostgresForeignKey;
import com.intellij.database.model.postgres.PostgresIndex;
import com.intellij.database.model.postgres.PostgresKey;
import com.intellij.database.model.postgres.PostgresLikeTable;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresTable
extends PostgresLikeTable,
BasicTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresSchema getSchema();

    @Override
    @Nullable
    default public PostgresSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends PostgresTableColumn> getColumns();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresIndex> getIndices();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresKey> getKeys();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresForeignKey> getForeignKeys();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresCheck> getChecks();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresRule> getRules();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresTrigger> getTriggers();

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getRules(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append(this.getRules()).append(this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresTable", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean temporary;
        boolean system;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresTable", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", PropertyConverter.export(temporary));
        }
    }
}

