/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.MysqlEngine;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.TimestampParsingException;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConverter {
    public static final SimpleDateFormat FORMAL_TIMESTAMP_FORMAT_19 = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss");
    public static final SimpleDateFormat FORMAL_TIMESTAMP_FORMAT_23 = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss.SSS");

    public static String export(boolean value) {
        return value ? "1" : "0";
    }

    public static String export(byte value) {
        return Byte.toString(value);
    }

    public static String export(short value) {
        return Short.toString(value);
    }

    public static String export(int value) {
        return Integer.toString(value);
    }

    public static String export(long value) {
        return Long.toString(value);
    }

    public static String export(float value) {
        return Float.toString(value);
    }

    public static String export(double value) {
        return Double.toString(value);
    }

    @Nullable
    public static String export(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return StringUtil.nullize((String)string);
    }

    public static String export(@NotNull Date timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestamp", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return PropertyConverter.formatTimestamp(timestamp);
    }

    public static String export(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return kind.code();
    }

    public static String export(@NotNull DataType dt) {
        if (dt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dt", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return DataTypeFactory.serialize(dt);
    }

    public static String export(@NotNull SequenceIdentity si) {
        if (si == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "si", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return si.getSpecification();
    }

    public static String export(@NotNull Enum item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return item.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    public static String export(@NotNull DasArgument.Direction dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/database/model/properties/PropertyConverter", "export"));
        }
        return Character.toString(dir.code);
    }

    @Nullable
    public static String exportListOfString(@NotNull List<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/model/properties/PropertyConverter", "exportListOfString"));
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportSetOfString(@NotNull Set<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/model/properties/PropertyConverter", "exportSetOfString"));
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportCollectionOfString(@NotNull Collection<String> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/model/properties/PropertyConverter", "exportCollectionOfString"));
        }
        int n = strings.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return strings.iterator().next();
            }
        }
        return StringUtil.join(strings, (String)"\n");
    }

    @Nullable
    public static String exportSetOfTrigEvent(@NotNull Set<TrigEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/model/properties/PropertyConverter", "exportSetOfTrigEvent"));
        }
        StringBuilder b = new StringBuilder(events.size());
        for (TrigEvent event : events) {
            b.append(event.code);
        }
        return b.toString();
    }

    public static boolean importBoolean(String text) {
        char c = text != null && !text.isEmpty() ? text.charAt(0) : (char)'\u0000';
        c = Character.toUpperCase(c);
        return c >= '1' && c <= '9' || c == 'Y' || c == 'T' || c == '+';
    }

    public static byte importByte(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            return Byte.parseByte(text.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short importShort(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            return Short.parseShort(text.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int importInt(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long importLong(String text) {
        if (text == null || text.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(text.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float importFloat(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(text.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double importDouble(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static String importString(String text) {
        return text;
    }

    public static ObjectKind importObjectKind(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return (ObjectKind)ObjectKind.ourKinds.get(text.trim().toLowerCase(Locale.ENGLISH));
    }

    public static DataType importDataType(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return DataTypeFactory.deserialize(text);
    }

    public static DasRoutine.Kind importDasRoutineKind(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return DasRoutine.Kind.byChar((char)text.charAt(0));
    }

    public static DasArgument.Direction importDasArgumentDirection(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return DasArgument.Direction.of((char)text.charAt(0));
    }

    public static Date importDate(String text) {
        return PropertyConverter.parseTimestamp(text);
    }

    public static Set<String> importSetOfString(String text) {
        if (text == null || text.length() == 0) {
            return Collections.emptySet();
        }
        List items = StringUtil.split((String)text, (String)"\n");
        int n = items.size();
        switch (n) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(items.get(0));
            }
        }
        return new TreeSet<String>(items);
    }

    public static List<String> importListOfString(String text) {
        if (text == null || text.length() == 0) {
            return Collections.emptyList();
        }
        return StringUtil.split((String)text, (String)"\n");
    }

    public static SequenceIdentity importSequenceIdentity(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return SequenceIdentity.of(text);
    }

    @NotNull
    public static Set<TrigEvent> importSetOfTrigEvent(String text) {
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        for (TrigEvent e : TrigEvent.values()) {
            if (text.indexOf(e.code) < 0) continue;
            events.add(e);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PropertyConverter", "importSetOfTrigEvent"));
        }
        return enumSet;
    }

    public static TrigEvent importTrigEvent(String text) {
        return PropertyConverter.importEnum(TrigEvent.class, text);
    }

    public static TrigTurn importTrigTurn(String text) {
        return PropertyConverter.importEnum(TrigTurn.class, text);
    }

    public static CascadeRule importCascadeRule(String text) {
        return PropertyConverter.importEnum(CascadeRule.class, text);
    }

    public static PostgresDataTypeSubKind importPostgresDataTypeSubKind(String text) {
        return PropertyConverter.importEnum(PostgresDataTypeSubKind.class, text);
    }

    public static PostgresDataTypeSubCategory importPostgresDataTypeSubCategory(String text) {
        return PropertyConverter.importEnum(PostgresDataTypeSubCategory.class, text);
    }

    public static PostgresOperatorKind importPostgresOperatorKind(String text) {
        return PropertyConverter.importEnum(PostgresOperatorKind.class, text);
    }

    public static MysqlEngine importMysqlEngine(String text) {
        return PropertyConverter.importEnum(MysqlEngine.class, text);
    }

    public static <E extends Enum<E>> E importEnum(Class<E> enumClass, String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return Enum.valueOf(enumClass, text.trim());
    }

    @Contract(value="!null->!null;null->null")
    public static String formatTimestamp(Date timestamp) {
        if (timestamp == null) {
            return null;
        }
        long t = timestamp.getTime();
        boolean withMillis = t / 1000L * 1000L != t;
        String result = withMillis ? PropertyConverter.formatTimestampWithMilliSeconds(timestamp) : PropertyConverter.formatTimestampWithSeconds(timestamp);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static String formatTimestampWithSeconds(Date timestamp) {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_19;
        // MONITORENTER : simpleDateFormat
        String string = FORMAL_TIMESTAMP_FORMAT_19.format(timestamp);
        // MONITOREXIT : simpleDateFormat
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PropertyConverter", "formatTimestampWithSeconds"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static String formatTimestampWithMilliSeconds(Date timestamp) {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_23;
        // MONITORENTER : simpleDateFormat
        String string = FORMAL_TIMESTAMP_FORMAT_23.format(timestamp);
        // MONITOREXIT : simpleDateFormat
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PropertyConverter", "formatTimestampWithMilliSeconds"));
    }

    @Nullable
    public static Date parseTimestamp(String string) throws TimestampParsingException {
        if (string == null) {
            return null;
        }
        String str = string.trim();
        int n = str.length();
        try {
            switch (n) {
                case 19: {
                    return PropertyConverter.parseTimestampWithSeconds(string);
                }
                case 23: {
                    return PropertyConverter.parseTimestampWithMilliSeconds(string);
                }
                case 0: {
                    return null;
                }
            }
            throw new TimestampParsingException("The string '" + str + "' is not a valid date or timestamp: the string length is incorrect");
        }
        catch (ParseException pe) {
            throw new TimestampParsingException("The string '" + str + "' is not a valid date or timestamp: " + pe.getMessage(), pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseTimestampWithSeconds(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_19;
        synchronized (simpleDateFormat) {
            return FORMAL_TIMESTAMP_FORMAT_19.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseTimestampWithMilliSeconds(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = FORMAL_TIMESTAMP_FORMAT_23;
        synchronized (simpleDateFormat) {
            return FORMAL_TIMESTAMP_FORMAT_23.parse(string);
        }
    }
}

