/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sybase.SybaseCheck;
import com.intellij.database.model.sybase.SybaseModConstraint;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseModCheck
extends SybaseCheck,
SybaseModConstraint {
    @Override
    @NotNull
    public SybaseModTable getTable();

    @Override
    @NotNull
    default public SybaseModTable getDbParent() {
        SybaseModTable sybaseModTable = this.getTable();
        if (sybaseModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModCheck", "getDbParent"));
        }
        return sybaseModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends SybaseModCheck> getParentFamily();

    @Override
    @NotNull
    default public SybaseModSchema getSchema() {
        SybaseModSchema sybaseModSchema = this.getTable().getSchema();
        if (sybaseModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModCheck", "getSchema"));
        }
        return sybaseModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModCheck", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModCheck", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setColNames(@NotNull List<String> var1);

    @Override
    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    @Override
    public void setDeferrable(boolean var1);

    @Override
    public void setInitiallyDeferred(boolean var1);

    public void setPredicate(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sybase/SybaseModCheck", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String deferrable = properties.get("Deferrable");
        String initiallyDeferred = properties.get("InitiallyDeferred");
        String predicate = properties.get("Predicate");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (deferrable != null) {
            this.setDeferrable(PropertyConverter.importBoolean(deferrable));
        }
        if (initiallyDeferred != null) {
            this.setInitiallyDeferred(PropertyConverter.importBoolean(initiallyDeferred));
        }
        if (predicate != null) {
            this.setPredicate(PropertyConverter.importString(predicate));
        }
    }
}

