/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IntIntFunction;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.actions.DeleteRowsAction;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.run.ui.GridSelectionGrower;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.TableResultRowHeader;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.DefaultGridColumnLayout;
import com.intellij.database.run.ui.grid.DummyGridColumnLayout;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridMarkupModelImpl;
import com.intellij.database.run.ui.grid.GridRawIndexConverter;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.grid.GridScrollPane;
import com.intellij.database.run.ui.grid.GridScrollPosition;
import com.intellij.database.run.ui.grid.GridSearchSession;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactories;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.JBAutoscroller;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultPanel
extends UserDataHolderBase
implements DataGrid,
SelectionModel<DataConsumer.Row, DataConsumer.Column>,
GridModel.Listener<DataConsumer.Row, DataConsumer.Column>,
GridSearchSession.Listener {
    private static final String XML_LANGUAGE_ID = "XML";
    private static final String JSON_LANGUAGE_ID = "JSON";
    private ErrorNotificationPanel myErrorNotificationPanel;
    private final GridMainPanel myMainPanel;
    private final TableResultView myTable;
    private final ActionGroup myPopupActionGroup;
    private final ColumnAttributes myColumnAttributes;
    private boolean myFailedToSubmitInsertedRow;
    private final GridColumnLayout<DataConsumer.Row, DataConsumer.Column> myColumnLayout;
    private final Project myProject;
    private final ObjectFormatter myConverter;
    protected final GridFilterPanel myFilterPanel;
    private final EventDispatcher<DataGridListener> myEventDispatcher;
    private final GridMarkupModel<DataConsumer.Row, DataConsumer.Column> myMarkupModel;
    private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myDataHookUp;
    private final JScrollPane myScrollPane;
    private final GridRowHeader myRowHeader;
    private final HiddenColumnsSelectionHolder myHiddenColumnSelectionHolder;
    private final JBAutoscroller.AutoscrollLocker myAutoscrollLocker;
    private final GridSelectionGrower myGrower;
    private GridSearchSession<DataConsumer.Row, DataConsumer.Column> mySearchSession;
    private boolean myReady;

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (dataHookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHookUp", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (popupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        this(project, dataHookUp, popupActions, popupActions, DataGridUtil.getGridColumnHeaderPopupActions(), null, false);
    }

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, @NotNull ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderPopupActions, @Nullable GridCellEditorFactoryProvider cellEditorFactoryProvider, boolean useConsoleFonts) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (dataHookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHookUp", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (popupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (gutterPopupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gutterPopupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        if (columnHeaderPopupActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnHeaderPopupActions", "com/intellij/database/run/ui/TableResultPanel", "<init>"));
        }
        this.myConverter = new ObjectFormatter();
        this.myEventDispatcher = EventDispatcher.create(DataGridListener.class);
        this.myReady = true;
        this.myProject = project;
        this.myPopupActionGroup = popupActions;
        this.myMarkupModel = new GridMarkupModelImpl<DataConsumer.Row, DataConsumer.Column>();
        this.myHiddenColumnSelectionHolder = new HiddenColumnsSelectionHolder();
        this.myGrower = new GridSelectionGrower(this);
        this.myDataHookUp = dataHookUp;
        this.installDataHookUpListeners();
        this.myFilterPanel = new GridFilterPanel(this.myProject, this);
        this.myFilterPanel.setVisible(this.isFilteringEnabledInModel());
        this.myMainPanel = new GridMainPanel(this);
        DataManager.registerDataProvider((JComponent)((Object)this.myMainPanel), (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                return TableResultPanel.this.getData(dataId);
            }
        });
        this.myMainPanel.setLoadingText("");
        this.myColumnAttributes = new ColumnAttributes();
        this.myTable = this.createTableView((GridCellEditorFactoryProvider)ObjectUtils.notNull((Object)cellEditorFactoryProvider, (Object)GridCellEditorFactories.getInstance()), useConsoleFonts, columnHeaderPopupActions);
        this.myRowHeader = this.createRowHeader(gutterPopupActions);
        this.myTable.getEmptyText().setText("");
        this.myTable.setSelectionMode(2);
        this.myTable.setCellSelectionEnabled(true);
        this.myTable.setAutoResizeMode(0);
        this.myTable.setBackground(this.myMainPanel.getBackground());
        this.myTable.setShowGrid(true);
        this.registerEscapeAction();
        this.myAutoscrollLocker = new JBAutoscroller.AutoscrollLocker();
        this.myScrollPane = new GridScrollPane((JTable)((Object)this.myTable), this.myTable.getTableHeader(), this.myRowHeader, (JComponent)((Object)new MyCornerToolsComponent()), this.myAutoscrollLocker){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && !MouseGestureManager.getInstance().hasTrackpad() && EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
                    TableResultPanel.this.myTable.changeFontSize(-e.getWheelRotation(), 1.0);
                    return;
                }
                super.processMouseWheelEvent(e);
            }

            public void paint(Graphics g) {
                TableResultPanel.this.myTable.startPaintingSession();
                try {
                    super.paint(g);
                }
                finally {
                    TableResultPanel.this.myTable.endPaintingSession();
                }
            }
        };
        this.myMainPanel.add(this.myScrollPane, "Center");
        this.myTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$3", "mousePressed"));
                }
                if (JBSwingUtilities.isRightMouseButton((MouseEvent)e)) {
                    int rowIndex = TableResultPanel.this.myTable.rowAtPoint(e.getPoint());
                    int columnIndex = TableResultPanel.this.myTable.columnAtPoint(e.getPoint());
                    if (rowIndex >= 0 && columnIndex >= 0 && !TableResultPanel.this.myTable.isCellSelected(rowIndex, columnIndex)) {
                        GridSelection.setRowSelection((JTable)((Object)TableResultPanel.this.myTable), rowIndex);
                        GridSelection.setColumnSelection((JTable)((Object)TableResultPanel.this.myTable), columnIndex);
                    }
                }
            }
        });
        this.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$4", "valueChanged"));
                }
                ((DataGridListener)TableResultPanel.this.myEventDispatcher.getMulticaster()).onSelectionChanged(TableResultPanel.this);
                TableResultPanel.this.getScrollPane().repaint();
            }
        });
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/TableResultPanel$5", "valueChanged"));
                }
                TableResultPanel.this.myHiddenColumnSelectionHolder.setWholeRowSelected(false);
                TableResultPanel.this.myGrower.reset();
                TableResultPanel.this.getScrollPane().repaint();
            }
        });
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (!TableResultPanel.this.stopEditing()) {
                    TableResultPanel.this.cancelEditing();
                }
                if (TableResultPanel.this.myPopupActionGroup != ActionGroup.EMPTY_GROUP) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myPopupActionGroup).getComponent().show(comp, x, y);
                }
            }
        });
        this.myColumnLayout = ApplicationManager.getApplication().isUnitTestMode() ? new DummyGridColumnLayout() : new DefaultGridColumnLayout(this);
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel != null) {
            sortingModel.addListener(new GridSortingModel.Listener(){

                @Override
                public void orderingChanged() {
                    TableResultPanel.this.updateColumnAttributes();
                    TableResultPanel.this.updateSortKeysFromColumnAttributes();
                }
            }, this);
        }
        if (this.getDataModel().getColumnCount() != 0) {
            DbUIUtil.invokeLaterIfNeeded(() -> {
                this.columnsAdded(this.getDataModel().getColumnIndices());
                this.resizeTable(true);
            });
        }
    }

    public GridColumnLayout<DataConsumer.Row, DataConsumer.Column> getColumnLayout() {
        return this.myColumnLayout;
    }

    public JBAutoscroller.AutoscrollLocker getAutoscrollLocker() {
        return this.myAutoscrollLocker;
    }

    HiddenColumnsSelectionHolder getHiddenColumnSelectionHolder() {
        return this.myHiddenColumnSelectionHolder;
    }

    ColumnAttributes getColumnAttributes() {
        return this.myColumnAttributes;
    }

    @NotNull
    protected GridRowHeader createRowHeader(ActionGroup popupActions) {
        TableResultRowHeader tableResultRowHeader = new TableResultRowHeader(this, popupActions);
        if (tableResultRowHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createRowHeader"));
        }
        return tableResultRowHeader;
    }

    @NotNull
    protected TableResultView createTableView(@NotNull GridCellEditorFactoryProvider editorProvider, boolean useConsoleFonts, @NotNull ActionGroup headerActions) {
        if (editorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorProvider", "com/intellij/database/run/ui/TableResultPanel", "createTableView"));
        }
        if (headerActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerActions", "com/intellij/database/run/ui/TableResultPanel", "createTableView"));
        }
        TableResultView tableResultView = new TableResultView(this, editorProvider, useConsoleFonts, headerActions);
        if (tableResultView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createTableView"));
        }
        return tableResultView;
    }

    @NotNull
    protected RowFilter<TableModel, Integer> createFilter() {
        RowFilter rowFilter = this.isTransposed() ? new MyTransposedViewColumnFilter() : new MySearchRowFilter();
        if (rowFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createFilter"));
        }
        return rowFilter;
    }

    private void installDataHookUpListeners() {
        this.myDataHookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message, @Nullable Throwable th) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/ui/TableResultPanel$8", "error"));
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (message != null) {
                    Throwable throwable = new Throwable(message);
                    throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
                    th = throwable;
                }
                if (th != null) {
                    TableResultPanel.this.handleError(source, th);
                }
                if (source.source instanceof MyRequestSource) {
                    ((MyRequestSource)((Object)source.source)).setErrorReported();
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/ui/TableResultPanel$8", "updateCountReceived"));
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (source.source instanceof MyRequestSource) {
                    ((MyRequestSource)((Object)source.source)).setUpdateCount(updateCount);
                }
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                int actualUpdateCount;
                int expectedUpdateCount;
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/run/ui/TableResultPanel$8", "requestFinished"));
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                MyRequestSource requestSource = (MyRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, MyRequestSource.class));
                if (requestSource == null) {
                    return;
                }
                if (success && !requestSource.isErrorReported() && DataGridUtil.getDataBusHookUp(TableResultPanel.this) != null && (expectedUpdateCount = requestSource.rows.size()) != (actualUpdateCount = requestSource.getUpdateCount())) {
                    Exception e = new Exception(actualUpdateCount + " rows updated.");
                    e.setStackTrace(new StackTraceElement[0]);
                    TableResultPanel.this.showError(e, requestSource);
                }
                requestSource.requestComplete(success);
            }
        }, this);
        this.getDataModel().addListener(this, this);
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        List<DataConsumer.Column> columns = this.getDataModel().getColumns();
        if (!this.isTransposed()) {
            this.myTable.getColumnCache().retainColumns(columns);
        }
        this.myColumnAttributes.newColumns(this, columns);
        this.updateColumnAttributes();
        this.updateSortKeysFromColumnAttributes();
        if (!this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myTable.getModel().columnsAdded(columnIndices);
        this.myTable.dropCaches();
        this.myColumnLayout.newColumnsAdded(columnIndices);
        this.resizeTable(false);
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
        this.myTable.getModel().columnsRemoved(columns);
        if (!this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myTable.dropCaches();
        this.resizeTable(false);
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.myTable.getModel().rowsAdded(rows);
        if (this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.myColumnLayout.newRowsAdded(rows);
        this.resizeTable(false);
        this.myFailedToSubmitInsertedRow = false;
    }

    @Override
    public void setCommonEditorValue(@Nullable Object object) {
        this.myTable.setCommonEditorValue(object);
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.myTable.getModel().rowsRemoved(rows);
        if (this.isTransposed()) {
            this.myTable.createDefaultColumnsFromModel();
        }
        this.resizeTable(false);
        this.myFailedToSubmitInsertedRow = false;
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns) {
        this.myTable.getModel().cellsUpdated(rows, columns);
        this.myColumnLayout.newRowsAdded(rows);
    }

    private void registerEscapeAction() {
        String action = "grid.escape";
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), action);
        this.myTable.getActionMap().put(action, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableResultPanel.this.myErrorNotificationPanel != null) {
                    TableResultPanel.this.hideErrorPanel();
                } else if (TableResultPanel.this.mySearchSession != null) {
                    TableResultPanel.this.mySearchSession.close();
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !TableResultPanel.this.isEditing() && (TableResultPanel.this.myErrorNotificationPanel != null || TableResultPanel.this.mySearchSession != null);
            }
        });
    }

    @Override
    public boolean isSortViaOrderBySupported() {
        return this.myDataHookUp.getSortingModel() != null;
    }

    @Override
    public boolean isSortViaOrderBy() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        return sortingModel != null && sortingModel.isSortingEnabled();
    }

    @Override
    public void setSortViaOrderBy(boolean sortViaOrderBy) {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return;
        }
        boolean reload = this.updateDataOrdering(false) || sortingModel.isSortingEnabled() != sortViaOrderBy;
        sortingModel.setSortingEnabled(sortViaOrderBy);
        if (reload && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
    }

    public void setOrdering(List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> o : ordering) {
            ModelIndex<DataConsumer.Column> columnIdx = o.getColumn();
            DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
            this.myColumnAttributes.changeSortOrder(column, o.getOrder());
        }
        this.updateSortKeysFromColumnAttributes();
    }

    @Override
    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int sortOrder;
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getSortOrder"));
        }
        int n = sortOrder = this.shouldExposeSortingInfo() ? this.getSortOrder(this.getDataModel().getColumn(columnIdx)) : 0;
        RowSortOrder.Type type = sortOrder == 0 ? RowSortOrder.Type.UNSORTED : (sortOrder < 0 ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSortOrder"));
        }
        return type;
    }

    @Override
    public int getThenBySortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getThenBySortOrder"));
        }
        return this.shouldExposeSortingInfo() ? Math.abs(this.getSortOrder(this.getDataModel().getColumn(columnIdx))) : 0;
    }

    private boolean shouldExposeSortingInfo() {
        return !this.isTransposed() || this.isSortViaOrderBy();
    }

    protected int getSortOrder(@Nullable DataConsumer.Column column) {
        return column != null ? this.myColumnAttributes.getSortOrder(column) : 0;
    }

    @Override
    public void addDataGridListener(DataGridListener listener, Disposable disposable) {
        this.myEventDispatcher.addListener((EventListener)listener, disposable);
    }

    private void addSelectionListener(ListSelectionListener selectionListener) {
        this.myTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
    }

    @Override
    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myTable.getColorsScheme();
        if (gridColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getColorsScheme"));
        }
        return gridColorsScheme;
    }

    @Override
    @Nullable
    public JComponent getCellRendererComponent(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int column;
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/TableResultPanel", "getCellRendererComponent"));
        }
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getCellRendererComponent"));
        }
        ViewIndex<DataConsumer.Row> viewRow = rowIdx.toView(this);
        ViewIndex<DataConsumer.Column> viewColumn = columnIdx.toView(this);
        if (!viewRow.isValid(this) || !viewColumn.isValid(this)) {
            return null;
        }
        int row = (this.isTransposed() ? viewColumn : viewRow).asInteger();
        TableCellRenderer renderer = this.myTable.getCellRenderer(row, column = (this.isTransposed() ? viewRow : viewColumn).asInteger());
        if (renderer == null) {
            return null;
        }
        return (JComponent)this.myTable.prepareRenderer(renderer, row, column);
    }

    @Override
    public void searchSessionStarted(@NotNull GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession) {
        if (searchSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchSession", "com/intellij/database/run/ui/TableResultPanel", "searchSessionStarted"));
        }
        assert (this.mySearchSession == null);
        this.mySearchSession = searchSession;
        this.mySearchSession.addListener(this, this);
        this.searchSessionUpdated();
    }

    @Override
    public void searchSessionStopped(@NotNull GridSearchSession<DataConsumer.Row, DataConsumer.Column> searchSession) {
        if (searchSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchSession", "com/intellij/database/run/ui/TableResultPanel", "searchSessionStopped"));
        }
        assert (this.mySearchSession == searchSession);
        this.mySearchSession = null;
        this.searchSessionUpdated();
    }

    @Override
    @Nullable
    public GridSearchSession<DataConsumer.Row, DataConsumer.Column> getSearchSession() {
        return this.mySearchSession;
    }

    @Override
    public void searchSessionUpdated() {
        this.myTable.updateRowFilter();
        this.getComponent().repaint();
    }

    protected TableResultView getTable() {
        return this.myTable;
    }

    public JBTable getTableView() {
        return this.myTable;
    }

    protected TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
        return this.myColumnAttributes.getSortOrderMap();
    }

    @Override
    public ObjectFormatter getObjectFormatter() {
        return this.myConverter;
    }

    @Override
    public boolean isEditable() {
        return this.myReady && !this.myDataHookUp.isReadOnly() && !DataImporter.isBusy(DataGridUtil.getDatabaseTable(this));
    }

    @Override
    public boolean isCellEditingAllowed() {
        return true;
    }

    @Override
    public void setCells(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "setCells"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "setCells"));
        }
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        if (mutator != null && this.isSafeToUpdate(rows, columns, value)) {
            MyRequestSource source = new MyRequestSource(this, rows, columns);
            mutator.update(GridRequestSource.create(this, (Object)source), rows, columns, value);
        }
    }

    @Override
    public boolean isEditingCellMaximized() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        return resizableCellEditorsSupport != null && resizableCellEditorsSupport.isEditingCellMaximized();
    }

    @Override
    public boolean canMaximizeEditingCell() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        return resizableCellEditorsSupport != null && resizableCellEditorsSupport.canMaximizeEditingCell();
    }

    @Override
    public void maximizeEditingCell() {
        ResizableCellEditorsSupport resizableCellEditorsSupport = ResizableCellEditorsSupport.get((JTable)((Object)this.myTable));
        if (resizableCellEditorsSupport != null) {
            resizableCellEditorsSupport.maximizeEditingCell();
        }
    }

    Project getProject() {
        return this.myProject;
    }

    @Override
    public void insertRow() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        this.doSubmitInsertedRow().doWhenDone(() -> mutator.insertRow(this.newInsertOrCloneRowRequestSource()));
    }

    @Override
    public void cloneRow(@NotNull ModelIndex<DataConsumer.Row> rowToClone) {
        if (rowToClone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowToClone", "com/intellij/database/run/ui/TableResultPanel", "cloneRow"));
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone);
    }

    private GridRequestSource<DataConsumer.Row, DataConsumer.Column> newInsertOrCloneRowRequestSource() {
        MyRequestSource source = new MyRequestSource(this);
        source.doWhenDone(() -> {
            GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
            ModelIndex<DataConsumer.Row> row = mutator != null ? mutator.getInsertedRow() : ModelIndex.forRow(this, -1);
            row = row.isValid(this) ? row : ModelIndex.forRow(this, this.getDataModel().getRowCount() - 1);
            this.scrollToLocally(row.toView(this), ViewIndex.forColumn(this, 0));
        });
        return GridRequestSource.create(this, (Object)source);
    }

    @Override
    public void insertColumn() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.doSubmitInsertedRow().doWhenDone(() -> mutator.insertColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource())));
    }

    @Override
    public void cloneColumn(@NotNull ModelIndex<DataConsumer.Column> columnToClone) {
        if (columnToClone == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnToClone", "com/intellij/database/run/ui/TableResultPanel", "cloneColumn"));
        }
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.doSubmitInsertedRow().doWhenDone(() -> {
            if (columnToClone == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnToClone", "com/intellij/database/run/ui/TableResultPanel", "lambda$cloneColumn$4"));
            }
            mutator.cloneColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource()), columnToClone);
        });
    }

    private MyRequestSource newInsertOrCloneColumnRequestSource() {
        MyRequestSource source = new MyRequestSource(this);
        source.doWhenDone(() -> {
            ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(this, this.getDataModel().getColumnCount() - 1);
            this.scrollToLocally(ViewIndex.forRow(this, 0), column.toView(this));
        });
        return source;
    }

    @Override
    public void deleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "deleteRows"));
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        if (!mutator.hasPendingChanges() || rows.asIterable().contains(mutator.getInsertedRow()) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this)) {
            GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
            MyRequestSource source = new MyRequestSource(this, rows, ModelIndexSet.forColumns(this, new int[0]));
            mutator.deleteRows(GridRequestSource.create(this, (Object)source), rows);
            selection.restore((JTable)((Object)this.myTable));
        }
    }

    @Override
    public boolean isRowsMutationSupported() {
        return this.getRowsMutator() != null;
    }

    @Override
    public void deleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "deleteColumns"));
        }
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator != null) {
            MyRequestSource source = new MyRequestSource(this, ModelIndexSet.forRows(this, new int[0]), columns);
            mutator.deleteColumns(GridRequestSource.create(this, (Object)source), columns);
        }
    }

    @Override
    public boolean isColumnsMutationSupported() {
        return this.getColumnsMutator() != null;
    }

    @Override
    public void submitInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "submitInsertedRow"));
        }
        this.doSubmitInsertedRow();
    }

    @NotNull
    private ActionCallback doSubmitInsertedRow() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null || !mutator.getInsertedRow().isValid(this)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "doSubmitInsertedRow"));
            }
            return actionCallback;
        }
        MyRequestSource source = new MyRequestSource(this, mutator.getInsertedRow(), ModelIndex.forColumn(this, -1));
        mutator.submitInsertedRow(GridRequestSource.create(this, (Object)source));
        MyRequestSource myRequestSource = source;
        if (myRequestSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "doSubmitInsertedRow"));
        }
        return myRequestSource;
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        GridMutator.RowsMutator mutator = (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.RowsMutator.class);
        return mutator;
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        GridMutator.ColumnsMutator mutator = (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.ColumnsMutator.class);
        return mutator;
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "isInsertedRow"));
        }
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        ModelIndex<DataConsumer.Row> insertedRow = mutator != null ? mutator.getInsertedRow() : ModelIndex.forRow(this, -1);
        return insertedRow.isValid(this) && insertedRow.equals(row);
    }

    @Override
    public int getSelectedRowCount() {
        return this.isTransposed() ? this.myTable.getSelectedColumnCount() : this.myTable.getSelectedRowCount();
    }

    @Override
    public int getSelectedColumnCount() {
        return this.isTransposed() ? this.myTable.getSelectedRowCount() : this.myTable.getSelectedColumnCount();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> getSelectedRow() {
        int viewRowIndex = this.isTransposed() ? this.myTable.getSelectedColumn() : this.myTable.getSelectedRow();
        ModelIndex<DataConsumer.Row> modelIndex = ViewIndex.forRow(this, viewRowIndex >= 0 ? viewRowIndex : -1).toModel(this);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedRow"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getSelectedRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = ViewIndexSet.forRows(this, this.isTransposed() ? this.myTable.getSelectedColumns() : this.myTable.getSelectedRows()).toModel(this);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedRows"));
        }
        return modelIndexSet;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.myTable.getSelectionModel().isSelectionEmpty() || this.myTable.getColumnModel().getSelectionModel().isSelectionEmpty();
    }

    @Override
    public boolean isSelected(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "isSelected"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "isSelected"));
        }
        ViewIndex<DataConsumer.Row> viewRow = row.toView(this);
        ViewIndex<DataConsumer.Column> viewColumn = column.toView(this);
        int displayRow = this.isTransposed() ? viewColumn.asInteger() : viewRow.asInteger();
        int displayColumn = this.isTransposed() ? viewRow.asInteger() : viewColumn.asInteger();
        return this.myTable.isRowSelected(displayRow) && this.myTable.isColumnSelected(displayColumn);
    }

    @Override
    public void clearSelection() {
        this.myTable.clearSelection();
    }

    @Override
    @NotNull
    public SelectionModel<DataConsumer.Row, DataConsumer.Column> getSelectionModel() {
        TableResultPanel tableResultPanel = this;
        if (tableResultPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectionModel"));
        }
        return tableResultPanel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        DataRequest.OwnerEx ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(this.getDataHookup(), DataRequest.OwnerEx.class);
        String string = ownerEx != null ? StringUtil.notNullize((String)ownerEx.getDisplayName()) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public GridMarkupModel<DataConsumer.Row, DataConsumer.Column> getMarkupModel() {
        GridMarkupModel<DataConsumer.Row, DataConsumer.Column> gridMarkupModel = this.myMarkupModel;
        if (gridMarkupModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getMarkupModel"));
        }
        return gridMarkupModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel() {
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.myDataHookUp.getModel();
        if (gridModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getDataModel"));
        }
        return gridModel;
    }

    @Override
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getDataHookup() {
        return this.myDataHookUp;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        GridRawIndexConverter gridRawIndexConverter = this.myTable.getRawIndexConverter();
        if (gridRawIndexConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getRawIndexConverter"));
        }
        return gridRawIndexConverter;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        TableResultView tableResultView = this.myTable;
        if (tableResultView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getPreferredFocusedComponent"));
        }
        return tableResultView;
    }

    @Override
    @NotNull
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = this.myScrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getScrollPane"));
        }
        return jScrollPane;
    }

    @Override
    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getLoadingPanel"));
        }
        return gridMainPanel;
    }

    @NotNull
    public JBLoadingPanel getComponent() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getComponent"));
        }
        return gridMainPanel;
    }

    @Override
    public void setTopComponent(@Nullable Component component) {
        this.myMainPanel.setTopComponent(component);
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return this.myMainPanel.getTopComponent();
    }

    @Override
    @Nullable
    public GridColumn getLayoutColumn(@NotNull ModelIndex<?> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getLayoutColumn"));
        }
        GridRawIndexConverter rawIndexConverter = this.myTable.getRawIndexConverter();
        IntIntFunction toView = this.isTransposed() ? rawIndexConverter.row2View() : rawIndexConverter.column2View();
        int viewColumnIdx = toView.fun(column.asInteger());
        return viewColumnIdx != -1 ? this.myTable.getColumnCache().getOrCreateColumn(column.asInteger()) : null;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        int visibleColumns = this.getVisibleColumnCount();
        int[] viewIndices = new int[visibleColumns];
        for (int i = 0; i < visibleColumns; ++i) {
            viewIndices[i] = i;
        }
        ModelIndexSet<DataConsumer.Column> columnIndices = ViewIndexSet.forColumns(this, viewIndices).toModel(this);
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.validIndexSet(columnIndices, columnIndices1 -> ModelIndexSet.forColumns(this, columnIndices1));
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getVisibleColumns"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        int rowCount = this.isTransposed() ? this.myTable.getModel().getColumnCount() : this.myTable.getModel().getRowCount();
        int[] viewRowIndices = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            viewRowIndices[i] = i;
        }
        ModelIndexSet<DataConsumer.Row> rowIndices = ViewIndexSet.forRows(this, viewRowIndices).toModel(this);
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.validIndexSet(rowIndices, rowIndices1 -> ModelIndexSet.forRows(this, rowIndices1));
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getVisibleRows"));
        }
        return modelIndexSet;
    }

    @NotNull
    private <T> ModelIndexSet<T> validIndexSet(@NotNull ModelIndexSet<T> indexSet, @NotNull Function<int[], ModelIndexSet<T>> factory) {
        if (indexSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexSet", "com/intellij/database/run/ui/TableResultPanel", "validIndexSet"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/database/run/ui/TableResultPanel", "validIndexSet"));
        }
        IntArrayList validIndices = new IntArrayList(indexSet.size());
        for (ModelIndex idx : indexSet.asIterable()) {
            if (!idx.isValid(this)) continue;
            validIndices.add(idx.asInteger());
        }
        ModelIndexSet modelIndexSet = (ModelIndexSet)factory.fun((Object)validIndices.toArray());
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "validIndexSet"));
        }
        return modelIndexSet;
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "setColumnSelection"));
        }
        this.doSetSelection(true, columns.toView(this).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "setRowSelection"));
        }
        this.doSetSelection(false, rows.toView(this).asArray());
    }

    @Override
    public void setRowSelection(@NotNull ModelIndex<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "setRowSelection"));
        }
        this.doSetSelection(false, rows.toView(this).asInteger());
    }

    @Override
    public void setColumnSelection(@NotNull ModelIndex<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "setColumnSelection"));
        }
        this.doSetSelection(true, columns.toView(this).asInteger());
    }

    @Override
    public void selectWholeRow() {
        this.myAutoscrollLocker.runWithLock(() -> {
            this.myHiddenColumnSelectionHolder.setWholeRowSelected(!this.isTransposed());
            GridSelection.setColumnSelectionInterval((JTable)((Object)this.myTable), this.myTable.getColumnCount() - 1, 0);
        });
    }

    @Override
    public void selectWholeColumn() {
        this.myAutoscrollLocker.runWithLock(() -> GridSelection.setRowSelectionInterval((JTable)((Object)this.myTable), this.myTable.getRowCount() - 1, 0));
    }

    private void doSetSelection(boolean isColumnSelection, int ... selection) {
        boolean transposed = this.isTransposed();
        if (isColumnSelection && !transposed || !isColumnSelection && transposed) {
            GridSelection.setColumnSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedRow() == -1) {
                GridSelection.setRowSelection((JTable)((Object)this.myTable), 0);
            }
        } else {
            GridSelection.setRowSelection((JTable)((Object)this.myTable), selection);
            if (this.myTable.getSelectedColumn() == -1) {
                GridSelection.setColumnSelection((JTable)((Object)this.myTable), 0);
            }
        }
    }

    @Override
    public void scrollSelectionToVisible() {
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myTable));
    }

    @Override
    public boolean isEditing() {
        return this.myTable.isEditing();
    }

    @Override
    public boolean stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor == null) {
            return true;
        }
        int columnDataIdx = this.myTable.convertColumnIndexToModel(this.myTable.getEditingColumn());
        int rowDataIdx = this.myTable.convertRowIndexToModel(this.myTable.getEditingRow());
        ModelIndexSet<DataConsumer.Row> myEditingRowIdx = ModelIndexSet.forRows(this, this.isTransposed() ? columnDataIdx : rowDataIdx);
        ModelIndexSet<DataConsumer.Column> myEditingColumnIdx = ModelIndexSet.forColumns(this, this.isTransposed() ? rowDataIdx : columnDataIdx);
        return this.isSafeToUpdate(myEditingRowIdx, myEditingColumnIdx, editor.getCellEditorValue()) && editor.stopCellEditing();
    }

    @Override
    public void cancelEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    @Override
    public void editSelectedCell() {
        int leadRow = this.myTable.getSelectionModel().getLeadSelectionIndex();
        int leadColumn = this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (leadRow == -1 || leadColumn == -1) {
            return;
        }
        TableUtil.editCellAt((JTable)((Object)this.myTable), (int)leadRow, (int)leadColumn);
    }

    @Override
    public boolean isViewModified() {
        for (DataConsumer.Column column : this.getDataModel().getColumns()) {
            boolean sortOrderChanged;
            boolean shouldBeShown = column == null || !DbImplUtil.isComputedColumn(column);
            boolean shown = this.myColumnAttributes.isEnabled(column);
            boolean bl = sortOrderChanged = this.getSortOrder(column) != 0;
            if (shown == shouldBeShown && !sortOrderChanged) continue;
            return true;
        }
        return this.myTable.isViewModified();
    }

    public int getVisibleColumnCount() {
        return this.isTransposed() ? this.myTable.getRowCount() : this.myTable.getColumnCount();
    }

    private void showError(@NotNull Throwable error, @Nullable MyRequestSource source) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/TableResultPanel", "showError"));
        }
        this.hideErrorPanel();
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(error, (JComponent)((Object)this.myMainPanel));
        if (source != null && source.rows.size() == 1) {
            ModelIndex modelRowIdx = (ModelIndex)source.rows.first();
            ModelIndex modelColumnIdx = (ModelIndex)source.cols.first();
            ViewIndex viewRowIdx = modelRowIdx.toView(this);
            ViewIndex viewColumnIdx = modelColumnIdx.toView(this);
            int r = viewRowIdx.asInteger() + 1;
            int c = viewColumnIdx.asInteger() + 1;
            String title = "[row:" + r + (c < 1 ? "" : " col:" + c) + "]";
            builder.addLink("navigate", title, () -> {
                if (viewRowIdx.isValid(this) && viewColumnIdx.isValid(this)) {
                    this.scrollToLocally(viewRowIdx, viewColumnIdx);
                }
            });
            if (modelRowIdx.isValid(this) && this.isInsertedRow(modelRowIdx) && !modelColumnIdx.isValid(this)) {
                this.myFailedToSubmitInsertedRow = true;
            }
        }
        this.myErrorNotificationPanel = builder.addDetailsButton().addCloseButton(this::hideErrorPanel).build();
        this.myMainPanel.setBottomComponent(this.myErrorNotificationPanel);
        this.myErrorNotificationPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void hideErrorPanel() {
        if (this.myErrorNotificationPanel == null) {
            return;
        }
        this.myMainPanel.setBottomComponent(null);
        this.myErrorNotificationPanel = null;
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void handleError(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource, @NotNull Throwable error) {
        if (requestSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestSource", "com/intellij/database/run/ui/TableResultPanel", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/TableResultPanel", "handleError"));
        }
        Object source = requestSource.source;
        DbUIUtil.invokeLater(() -> {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/TableResultPanel", "lambda$handleError$11"));
            }
            if (source == this.myFilterPanel) {
                this.myFilterPanel.showErrorBalloon(error);
            } else {
                this.showError(error, (MyRequestSource)((Object)((Object)ObjectUtils.tryCast((Object)source, MyRequestSource.class))));
            }
        });
    }

    void resizeTable(boolean updateColumnWidths) {
        Container parent;
        Container container = parent = this.myTable != null ? this.myTable.getParent() : null;
        if (parent == null) {
            return;
        }
        if (updateColumnWidths) {
            DbUIUtil.invokeLater(this.myColumnLayout::doLayout);
        }
        Dimension size = parent.getSize();
        this.myTable.setPreferredSize(this.getDataModel().getColumnCount() == 0 ? size : null);
        parent.validate();
    }

    @Nullable
    protected Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new GridCopyProvider(this);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DeleteRowsAction();
        }
        if (DatabaseDataKeys.DATA_GRID_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getPsiElementForSelection();
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    private PsiElement getPsiElementForSelection() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            return DataGridPomTarget.wrapDataGrid(this.myProject, this);
        }
        return DataGridPomTarget.wrapCell(this.myProject, this, selectionModel.getSelectedRows(), selectionModel.getSelectedColumns());
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getSelectedColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = ViewIndex.forColumn(this, this.isTransposed() ? this.myTable.getSelectedRow() : this.myTable.getSelectedColumn()).toModel(this);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedColumn"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getSelectedColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = ViewIndexSet.forColumns(this, this.isTransposed() ? this.myTable.getSelectedRows() : this.myTable.getSelectedColumns()).toModel(this);
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getSelectedColumns"));
        }
        return modelIndexSet;
    }

    @Override
    public void sortColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns, @NotNull RowSortOrder.Type order) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "sortColumns"));
        }
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/database/run/ui/TableResultPanel", "sortColumns"));
        }
        boolean updated = false;
        for (ModelIndex<DataConsumer.Column> column : columns) {
            updated |= this.changeSortOrder(column, order, true);
        }
        if (updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
    }

    @Override
    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        Language language = column != null ? this.getContentLanguage(column) : Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        return language;
    }

    @NotNull
    Language getContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        Language fromAttributes = this.myColumnAttributes.getContentLanguage(column);
        if (fromAttributes != Language.ANY) {
            Language language = fromAttributes;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        DatabaseFamilyId family = DataGridUtil.getDatabaseDialect(this).getFamilyId();
        if (ObjectFormatter.isJson(column, family)) {
            Language language = TableResultPanel.getLanguageByIdOrAny(JSON_LANGUAGE_ID);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        if (family.isTransactSql() && StringUtil.equalsIgnoreCase((CharSequence)"xml", (CharSequence)column.typeName)) {
            Language language = TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        if (column.type == 2009) {
            Language language = TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
            }
            return language;
        }
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContentLanguage"));
        }
        return language;
    }

    @NotNull
    private static Language getLanguageByIdOrAny(@NotNull String languageId) {
        if (languageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageId", "com/intellij/database/run/ui/TableResultPanel", "getLanguageByIdOrAny"));
        }
        Language language = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)languageId), (Object)Language.ANY);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getLanguageByIdOrAny"));
        }
        return language;
    }

    @Override
    public void setContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "setContentLanguage"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/TableResultPanel", "setContentLanguage"));
        }
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column != null) {
            this.myColumnAttributes.setContentLanguage(column, language);
        }
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myTable.getClickedHeaderColumnIdx();
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getContextColumn"));
        }
        return modelIndex;
    }

    @Override
    public boolean setFilterText(String filter, int caretPosition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFilteringEnabled() && !StringUtil.isEmptyOrSpaces((String)filter)) {
            this.toggleFiltering();
        }
        boolean result = this.myFilterPanel.setFilterText(filter, caretPosition);
        GridFilteringModel model = this.myDataHookUp.getFilteringModel();
        if (result && model != null) {
            model.setAppliedFilterText(filter);
        }
        return result;
    }

    @Override
    public void applyFilter() {
        if (this.isSafeToReload()) {
            this.myFilterPanel.currentFilterApplied();
            this.myDataHookUp.getLoader().applyFilter(GridRequestSource.create(this, (Object)this.myFilterPanel));
        }
    }

    @Override
    public boolean isReady() {
        return this.myReady && !this.getDataModel().isUpdatingNow();
    }

    public void setReady(boolean b) {
        this.myReady = b;
    }

    @Override
    public boolean isEmpty() {
        return this.myTable.isEmpty();
    }

    public void dispose() {
        this.myTable.removeEditor();
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Row> uiRow(int uiRow) {
        ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(this, uiRow < 1 ? -1 : uiRow - 1);
        if (modelIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "uiRow"));
        }
        return modelIndex;
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> uiColumn(int uiColumn) {
        int modelIndex = uiColumn < 1 || uiColumn >= this.getVisibleColumnCount() + 1 ? -1 : this.myTable.getRawIndexConverter().column2Model().fun(uiColumn - 1);
        ModelIndex<DataConsumer.Column> modelIndex2 = ModelIndex.forColumn(this, modelIndex);
        if (modelIndex2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "uiColumn"));
        }
        return modelIndex2;
    }

    @Override
    public void showCell(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "showCell"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "showCell"));
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel", "lambda$showCell$12"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "lambda$showCell$12"));
            }
            int rawRowIndex = row.asInteger() + 1;
            this.scrollTo(rawRowIndex, column.toView(this).asInteger());
        });
    }

    private void scrollTo(int dataRowIndex, int viewColumnIndex) {
        GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myDataHookUp.getPageModel();
        Runnable localScrollRunnable = () -> {
            ViewIndex<DataConsumer.Row> row = pageModel.findRow(dataRowIndex).toView(this);
            ViewIndex<DataConsumer.Column> column = ViewIndex.forColumn(this, viewColumnIndex);
            this.scrollToLocally(row, column);
        };
        if (pageModel.findRow(dataRowIndex).isValid(this)) {
            localScrollRunnable.run();
        } else {
            GridLoader<DataConsumer.Row, DataConsumer.Column> loader = this.myDataHookUp.getLoader();
            int startIdx = Math.max(1, dataRowIndex - pageModel.getPageSize() / 2);
            loader.load(GridRequestSource.create(this, new MyRequestSource(this).doWhenDone(localScrollRunnable)), startIdx);
        }
    }

    private void scrollToLocally(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> column) {
        this.setRowSelection(row.toModel(this));
        this.setColumnSelection(column.toModel(this));
    }

    @Override
    public boolean isFilteringSupported() {
        return this.getDataHookup().getFilteringModel() != null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.isFilteringEnabledInModel() && this.myFilterPanel.isVisible();
    }

    private boolean isFilteringEnabledInModel() {
        GridFilteringModel filteringModel = this.getDataHookup().getFilteringModel();
        return filteringModel != null && filteringModel.isFilteringEnabled();
    }

    @Override
    public boolean toggleFiltering() {
        if (!this.isFilteringEnabledInModel()) {
            return false;
        }
        boolean enabled = !this.isFilteringEnabled();
        this.myFilterPanel.setVisible(enabled);
        if (enabled) {
            this.myFilterPanel.requestFocusInWindow();
        }
        return enabled;
    }

    @NotNull
    Color getHeaderCellBackground(boolean selected, boolean inserted, Color tableBg) {
        Object object = inserted ? (this.myFailedToSubmitInsertedRow ? TableResultPanel.getFailedToInsertColor() : this.getInsertedBackgroundColor()) : (selected ? this.getSelectedHeaderCellBackground() : DbUIUtil.softHighlightOf(tableBg));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getHeaderCellBackground"));
        }
        return object;
    }

    private JBColor getSelectedHeaderCellBackground() {
        Color selectedColumnBackground = (Color)ObjectUtils.chooseNotNull((Object)this.getColorsScheme().getColor(DatabaseColors.GRID_CURRENT_ROW), (Object)UIUtil.getDecoratedRowColor());
        return new JBColor(selectedColumnBackground, selectedColumnBackground);
    }

    private Color getInsertedBackgroundColor() {
        return this.getColorsScheme().getAttributes(DiffColors.DIFF_INSERTED).getErrorStripeColor();
    }

    private static Color getFailedToInsertColor() {
        return MessageType.ERROR.getPopupBackground();
    }

    @Override
    public void changeSelectedColumnsWidth(int delta) {
        int[] columns = this.myTable.getSelectedColumns();
        TableColumnModel columnModel = this.myTable.getColumnModel();
        for (int column : columns) {
            int modelIndex;
            if (column == -1 || (modelIndex = this.myTable.convertColumnIndexToModel(column)) == -1) continue;
            GridColumn tableColumn = (GridColumn)((Object)columnModel.getColumn(modelIndex));
            int width = tableColumn.getColumnWidth();
            tableColumn.setColumnWidth(Math.max(0, width + delta));
        }
    }

    @Override
    public void growSelection() {
        this.myGrower.growSelection();
    }

    @Override
    public void doLayout() {
        this.myColumnLayout.doLayout();
    }

    public void fireContentChanged() {
        if (this.myRowHeader instanceof TableResultRowHeader) {
            this.myRowHeader.updatePreferredSize();
            this.myRowHeader.revalidate();
            this.myRowHeader.repaint();
        }
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onContentChanged(this);
    }

    protected boolean isInitiallyDisabled(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "isInitiallyDisabled"));
        }
        return DbImplUtil.isComputedColumn(column);
    }

    protected Language getInitialContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getInitialContentLanguage"));
        }
        return Language.ANY;
    }

    private Formatter getDateFormat(@NotNull DataConsumer.Column column) {
        boolean isPostgresRange;
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getDateFormat"));
        }
        int jdbcType = ExtractorsUtil.guessJdbcType(column);
        ObjectFormatter converter = this.getObjectFormatter();
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(this);
        boolean bl = isPostgresRange = dialect.getFamilyId().isPostgres() && StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"tstzrange", "tsrange"});
        if (isPostgresRange) {
            return RangeFormatResolver.resolveFormatter(converter, column, dialect);
        }
        if (DbImplUtil.isZonedTimestampColumn(column, dialect)) {
            return converter.getZonedTimestampFormat(column, dialect);
        }
        if (DbImplUtil.isZonedTimeColumn(column, dialect)) {
            return converter.getZonedTimeFormat();
        }
        return jdbcType == 91 ? converter.getDateFormat(column, dialect) : (jdbcType == 92 ? converter.getTimeFormat() : (jdbcType == 93 ? converter.getTimestampFormat(column, dialect) : null));
    }

    void setValueAt(ViewIndexSet<DataConsumer.Row> viewRows, ViewIndexSet<DataConsumer.Column> viewColumns, Object value, boolean moveToNextCell) {
        Runnable moveToNextCellRunnable;
        this.hideErrorPanel();
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDataHookup().getMutator();
        int[] validRows = this.valid(viewRows);
        int[] validColumns = this.valid(viewColumns);
        ModelIndexSet<DataConsumer.Row> rows = validRows.length > 0 ? ViewIndexSet.forRows(this, validRows).toModel(this) : null;
        ModelIndexSet<DataConsumer.Column> columns = validRows.length > 0 ? ViewIndexSet.forColumns(this, validColumns).toModel(this) : null;
        Runnable runnable = moveToNextCellRunnable = moveToNextCell ? this.newMoveToNextCellRunnable((ViewIndex)viewRows.last(), (ViewIndex)viewColumns.last()) : EmptyRunnable.INSTANCE;
        if (mutator == null || rows == null || columns == null || this.getDataModel().allValuesEqualTo(rows, columns, value)) {
            DbUIUtil.invokeLater(moveToNextCellRunnable);
            return;
        }
        MyRequestSource requestSource = new MyRequestSource(this, rows, columns);
        requestSource.doWhenDone(moveToNextCellRunnable);
        GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = GridRequestSource.create(this, (Object)requestSource);
        DbUIUtil.invokeLater(() -> mutator.update(source, rows, columns, value));
    }

    private <T> int[] valid(ViewIndexSet<T> set) {
        return set.asList().stream().filter(idx -> idx.isValid(this)).mapToInt(Index::asInteger).toArray();
    }

    private Runnable newMoveToNextCellRunnable(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> col) {
        return () -> IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTable)).doWhenFocusSettlesDown(() -> this.moveToNextCell(row, col));
    }

    private void moveToNextCell(@NotNull ViewIndex<DataConsumer.Row> rowIndex, @NotNull ViewIndex<DataConsumer.Column> colIndex) {
        if (rowIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndex", "com/intellij/database/run/ui/TableResultPanel", "moveToNextCell"));
        }
        if (colIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colIndex", "com/intellij/database/run/ui/TableResultPanel", "moveToNextCell"));
        }
        if (this.getSelectedRowCount() != 1 || this.getSelectedColumnCount() != 1 || !ApplicationManager.getApplication().isUnitTestMode() && (!UIUtil.isFocusAncestor((JComponent)((Object)this.myTable)) || this.isEditing())) {
            return;
        }
        if (!Comparing.equal(this.getSelectedRow(), rowIndex.toModel(this)) || !Comparing.equal(this.getSelectedColumn(), colIndex.toModel(this))) {
            return;
        }
        if (this.isInsertedRow(rowIndex.toModel(this))) {
            ViewIndex<DataConsumer.Column> nextColumn = ViewIndex.forColumn(this, colIndex.asInteger() + 1);
            colIndex = nextColumn.isValid(this) ? nextColumn : colIndex;
        } else {
            ViewIndex<DataConsumer.Row> nextRow = ViewIndex.forRow(this, rowIndex.asInteger() + 1);
            rowIndex = nextRow.isValid(this) ? nextRow : rowIndex;
        }
        this.scrollToLocally(rowIndex, colIndex);
    }

    protected boolean isHeaderSelecting() {
        return false;
    }

    protected boolean allowHeaderActionsInTransposeMode() {
        return false;
    }

    private void updateColumnAttributes() {
        if (!this.isSortViaOrderBy()) {
            return;
        }
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> order : this.getOrderingFromModel()) {
            this.changeSortOrder(order.getColumn(), order.getOrder(), true);
        }
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> getOrderingFromModel() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> list = sortingModel != null ? sortingModel.getOrdering() : ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getOrderingFromModel"));
        }
        return list;
    }

    private void updateSortKeysFromColumnAttributes() {
        RowSorter rowSorter = this.myTable.getRowSorter();
        if (rowSorter != null) {
            rowSorter.setSortKeys(this.isTransposed() || this.isSortViaOrderBy() ? null : this.createSortKeys());
        }
        this.fireContentChanged();
    }

    @Nullable
    private List<RowSorter.SortKey> createSortKeys() {
        if (this.isTransposed()) {
            return ContainerUtil.emptyList();
        }
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        int orderIdx = 0;
        Object[] keys = new RowSorter.SortKey[sortOrderMap.size()];
        for (DataConsumer.Column column : sortOrderMap.values()) {
            RowSorter.SortKey key = new RowSorter.SortKey(column.columnNum, this.getSortOrder(column) < 0 ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            keys[orderIdx++] = key;
        }
        return ContainerUtil.newArrayList((Object[])keys);
    }

    boolean changeSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable RowSortOrder.Type targetSortOrder, boolean silent) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "changeSortOrder"));
        }
        boolean updated = false;
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column != null) {
            updated = this.myColumnAttributes.changeSortOrder(column, targetSortOrder);
        }
        if (!silent && updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
        return updated;
    }

    private boolean updateDataOrderingIfNeeded() {
        return this.isSortViaOrderBy() && this.updateDataOrdering(true);
    }

    private boolean updateDataOrdering(boolean reloadIfUpdated) {
        List newOrdering;
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return false;
        }
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> oldOrdering = this.getOrderingFromModel();
        if (TableResultPanel.isSameOrdering(oldOrdering, newOrdering = this.createOrdering())) {
            return false;
        }
        if (reloadIfUpdated && !this.isSafeToReload()) {
            return false;
        }
        sortingModel.setOrdering(newOrdering);
        if (reloadIfUpdated) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
        return true;
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> createOrdering() {
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        ArrayList ordering = ContainerUtil.newArrayListWithCapacity((int)sortOrderMap.size());
        for (DataConsumer.Column column : sortOrderMap.values()) {
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this, column.columnNum);
            ordering.add(this.getSortOrder(column) < 0 ? RowSortOrder.asc(columnIdx) : RowSortOrder.desc(columnIdx));
        }
        ArrayList arrayList = ordering;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "createOrdering"));
        }
        return arrayList;
    }

    private static boolean isSameOrdering(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering1, @NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering2) {
        if (ordering1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ordering1", "com/intellij/database/run/ui/TableResultPanel", "isSameOrdering"));
        }
        if (ordering2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ordering2", "com/intellij/database/run/ui/TableResultPanel", "isSameOrdering"));
        }
        if (ordering1.size() != ordering2.size()) {
            return false;
        }
        for (int i = 0; i < ordering1.size(); ++i) {
            RowSortOrder<ModelIndex<DataConsumer.Column>> o1 = ordering1.get(i);
            RowSortOrder<ModelIndex<DataConsumer.Column>> o2 = ordering2.get(i);
            if (Comparing.equal((Object)((Object)o1.getOrder()), (Object)((Object)o2.getOrder())) && Comparing.equal(o1.getColumn(), o2.getColumn())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "isColumnEnabled"));
        }
        return column.isValid(this) && this.myColumnAttributes.isEnabled(this.getDataModel().getColumn(column));
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "setColumnEnabled"));
        }
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column == null || this.myColumnAttributes.isEnabled(column) == state) {
            return;
        }
        if (this.isTransposed()) {
            GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
            this.myColumnAttributes.setEnabled(column, state);
            this.storeOrRestoreSelection(columnIdx, state, selection);
            this.runWithIgnoreSelectionChanges(() -> {
                this.myTable.getModel().fireTableDataChanged();
                selection.restore((JTable)((Object)this.myTable));
            });
        } else {
            this.setColumnEnabled(columnIdx.asInteger(), state);
        }
    }

    private void storeOrRestoreSelection(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state, @NotNull GridSelection selection) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/TableResultPanel", "storeOrRestoreSelection"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/database/run/ui/TableResultPanel", "storeOrRestoreSelection"));
        }
        int modelIndex = columnIdx.asInteger();
        if (state && this.myHiddenColumnSelectionHolder.contains(modelIndex)) {
            if (this.isTransposed()) {
                selection.addSelectedRows(modelIndex);
            } else {
                selection.addSelectedColumns(modelIndex);
            }
            this.myHiddenColumnSelectionHolder.columnShown(modelIndex);
        } else if (!state) {
            boolean selected;
            int viewIndex = columnIdx.toView(this).asInteger();
            boolean bl = selected = this.isTransposed() ? this.myTable.isRowSelected(viewIndex) : this.myTable.isColumnSelected(viewIndex);
            if (selected) {
                this.myHiddenColumnSelectionHolder.columnHidden(modelIndex);
            }
        }
    }

    @Override
    public void transpose() {
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        GridScrollPosition scrollPosition = GridScrollPosition.store((JTable)((Object)this.myTable));
        this.doTranspose();
        DbUIUtil.invokeLater(() -> {
            selection.transpose().restore((JTable)((Object)this.myTable));
            scrollPosition.transpose().restore((JTable)((Object)this.myTable));
        });
    }

    private void doTranspose() {
        this.myTable.doTranspose();
        this.myColumnLayout.setTransposed(this.isTransposed());
        this.myTable.createDefaultColumnsFromModel();
    }

    @Override
    public boolean isTransposed() {
        return this.myTable != null && this.myTable.isTransposed();
    }

    protected void setColumnEnabled(int columnDataIdx, boolean enable) {
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(this, columnDataIdx);
        if (!this.isTransposed()) {
            DataConsumer.Column column = this.getDataModel().getColumn(modelIndex);
            this.myColumnAttributes.setEnabled(column, enable);
        }
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int viewColumnIdx = this.myTable.convertColumnIndexToView(columnDataIdx);
        if (enable && viewColumnIdx < 0) {
            boolean firstTimeShown = !this.myTable.getColumnCache().hasCachedColumn(columnDataIdx);
            this.myTable.addColumn(this.myTable.getColumnCache().getOrCreateColumn(columnDataIdx));
            int lastColumnIndex = this.myTable.getColumnCount() - 1;
            this.runWithIgnoreSelectionChanges(() -> {
                for (int viewTargetColumnIdx = 0; viewTargetColumnIdx < lastColumnIndex; ++viewTargetColumnIdx) {
                    if (columnModel.getColumn(viewTargetColumnIdx).getModelIndex() <= columnDataIdx) continue;
                    this.myTable.moveColumn(lastColumnIndex, viewTargetColumnIdx);
                    break;
                }
            });
            if (firstTimeShown) {
                this.myColumnLayout.columnsShown(this.isTransposed() ? ModelIndexSet.forColumns(this, columnDataIdx) : ModelIndexSet.forRows(this, columnDataIdx));
            }
            this.storeOrRestoreSelection(modelIndex, true, selection);
        } else if (!enable && viewColumnIdx >= 0) {
            this.myTable.getTableHeader().setDraggedColumn(null);
            this.storeOrRestoreSelection(modelIndex, false, selection);
            this.runWithIgnoreSelectionChanges(() -> columnModel.removeColumn(columnModel.getColumn(viewColumnIdx)));
        } else {
            return;
        }
        this.runWithIgnoreSelectionChanges(() -> selection.restore((JTable)((Object)this.myTable)));
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
        if (!this.isTransposed()) {
            this.updateSortKeysFromColumnAttributes();
        }
    }

    private void runWithIgnoreSelectionChanges(Runnable runnable) {
        try {
            this.myHiddenColumnSelectionHolder.startAdjusting();
            runnable.run();
        }
        finally {
            this.myHiddenColumnSelectionHolder.endAdjusting();
        }
    }

    private boolean isSafeToReload() {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    private boolean isSafeToUpdate(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel", "isSafeToUpdate"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/TableResultPanel", "isSafeToUpdate"));
        }
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || mutator.isUpdateSafe(rows, columns, newValue) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    @NotNull
    public JPanel getFilterPanel() {
        GridFilterPanel gridFilterPanel = this.myFilterPanel;
        if (gridFilterPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getFilterPanel"));
        }
        return gridFilterPanel;
    }

    @Override
    public void resetFilters() {
        this.setFilterText("", -1);
        this.resetOrderingAndVisibility();
    }

    @Override
    public void resetView() {
        if (this.isSortViaOrderBy() && !this.isSafeToReload()) {
            return;
        }
        HiddenColumnsSelectionHolder copy = this.myHiddenColumnSelectionHolder.copy();
        this.myHiddenColumnSelectionHolder.reset();
        GridSelection selection = GridSelection.store((JTable)((Object)this.myTable));
        this.resetOrderingAndVisibility();
        this.resetRowHeights();
        this.myTable.createDefaultColumnsFromModel();
        this.myColumnLayout.doLayout();
        int[] indices = copy.selectedIndices((JTable)((Object)this.myTable));
        if (this.isTransposed()) {
            selection.addSelectedRows(indices);
        } else {
            selection.addSelectedColumns(indices);
        }
        selection.restore((JTable)((Object)this.myTable));
        if (this.isSortViaOrderBy()) {
            this.myDataHookUp.getLoader().reloadCurrentPage(GridRequestSource.create(this, null));
        }
    }

    private void resetOrderingAndVisibility() {
        this.myColumnAttributes.resetOrdering();
        this.myColumnAttributes.resetVisibility();
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
        this.myTable.getModel().fireTableDataChanged();
    }

    private void resetRowHeights() {
        int defaultRowHeight = this.myTable.getRowHeight();
        for (int i = 0; i < this.myTable.getRowCount(); ++i) {
            if (this.myTable.getRowHeight(i) == defaultRowHeight) continue;
            this.myTable.setRowHeight(i, defaultRowHeight);
        }
    }

    @NotNull
    String getColumnTooltipHtml(@Nullable DataConsumer.Column column) {
        if (column == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getColumnTooltipHtml"));
            }
            return "";
        }
        String type = DataGridUtil.getSqlType(this, column);
        String string = "<html><b>" + this.myColumnAttributes.getName(column) + "</b>" + (StringUtil.isNotEmpty((String)type) ? ": " + type : "") + this.getDateFormatSuffix(column) + "</html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getColumnTooltipHtml"));
        }
        return string;
    }

    @NotNull
    private String getDateFormatSuffix(@NotNull DataConsumer.Column column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/TableResultPanel", "getDateFormatSuffix"));
        }
        Formatter dateFormat = this.getDateFormat(column);
        String string = dateFormat != null ? " (" + dateFormat + ") " : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel", "getDateFormatSuffix"));
        }
        return string;
    }

    private class MyRequestSource
    extends ActionCallback {
        final ModelIndexSet<DataConsumer.Row> rows;
        final ModelIndexSet<DataConsumer.Column> cols;
        private int myUpdateCount;
        private boolean myErrorReported;
        final /* synthetic */ TableResultPanel this$0;

        public MyRequestSource(TableResultPanel tableResultPanel) {
            this(tableResultPanel, ModelIndexSet.forRows(tableResultPanel, new int[0]), ModelIndexSet.forColumns(tableResultPanel, new int[0]));
        }

        public MyRequestSource(@NotNull TableResultPanel tableResultPanel, @NotNull ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> col) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            if (col == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            this(tableResultPanel, ModelIndexSet.forRows(tableResultPanel, row.asInteger()), ModelIndexSet.forColumns(tableResultPanel, col.asInteger()));
        }

        public MyRequestSource(@NotNull TableResultPanel tableResultPanel, @NotNull ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> cols) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            if (cols == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols", "com/intellij/database/run/ui/TableResultPanel$MyRequestSource", "<init>"));
            }
            this.this$0 = tableResultPanel;
            this.rows = rows;
            this.cols = cols;
        }

        public void requestComplete(boolean success) {
            if (success) {
                this.setDone();
            } else {
                this.setRejected();
            }
        }

        public void setUpdateCount(int updateCount) {
            assert (this.myUpdateCount == 0 && this.rows.size() != 0);
            this.myUpdateCount = updateCount;
        }

        public int getUpdateCount() {
            return this.myUpdateCount;
        }

        public void setErrorReported() {
            this.myErrorReported = true;
        }

        public boolean isErrorReported() {
            return this.myErrorReported;
        }
    }

    private class MyCornerToolsComponent
    extends JBViewport {
        private final ActionButton myButton;

        MyCornerToolsComponent() {
            EditorHeaderComponent view = new EditorHeaderComponent(){

                public void uiSettingsChanged(UISettings uiSettings) {
                }
            };
            view.setOpaque(false);
            this.add((Component)view);
            DumbAwareAction action = new DumbAwareAction(){

                public void actionPerformed(AnActionEvent e) {
                    MyCornerToolsComponent.this.selectAll();
                    if (!TableResultPanel.this.myTable.hasFocus()) {
                        IdeFocusManager.getInstance((Project)TableResultPanel.this.myProject).requestFocus((Component)((Object)TableResultPanel.this.myTable), true);
                    }
                }
            };
            action.getTemplatePresentation().setText("Select All");
            this.myButton = new ActionButton((AnAction)action, action.getTemplatePresentation(), "", (Dimension)JBUI.emptySize());
            view.add((Component)this.myButton, (Object)"Center");
            view.setBorder((Border)new CustomLineBorder(null, 0, 0, 1, 1){

                protected Color getColor() {
                    return TableResultPanel.this.myTable.getGridColor();
                }
            });
        }

        public Color getBackground() {
            return DbUIUtil.softHighlightOf(TableResultPanel.this.myTable.getBackground());
        }

        void selectAll() {
            boolean deselect;
            ListSelectionModel rowModel = TableResultPanel.this.myTable.getSelectionModel();
            int r0 = rowModel.getMinSelectionIndex();
            int r1 = rowModel.getMaxSelectionIndex();
            ListSelectionModel columnModel = TableResultPanel.this.myTable.getColumnModel().getSelectionModel();
            int c0 = columnModel.getMinSelectionIndex();
            int c1 = columnModel.getMaxSelectionIndex();
            boolean bl = deselect = r1 - r0 + 1 == TableResultPanel.this.myTable.getRowCount() && c1 - c0 + 1 == TableResultPanel.this.myTable.getColumnCount();
            if (deselect) {
                TableResultPanel.this.myTable.clearSelection();
            } else {
                TableResultPanel.this.myAutoscrollLocker.runWithLock(() -> {
                    GridSelection.setRowSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), 0, TableResultPanel.this.myTable.getRowCount());
                    GridSelection.setColumnSelectionInterval((JTable)((Object)TableResultPanel.this.myTable), 0, TableResultPanel.this.myTable.getColumnCount());
                });
            }
            TableResultPanel.this.myHiddenColumnSelectionHolder.setWholeRowSelected(!deselect);
        }
    }

    private class MySearchRowFilter
    extends RowFilter<TableModel, Integer> {
        private MySearchRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            if (TableResultPanel.this.mySearchSession == null || !TableResultPanel.this.mySearchSession.isFilteringEnabled() || StringUtil.isEmpty((String)TableResultPanel.this.mySearchSession.getFindModel().getStringToFind())) {
                return true;
            }
            ModelIndex<DataConsumer.Row> row = ModelIndex.forRow(TableResultPanel.this, (int)entry.getIdentifier());
            return !TableResultPanel.this.getVisibleColumns().asIterable().filter(column -> TableResultPanel.this.mySearchSession.isMatchedCell(row, column)).isEmpty();
        }
    }

    private class MyTransposedViewColumnFilter
    extends RowFilter<TableModel, Integer> {
        private MyTransposedViewColumnFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(TableResultPanel.this, (int)entry.getIdentifier());
            return column.isValid(TableResultPanel.this) && TableResultPanel.this.myColumnAttributes.isEnabled(TableResultPanel.this.getDataModel().getColumn(column));
        }
    }

    static class ColumnAttributes {
        private final Map<DataConsumer.Column, Attributes> myAttributesMap = ContainerUtil.newHashMap();
        private List<String> myUnambiguousColumnNames;

        ColumnAttributes() {
        }

        @NotNull
        public String getName(DataConsumer.Column column) {
            String name = column.columnNum < this.myUnambiguousColumnNames.size() ? this.myUnambiguousColumnNames.get(column.columnNum) : column.name;
            String string = StringUtil.isNotEmpty((String)name) ? name : "<anonymous>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes", "getName"));
            }
            return string;
        }

        @NotNull
        public Language getContentLanguage(DataConsumer.Column column) {
            Language language = this.myAttributesMap.get((Object)column).myContentLanguage;
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes", "getContentLanguage"));
            }
            return language;
        }

        public void setContentLanguage(DataConsumer.Column column, @NotNull Language language) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes", "setContentLanguage"));
            }
            this.myAttributesMap.get((Object)column).myContentLanguage = language;
        }

        public Comparator<DataConsumer.Row> getComparator(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).myComparator;
        }

        public boolean isEnabled(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).myEnabled;
        }

        public void setEnabled(DataConsumer.Column column, boolean enabled) {
            this.myAttributesMap.get((Object)column).myEnabled = enabled;
        }

        public int getSortOrder(DataConsumer.Column column) {
            return this.myAttributesMap.get((Object)column).mySortOrder;
        }

        public void resetOrdering() {
            for (Attributes attr : this.myAttributesMap.values()) {
                attr.mySortOrder = 0;
            }
        }

        public void resetVisibility() {
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                this.setEnabled(column, !DbImplUtil.isComputedColumn(column));
            }
        }

        public boolean changeSortOrder(DataConsumer.Column targetColumn, @Nullable RowSortOrder.Type targetSortOrder) {
            if (this.getComparator(targetColumn) == null) {
                return false;
            }
            int prevOrder = this.getSortOrder(targetColumn);
            int maxOrder = 0;
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                if (column == targetColumn) continue;
                int order = this.getSortOrder(column);
                if (prevOrder != 0 && Math.abs(order) > Math.abs(prevOrder)) {
                    order = order > 0 ? order - 1 : order + 1;
                    this.setSortOrder(column, order);
                }
                maxOrder = Math.max(maxOrder, Math.abs(order));
            }
            int asc = -maxOrder - 1;
            int desc = maxOrder + 1;
            int newOrder = targetSortOrder == RowSortOrder.Type.ASC ? asc : (targetSortOrder == RowSortOrder.Type.DESC ? desc : (targetSortOrder == null ? (prevOrder == 0 ? asc : (prevOrder < 0 ? desc : 0)) : 0));
            this.setSortOrder(targetColumn, newOrder);
            return prevOrder != newOrder;
        }

        public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
            TreeMap<Integer, DataConsumer.Column> sortOrderMap = new TreeMap<Integer, DataConsumer.Column>();
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                int sortOrder = this.getSortOrder(column);
                if (sortOrder == 0) continue;
                sortOrderMap.put(Math.abs(sortOrder), column);
            }
            return sortOrderMap;
        }

        private void updateColumnNames(TableResultPanel resultPanel) {
            DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
            SqlTableType type = hookup != null ? hookup.getTableType() : null;
            this.myUnambiguousColumnNames = type == null ? ContainerUtil.emptyList() : DbSqlUtil.getUnambiguousColumnNames(resultPanel.getProject(), hookup.getDatabaseDialect(), type);
        }

        public void newColumns(TableResultPanel resultPanel, Collection<DataConsumer.Column> columnsToRetain) {
            this.updateColumnNames(resultPanel);
            this.myAttributesMap.keySet().retainAll(columnsToRetain);
            for (DataConsumer.Column column : columnsToRetain) {
                if (this.myAttributesMap.containsKey(column)) continue;
                this.myAttributesMap.put(column, ColumnAttributes.createAttributes(resultPanel, column));
            }
            this.updateSortOrders();
        }

        private void setSortOrder(DataConsumer.Column column, int sortOrder) {
            this.myAttributesMap.get((Object)column).mySortOrder = sortOrder;
        }

        private void updateSortOrders() {
            int order = 1;
            for (DataConsumer.Column column : this.getSortOrderMap().values()) {
                this.setSortOrder(column, (this.getSortOrder(column) < 0 ? -1 : 1) * order++);
            }
        }

        private static Attributes createAttributes(TableResultPanel resultPanel, DataConsumer.Column column) {
            Attributes attributes = new Attributes();
            attributes.myComparator = GridRowComparator.create(resultPanel, column);
            attributes.myEnabled = !resultPanel.isInitiallyDisabled(column);
            attributes.myContentLanguage = resultPanel.getInitialContentLanguage(column);
            return attributes;
        }

        static final class Attributes {
            public Language myContentLanguage;
            public Comparator<DataConsumer.Row> myComparator;
            public boolean myEnabled;
            public int mySortOrder;

            Attributes() {
            }
        }
    }
}

