/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Comparing;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridRowComparator
implements Comparator<DataConsumer.Row> {
    private final DataGrid myGrid;
    private final DataConsumer.Column myColumn;

    private GridRowComparator(@NotNull DataGrid grid, @NotNull DataConsumer.Column column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridRowComparator", "<init>"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/GridRowComparator", "<init>"));
        }
        this.myGrid = grid;
        this.myColumn = column;
    }

    @Override
    public int compare(DataConsumer.Row row1, DataConsumer.Row row2) {
        return this.myGrid.isTransposed() ? 0 : GridRowComparator.compareValues(this.myColumn.getValue(row1), this.myColumn.getValue(row2));
    }

    @Nullable
    public static GridRowComparator create(@NotNull DataGrid grid, @NotNull DataConsumer.Column column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridRowComparator", "create"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/GridRowComparator", "create"));
        }
        return DbImplUtil.isComputedColumn(column) ? null : new GridRowComparator(grid, column);
    }

    private static int compareValues(Object v1, Object v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (DataGridUtil.isFailedToLoad(v1)) {
            return DataGridUtil.isFailedToLoad(v2) ? Comparing.compare((Comparable)((Object)((String)v1)), (Comparable)((Object)((String)v2))) : -1;
        }
        if (DataGridUtil.isFailedToLoad(v2)) {
            return 1;
        }
        if (v1 instanceof Comparable && v2 instanceof Comparable && v1.getClass() == v2.getClass()) {
            return ((Comparable)v1).compareTo(v2);
        }
        if (v1 instanceof String && v2 instanceof LobInfo.ClobInfo) {
            return -((LobInfo.ClobInfo)v2).compareTo((String)v1);
        }
        if (v2 instanceof String && v1 instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)v1).compareTo((String)v2);
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            int result1 = Double.compare(((Number)v1).doubleValue(), ((Number)v2).doubleValue());
            long result2 = ((Number)v1).longValue() - ((Number)v2).longValue();
            if (result1 < 0 && result2 < 0L) {
                return -1;
            }
            if (result1 > 0 && result2 > 0L) {
                return 1;
            }
            return 0;
        }
        if (v1 instanceof byte[] && v2 instanceof LobInfo.BlobInfo) {
            return -((LobInfo.BlobInfo)v2).compareTo((byte[])v1);
        }
        if (v2 instanceof byte[] && v1 instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)v1).compareTo((byte[])v2);
        }
        if (v1 instanceof Object[] && v2 instanceof Object[]) {
            Object[] array1 = (Object[])v1;
            Object[] array2 = (Object[])v2;
            int maxLength = Math.max(array1.length, array2.length);
            for (int i = 0; i < maxLength; ++i) {
                int comparisonResult = GridRowComparator.compareValues(i < array1.length ? array1[i] : null, i < array2.length ? array2[i] : null);
                if (comparisonResult == 0) continue;
                return comparisonResult;
            }
            return 0;
        }
        DataGridUtil.LOG.warn(v1.getClass() + " can't be compared with " + v2.getClass());
        return 0;
    }
}

