/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.grid.editors.FakeRangeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import org.jetbrains.annotations.NotNull;

public enum RangeFormatResolver {
    INT4("int4range", PostgresDialect.INSTANCE){

        @Override
        @NotNull
        FakeRangeFormatter getFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$1", "getFormatter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$1", "getFormatter"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$1", "getFormatter"));
            }
            FakeRangeFormatter fakeRangeFormatter = this.wrap(formatter.getNumberFormat());
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$1", "getFormatter"));
            }
            return fakeRangeFormatter;
        }
    }
    ,
    INT8("int8range", PostgresDialect.INSTANCE){

        @Override
        @NotNull
        FakeRangeFormatter getFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$2", "getFormatter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$2", "getFormatter"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$2", "getFormatter"));
            }
            FakeRangeFormatter fakeRangeFormatter = this.wrap(formatter.getNumberFormat());
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$2", "getFormatter"));
            }
            return fakeRangeFormatter;
        }
    }
    ,
    NUMERIC("numrange", PostgresDialect.INSTANCE){

        @Override
        @NotNull
        FakeRangeFormatter getFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$3", "getFormatter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$3", "getFormatter"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$3", "getFormatter"));
            }
            FakeRangeFormatter fakeRangeFormatter = this.wrap(formatter.getNumberFormat());
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$3", "getFormatter"));
            }
            return fakeRangeFormatter;
        }
    }
    ,
    TIMESTAMP("tsrange", PostgresDialect.INSTANCE){

        @Override
        @NotNull
        FakeRangeFormatter getFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$4", "getFormatter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$4", "getFormatter"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$4", "getFormatter"));
            }
            FakeRangeFormatter fakeRangeFormatter = this.wrap(formatter.getTimestampFormat(column, dialect));
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$4", "getFormatter"));
            }
            return fakeRangeFormatter;
        }
    }
    ,
    TIMESTAMP_TZ("tstzrange", PostgresDialect.INSTANCE){

        @Override
        @NotNull
        FakeRangeFormatter getFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$5", "getFormatter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$5", "getFormatter"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$5", "getFormatter"));
            }
            FakeRangeFormatter fakeRangeFormatter = this.wrap(formatter.getZonedPostgresTimestampFormat(column));
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$5", "getFormatter"));
            }
            return fakeRangeFormatter;
        }
    }
    ,
    DATE("daterange", PostgresDialect.INSTANCE){

        @Override
        @NotNull
        FakeRangeFormatter getFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$6", "getFormatter"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$6", "getFormatter"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$6", "getFormatter"));
            }
            FakeRangeFormatter fakeRangeFormatter = this.wrap(formatter.getDateFormat(column, dialect));
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver$6", "getFormatter"));
            }
            return fakeRangeFormatter;
        }
    };

    private final String myColumnName;
    private final DatabaseDialect myDialect;

    private RangeFormatResolver(String columnName, DatabaseDialect dialect) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "<init>"));
        }
        this.myColumnName = columnName;
        this.myDialect = dialect;
    }

    @NotNull
    FakeRangeFormatter wrap(@NotNull Formatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "wrap"));
        }
        FakeRangeFormatter fakeRangeFormatter = new FakeRangeFormatter(formatter);
        if (fakeRangeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "wrap"));
        }
        return fakeRangeFormatter;
    }

    private boolean isSuitable(@NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "isSuitable"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "isSuitable"));
        }
        return this.myDialect == dialect && this.myColumnName.equals(column.typeName);
    }

    @NotNull
    abstract FakeRangeFormatter getFormatter(@NotNull ObjectFormatter var1, @NotNull DataConsumer.Column var2, @NotNull DatabaseDialect var3);

    @NotNull
    public static FakeRangeFormatter resolveFormatter(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialect dialect) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "resolveFormatter"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "resolveFormatter"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "resolveFormatter"));
        }
        for (RangeFormatResolver resolver : RangeFormatResolver.values()) {
            if (!resolver.isSuitable(column, dialect)) continue;
            FakeRangeFormatter fakeRangeFormatter = resolver.getFormatter(formatter, column, dialect);
            if (fakeRangeFormatter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/RangeFormatResolver", "resolveFormatter"));
            }
            return fakeRangeFormatter;
        }
        throw new IllegalArgumentException("No resolver for column: " + column);
    }
}

