/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.run.ui.grid.renderers.DefaultBooleanRendererFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridColumnTypeInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class GridCellRendererFactories {
    private static final GridCellRendererFactories INSTANCE = new GridCellRendererFactories();
    private final List<GridCellRendererFactory> myDefaultFactories = ContainerUtil.list((Object[])new GridCellRendererFactory[]{new DefaultBooleanRendererFactory(), new DefaultTextRendererFactory()});

    GridCellRendererFactories() {
    }

    public static GridCellRendererFactories getInstance() {
        return INSTANCE;
    }

    public ImmutableList<GridCellRendererFactory> getFactoriesFor(@NotNull DatabaseDialect dialect, @NotNull GridColumnTypeInfo columnType) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories", "getFactoriesFor"));
        }
        if (columnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnType", "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories", "getFactoriesFor"));
        }
        return ContainerUtil.immutableList((List)ContainerUtil.filter(this.myDefaultFactories, factory -> {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories", "lambda$getFactoriesFor$0"));
            }
            if (columnType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnType", "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories", "lambda$getFactoriesFor$0"));
            }
            return factory.supportsDialect(dialect) && factory.supportsColumn(columnType);
        }));
    }
}

