/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.ImplicitDepProvider;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlGraphBuilder {
    private final MultiMap<DdlOperationKey, DdlOperationKey> myOperations;
    private final Map<DdlOperationKey, UserDataHolder> myData;
    private final Map<DdlOperationKey, DdlOperationKey> myImplementations;
    private final MultiMap<DdlOperationKey, DdlOperationKey> myDependencies;
    private final MultiMap<DdlOperationKey, DdlOperationKey> myImplicitDependencies;
    private final MultiMap<DeObject, DdlOperationKey> myAnyOperations;
    private final MultiMap<DdlOperation, DdlOperation> myOpImpls;
    private final DatabaseDialectEx myDialect;
    private DdlGraph myWholeGraph;
    private List<DdlGraph> myGraphComponents;
    private boolean myImplicitDepsValid;

    public DdlGraphBuilder(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "<init>"));
        }
        this.myOperations = MultiMap.createLinkedSet();
        this.myData = ContainerUtil.newHashMap();
        this.myImplementations = ContainerUtil.newLinkedHashMap();
        this.myDependencies = MultiMap.createLinkedSet();
        this.myImplicitDependencies = MultiMap.createLinkedSet();
        this.myAnyOperations = MultiMap.createLinkedSet();
        this.myOpImpls = MultiMap.createSet();
        this.myDialect = dialect;
    }

    public void invalidate() {
        this.myImplicitDepsValid = false;
        this.myWholeGraph = null;
        this.myGraphComponents = null;
    }

    private void ensureImplicitDepsValid() {
        if (!this.myImplicitDepsValid) {
            this.updateImplicitDependencies();
        }
    }

    @NotNull
    public JBIterable<DdlOperationKey> getOperations() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.myOperations.keySet());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getOperations"));
        }
        return jBIterable;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public Collection<DdlOperationKey> getNodes(@NotNull DdlOperationKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getNodes"));
        }
        Collection<DdlOperationKey> collection = this.getRealOperations(Collections.singleton(key));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getNodes"));
        }
        return collection;
    }

    @NotNull
    private static Collection<DdlOperationKey> asCollection(@NotNull Iterable<DdlOperationKey> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "asCollection"));
        }
        Collection collection = iterable instanceof Collection ? (Collection)iterable : ContainerUtil.newArrayList(iterable);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "asCollection"));
        }
        return collection;
    }

    @NotNull
    public DdlGraphBuilder addOperation(@NotNull DdlOperationKey op, @Nullable UserDataHolder data, @NotNull Iterable<DdlOperationKey> implemented) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addOperation"));
        }
        if (implemented == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implemented", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addOperation"));
        }
        if (this.myOperations.containsKey((Object)op)) {
            DdlGraphBuilder ddlGraphBuilder = this;
            if (ddlGraphBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addOperation"));
            }
            return ddlGraphBuilder;
        }
        this.invalidate();
        assert (op.operation != DdlOperation.ANY_OP);
        assert (!this.myImplementations.containsKey(op));
        if (data != null) {
            this.myData.put(op, data);
        }
        this.myOperations.putValues((Object)op, Collections.emptyList());
        this.myAnyOperations.putValue((Object)op.target, (Object)op);
        this.myOpImpls.putValue((Object)op.operation, (Object)op.operation);
        for (DdlOperation iface : op.operation.getInterfaces()) {
            this.myOpImpls.putValue((Object)iface, (Object)op.operation);
        }
        for (DdlOperationKey iface : implemented) {
            this.addImplementation(iface, op);
        }
        this.addImplementation(op, op);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addOperation"));
        }
        return ddlGraphBuilder;
    }

    public boolean isScheduled(@NotNull DdlOperationKey op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "isScheduled"));
        }
        return this.myOperations.containsKey((Object)op) || this.myImplementations.containsKey(op) || !JBIterable.of((Object[])op.operation.getInterfaces()).filter(o -> {
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "lambda$isScheduled$0"));
            }
            return this.myImplementations.containsKey(new DdlOperationKey(op.target, (DdlOperation)o));
        }).isEmpty();
    }

    @NotNull
    public DdlGraphBuilder removeOperation(@NotNull DdlOperationKey op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeOperation"));
        }
        this.invalidate();
        this.myData.remove(op);
        Collection removed = this.myOperations.remove((Object)op);
        if (removed != null) {
            for (DdlOperationKey key : removed) {
                this.myImplementations.remove(key);
            }
        }
        this.myAnyOperations.remove((Object)op.target, (Object)op);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeOperation"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder updateImplicitDependencies() {
        this.invalidate();
        this.myImplicitDependencies.clear();
        ImplicitDepProvider.addAllImplicitDeps(this, this.myImplicitDependencies);
        this.myImplicitDepsValid = true;
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "updateImplicitDependencies"));
        }
        return ddlGraphBuilder;
    }

    @Nullable
    public UserDataHolder getData(@NotNull DdlOperationKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getData"));
        }
        return this.myData.get(key);
    }

    @Nullable
    public <T> T getData(@NotNull DdlOperationKey op, @NotNull Key<T> key) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getData"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getData"));
        }
        return (T)key.get(this.myData.get(op));
    }

    @NotNull
    public UserDataHolder newData(@Nullable UserDataHolder toClone) {
        DdlOperationData ddlOperationData = new DdlOperationData((DdlOperationData)ObjectUtils.tryCast((Object)toClone, DdlOperationData.class));
        if (ddlOperationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "newData"));
        }
        return ddlOperationData;
    }

    public <T> void putData(@NotNull DdlOperationKey op, @NotNull Key<T> key, @Nullable T data) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "putData"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "putData"));
        }
        this.invalidate();
        UserDataHolder holder = this.myData.get(op);
        if (holder == null && data != null) {
            holder = this.newData(null);
            this.myData.put(op, holder);
        }
        key.set(holder, data);
    }

    @NotNull
    public DdlGraphBuilder addDependencies(@NotNull DdlOperationKey op, @NotNull Iterable<DdlOperationKey> deps) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependencies"));
        }
        if (deps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deps", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependencies"));
        }
        this.invalidate();
        this.myDependencies.putValues((Object)op, DdlGraphBuilder.asCollection(deps));
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependencies"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder addDependencies(@NotNull Iterable<DdlOperationKey> ops, @NotNull DdlOperationKey dep) {
        if (ops == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependencies"));
        }
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependencies"));
        }
        this.invalidate();
        for (DdlOperationKey op : ops) {
            this.addDependency(op, dep);
        }
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependencies"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder addDependency(@NotNull DdlOperationKey op, @NotNull DdlOperationKey dep) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependency"));
        }
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependency"));
        }
        this.invalidate();
        this.myDependencies.putValue((Object)op, (Object)dep);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addDependency"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder removeDependencies(@NotNull DdlOperationKey op, @NotNull Iterable<DdlOperationKey> deps) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependencies"));
        }
        if (deps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deps", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependencies"));
        }
        this.invalidate();
        for (DdlOperationKey dep : deps) {
            this.removeDependency(op, dep);
        }
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependencies"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder removeDependencies(@NotNull Iterable<DdlOperationKey> ops, @NotNull DdlOperationKey dep) {
        if (ops == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependencies"));
        }
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependencies"));
        }
        this.invalidate();
        for (DdlOperationKey op : ops) {
            this.removeDependency(op, dep);
        }
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependencies"));
        }
        return ddlGraphBuilder;
    }

    @NotNull
    public DdlGraphBuilder removeDependency(@NotNull DdlOperationKey op, @NotNull DdlOperationKey dep) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependency"));
        }
        if (dep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dep", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependency"));
        }
        this.invalidate();
        this.myDependencies.remove((Object)op, (Object)dep);
        DdlGraphBuilder ddlGraphBuilder = this;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "removeDependency"));
        }
        return ddlGraphBuilder;
    }

    private void addImplementation(@NotNull DdlOperationKey iface, @NotNull DdlOperationKey impl) {
        if (iface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iface", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addImplementation"));
        }
        if (impl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "impl", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "addImplementation"));
        }
        DdlOperationKey old = this.myImplementations.put(iface, impl);
        this.myOperations.putValue((Object)impl, (Object)iface);
        assert (old == null || old.equals(impl));
    }

    private void appendImplementations(@NotNull Set<DdlOperationKey> res, @NotNull DdlOperationKey key) {
        if (res == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "appendImplementations"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "appendImplementations"));
        }
        List<DdlOperation> impls = this.myOpImpls.get((Object)key.operation);
        if (impls.isEmpty()) {
            impls = Collections.singletonList(key.operation);
        }
        for (DdlOperation implOp : impls) {
            DdlOperationKey op = this.myImplementations.get(new DdlOperationKey(key.target, implOp));
            if (op == null) continue;
            res.add(op);
        }
    }

    @NotNull
    private Iterable<DdlOperationKey> getInterfaces(@NotNull DdlOperationKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getInterfaces"));
        }
        assert (this.myOperations.containsKey((Object)key));
        Collection collection = this.myOperations.get((Object)key);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getInterfaces"));
        }
        return collection;
    }

    @NotNull
    public DdlGraph build() {
        if (this.myWholeGraph == null) {
            this.myWholeGraph = this.buildFromNodes(this.myOperations.keySet(), ThreeState.UNSURE);
        }
        DdlGraph ddlGraph = this.myWholeGraph;
        if (ddlGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "build"));
        }
        return ddlGraph;
    }

    @NotNull
    public List<DdlGraph> buildComponents() {
        if (this.myGraphComponents == null) {
            ArrayList result = ContainerUtil.newArrayList();
            HashSet visited = ContainerUtil.newHashSet();
            DdlGraph graph = this.build();
            for (DdlOperationKey root : graph.getSources().append((Iterable)this.myOperations.keySet())) {
                if (visited.contains(root)) continue;
                DdlGraph comp = this.createFromConnectedComponent(graph, root);
                visited.addAll(comp.getNodes());
                result.add(comp);
            }
            this.myGraphComponents = result;
        }
        List<DdlGraph> list = this.myGraphComponents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "buildComponents"));
        }
        return list;
    }

    @NotNull
    private DdlGraph createFromConnectedComponent(@NotNull DdlGraph graph, @NotNull DdlOperationKey start) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "createFromConnectedComponent"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "createFromConnectedComponent"));
        }
        final Ref hasCycle = Ref.create((Object)ThreeState.NO);
        final LinkedHashSet currentComponent = ContainerUtil.newLinkedHashSet();
        DdlGraph.visitDfs(graph, start, new DdlGraph.DfsVisitor<DdlOperationKey>(){

            @Override
            public boolean visit(@NotNull DdlOperationKey key, @NotNull DdlGraph.DfsVisitor.Reason reason) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$1", "visit"));
                }
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$1", "visit"));
                }
                if (reason == DdlGraph.DfsVisitor.Reason.ENTER) {
                    currentComponent.add(key);
                }
                if (reason == DdlGraph.DfsVisitor.Reason.CYCLE) {
                    hasCycle.set((Object)ThreeState.YES);
                }
                return true;
            }
        });
        DdlGraph ddlGraph = this.buildFromNodes(currentComponent, (ThreeState)hasCycle.get());
        if (ddlGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "createFromConnectedComponent"));
        }
        return ddlGraph;
    }

    private boolean opIsImpl(@NotNull DdlOperation op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "opIsImpl"));
        }
        return this.myOpImpls.get((Object)op).contains(op);
    }

    @NotNull
    private Iterable<DdlOperationKey> getDependencies(@NotNull DdlOperationKey op) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getDependencies"));
        }
        assert (this.opIsImpl(op.operation));
        LinkedHashSet deps = ContainerUtil.newLinkedHashSet();
        for (DdlOperationKey key : this.getInterfaces(op)) {
            this.appendDependencies(deps, key);
            for (DdlOperation iface : key.operation.getInterfaces()) {
                this.appendDependencies(deps, new DdlOperationKey(key.target, iface));
            }
        }
        LinkedHashSet linkedHashSet = deps;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getDependencies"));
        }
        return linkedHashSet;
    }

    private void appendDependencies(@NotNull Set<DdlOperationKey> deps, @NotNull DdlOperationKey op) {
        if (deps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deps", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "appendDependencies"));
        }
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "appendDependencies"));
        }
        deps.addAll(this.myDependencies.get((Object)op));
        deps.addAll(this.myImplicitDependencies.get((Object)op));
    }

    @NotNull
    private Collection<DdlOperationKey> getRealOperations(@NotNull Iterable<DdlOperationKey> iter) {
        if (iter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iter", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getRealOperations"));
        }
        LinkedHashSet ops = ContainerUtil.newLinkedHashSet();
        for (DdlOperationKey op : iter) {
            if (op.operation == DdlOperation.ANY_OP) {
                ops.addAll(this.myAnyOperations.get((Object)op.target));
                continue;
            }
            this.appendImplementations(ops, op);
        }
        LinkedHashSet linkedHashSet = ops;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "getRealOperations"));
        }
        return linkedHashSet;
    }

    private static <K, V> BidirectionalMultiMap<K, V> newLinkedBiMap() {
        return new BidirectionalMultiMap<K, V>(ContainerUtil.newLinkedHashMap(), ContainerUtil.newLinkedHashMap()){

            @NotNull
            protected Set<V> createValuesSet() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$2", "createValuesSet"));
                }
                return linkedHashSet;
            }

            @NotNull
            protected Set<K> createKeysSet() {
                LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
                if (linkedHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$2", "createKeysSet"));
                }
                return linkedHashSet;
            }
        };
    }

    @NotNull
    public DdlGraph buildFromNodes(@NotNull Collection<DdlOperationKey> ops, @NotNull ThreeState hasCycles) {
        if (ops == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ops", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "buildFromNodes"));
        }
        if (hasCycles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasCycles", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "buildFromNodes"));
        }
        this.ensureImplicitDepsValid();
        BidirectionalMultiMap edges = DdlGraphBuilder.newLinkedBiMap();
        HashMap data = ContainerUtil.newHashMap();
        for (DdlOperationKey op : ops) {
            data.put(op, this.myData.get(op));
            for (DdlOperationKey dep : this.getRealOperations(this.getDependencies(op))) {
                assert (ops.contains(dep));
                edges.put((Object)op, (Object)dep);
            }
        }
        DdlGraph ddlGraph = new DdlGraph(ops, data, edges, hasCycles);
        if (ddlGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder", "buildFromNodes"));
        }
        return ddlGraph;
    }

    private static class DdlOperationData
    implements UserDataHolder,
    Cloneable {
        private final Map<Key, Object> myData = ContainerUtil.newHashMap();

        public DdlOperationData(@Nullable DdlOperationData toClone) {
            if (toClone != null) {
                this.myData.putAll(toClone.myData);
            }
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$DdlOperationData", "getUserData"));
            }
            return (T)key.get(this.myData);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGraphBuilder$DdlOperationData", "putUserData"));
            }
            key.set(this.myData, value);
        }
    }
}

