/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationGenerator;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.operations.CreateDropRoutineOperation;
import com.intellij.database.schemaEditor.operations.TruncateTableOperation;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DasDdlOperations {
    public static final DdlOperation RECOMPILE = new DdlOperation("recompile", new DdlOperation[0]);
    public static final DdlOperation DROP_TABLE = new DdlOperation("drop-table", DdlOperation.DROP);
    public static final DdlOperation CREATE_TABLE = new DdlOperation("create-table", DdlOperation.CREATE);
    public static final DdlOperation DROP_COLUMN = new DdlOperation("drop-column", DdlOperation.DROP);
    public static final DdlOperation CREATE_COLUMN = new DdlOperation("create-column", DdlOperation.CREATE);
    public static final DdlOperation DROP_INDEX = new DdlOperation("drop-index", DdlOperation.DROP);
    public static final DdlOperation CREATE_INDEX = new DdlOperation("create-index", DdlOperation.CREATE);
    public static final DdlOperation DROP_PRIMARY_KEY = new DdlOperation("drop-primary-key", DdlOperation.DROP);
    public static final DdlOperation CREATE_PRIMARY_KEY = new DdlOperation("create-primary-key", DdlOperation.CREATE);
    public static final DdlOperation DROP_ALT_KEY = new DdlOperation("drop-alt-key", DdlOperation.DROP);
    public static final DdlOperation CREATE_ALT_KEY = new DdlOperation("create-alt-key", DdlOperation.CREATE);
    public static final DdlOperation DROP_CONSTRAINT = new DdlOperation("drop-constraint", DdlOperation.DROP);
    public static final DdlOperation CREATE_CONSTRAINT = new DdlOperation("create-constraint", DdlOperation.CREATE);
    public static final DdlOperation DROP_FOREIGN_KEY = new DdlOperation("drop-foreign-key", DdlOperation.DROP);
    public static final DdlOperation CREATE_FOREIGN_KEY = new DdlOperation("create-foreign-key", DdlOperation.CREATE);
    public static final DdlOperation ALTER_COLUMN = new DdlOperation("alter-column", DdlOperation.ALTER);
    public static final DdlOperation ALTER_TABLE_KEY = new DdlOperation("alter-table-key", DdlOperation.ALTER);
    public static final DdlOperation ALTER_CONSTRAINT = new DdlOperation("alter-constraint", DdlOperation.ALTER);
    public static final DdlOperation ALTER_INDEX = new DdlOperation("alter-index", DdlOperation.ALTER);
    public static final DdlOperation ALTER_FOREIGN_KEY = new DdlOperation("alter-foreign-key", DdlOperation.ALTER);
    public static final DdlOperation ALTER_TABLE = new DdlOperation("alter-table", DdlOperation.ALTER);
    public static final DdlOperation RENAME_TABLE = new DdlOperation("rename-table", DdlOperation.RENAME);
    public static final DdlOperation REORDER_COLUMNS = new DdlOperation("reorder-columns", new DdlOperation[0]);
    public static final DdlOperation ALTER_ROUTINE = new DdlOperation("alter-routine", DdlOperation.ALTER);
    public static final DdlOperation RENAME_ROUTINE = new DdlOperation("rename-routine", DdlOperation.RENAME);
    public static final DdlOperation TRUNCATE_TABLE = new DdlOperation("truncate-table", new DdlOperation[0]);
    public static final Condition<DeObject> PRIMARY_KEY_CONDITION = object -> ((DeTableKey)object).isPrimary();
    public static final Condition<DeObject> ALT_KEY_CONDITION = Conditions.not(PRIMARY_KEY_CONDITION);

    @NotNull
    public static <T> UserDataHolder set(@NotNull UserDataHolder data, @NotNull Key<T> key, T value) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "set"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "set"));
        }
        key.set(data, value);
        UserDataHolder userDataHolder = data;
        if (userDataHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "set"));
        }
        return userDataHolder;
    }

    @NotNull
    public static DeObject getAlterFrom(@NotNull DeObject das, @Nullable UserDataHolder data) {
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterFrom"));
        }
        DeObject deObject = (DeObject)ObjectUtils.chooseNotNull((Object)DdlGraph.ALTER_FROM.get(data), (Object)das);
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterFrom"));
        }
        return deObject;
    }

    @NotNull
    public static DeObject getAlterTo(@NotNull DeObject das, @Nullable UserDataHolder data) {
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterTo"));
        }
        DeObject deObject = (DeObject)ObjectUtils.chooseNotNull((Object)DdlGraph.ALTER_TO.get(data), (Object)das);
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterTo"));
        }
        return deObject;
    }

    @NotNull
    public static DeObject getAlterFrom(@NotNull DdlOperationKey key, @NotNull DdlGraphBuilder builder) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterFrom"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterFrom"));
        }
        DeObject deObject = DasDdlOperations.getAlterFrom(key.target, builder.getData(key));
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterFrom"));
        }
        return deObject;
    }

    @NotNull
    public static DeObject getAlterTo(@NotNull DdlOperationKey key, @NotNull DdlGraphBuilder builder) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterTo"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterTo"));
        }
        DeObject deObject = DasDdlOperations.getAlterTo(key.target, builder.getData(key));
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getAlterTo"));
        }
        return deObject;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectCreateKeys(@Nullable DeObject object) {
        JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(object == null ? null : new DdlOperationKey(object, DdlOperation.CREATE));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectCreateKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectDropKeys(@Nullable DeObject object) {
        JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(object == null ? null : new DdlOperationKey(object, DdlOperation.DROP));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectDropKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectPreRenameKeys(@Nullable DeObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectPreRenameKeys"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)new DdlOperationKey(object, DdlOperation.RENAME));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectPreRenameKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectPostRenameKeys(@Nullable DeObject object) {
        if (object == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectPostRenameKeys"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)new DdlOperationKey(object, DdlOperation.POST_RENAME));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectPostRenameKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectRenameNCreateKeys(@Nullable DeObject object) {
        JBIterable jBIterable = DasDdlOperations.getObjectCreateKeys(object).append(DasDdlOperations.getObjectPostRenameKeys(object));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectRenameNCreateKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectRenameNDropKeys(@Nullable DeObject object) {
        JBIterable jBIterable = DasDdlOperations.getObjectDropKeys(object).append(DasDdlOperations.getObjectPreRenameKeys(object));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectRenameNDropKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsRenameNCreateKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsRenameNCreateKeys"));
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectRenameNCreateKeys);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsRenameNCreateKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsCreateKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsCreateKeys"));
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectCreateKeys);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsCreateKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsRenameNDropKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsRenameNDropKeys"));
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectRenameNDropKeys);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsRenameNDropKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<DdlOperationKey> getObjectsDropKeys(@NotNull Iterable<? extends DeObject> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsDropKeys"));
        }
        JBIterable jBIterable = JBIterable.from(objects).flatten(DasDdlOperations::getObjectDropKeys);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations", "getObjectsDropKeys"));
        }
        return jBIterable;
    }

    public static class DefaultDdlOperationsBuilder {
        protected static final Map<Class<? extends DdlOperationGenerator<?>>, DdlOperationGenerator<?>> myOpsCache = new FactoryMap<Class<? extends DdlOperationGenerator<?>>, DdlOperationGenerator<?>>(){

            @Nullable
            protected DdlOperationGenerator<?> create(Class<? extends DdlOperationGenerator<?>> opClass) {
                try {
                    Constructor<DdlOperationGenerator<?>> constructor = opClass.getConstructor(new Class[0]);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)"Operation should have () ctor");
                }
                catch (Exception e) {
                    ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
                    return null;
                }
            }
        };
        protected final Map<DdlOperation, DdlOperationGenerator<?>> myOperations;
        protected final Map<Trinity<DdlOperation, Class<? extends DeObject>, Condition<DeObject>>, DdlOperation> mySelectionOps;

        public DefaultDdlOperationsBuilder(@NotNull DatabaseDialect dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "<init>"));
            }
            this.myOperations = ContainerUtil.newHashMap();
            this.mySelectionOps = ContainerUtil.newHashMap();
            this.addOp(AlterCommentOperation.class);
            this.addOp(TemporaryRenameOperation.class);
            this.addOp(DropTableOperation.class);
            this.addOp(AlterTableOperation.class);
            this.addOp(CreateTableOperation.class);
            this.addOp(RenameTableOperation.class);
            this.addOp(DropColumnOperation.class);
            this.addOp(CreateColumnOperation.class);
            this.addOp(AlterColumnOperation.class);
            this.addOp(DropIndexOperation.class);
            this.addOp(CreateIndexOperation.class);
            this.addOp(DropPrimaryKeyOperation.class);
            this.addOp(CreatePrimaryKeyOperation.class);
            this.addOp(DropAltKeyOperation.class);
            this.addOp(CreateAltKeyOperation.class);
            this.addOp(DropCreateIndexOperation.class);
            this.addOp(DropCreateTableKeyOperation.class);
            this.addOp(DropCreateConstraintOperation.class);
            this.addOp(DropCreateForeignKeyOperation.class);
            this.addOp(DropConstraintOperation.class);
            this.addOp(CreateConstraintOperation.class);
            this.addOp(DropForeignKeyOperation.class);
            this.addOp(CreateForeignKeyOperation.class);
            this.addOp(CreateDropRoutineOperation.class);
            this.addOp(TruncateTableOperation.class);
            this.addOp(ReorderColumnsOperation.class);
            this.addSels(DdlOperation.CREATE).add(DeTable.class, CREATE_TABLE).add(DeColumn.class, CREATE_COLUMN).add(DeIndex.class, CREATE_INDEX).add(DeTableKey.class, CREATE_PRIMARY_KEY, PRIMARY_KEY_CONDITION).add(DeTableKey.class, CREATE_ALT_KEY, ALT_KEY_CONDITION).add(DeConstraint.class, CREATE_CONSTRAINT).add(DeForeignKey.class, CREATE_FOREIGN_KEY);
            this.addSels(DdlOperation.DROP).add(DeTable.class, DROP_TABLE).add(DeColumn.class, DROP_COLUMN).add(DeIndex.class, DROP_INDEX).add(DeTableKey.class, DROP_PRIMARY_KEY, PRIMARY_KEY_CONDITION).add(DeTableKey.class, DROP_ALT_KEY, ALT_KEY_CONDITION).add(DeConstraint.class, DROP_CONSTRAINT).add(DeForeignKey.class, DROP_FOREIGN_KEY);
            this.addSels(DdlOperation.ALTER).add(DeTable.class, ALTER_TABLE).add(DeColumn.class, ALTER_COLUMN).add(DeIndex.class, ALTER_INDEX).add(DeTableKey.class, ALTER_TABLE_KEY).add(DeConstraint.class, ALTER_CONSTRAINT).add(DeForeignKey.class, ALTER_FOREIGN_KEY).add(DeRoutine.class, ALTER_ROUTINE);
        }

        protected DefaultDdlOperationsBuilder addOp(@NotNull Class<? extends DdlOperationGenerator<?>> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "addOp"));
            }
            DdlOperationGenerator<?> op = this.create(clazz);
            this.addOperation(op);
            return this;
        }

        protected void addOperation(@NotNull DdlOperationGenerator<?> op) {
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "addOperation"));
            }
            this.myOperations.remove(op.getOperation());
            this.myOperations.put(op.getOperation(), op);
        }

        protected Proxy addSels(@NotNull DdlOperation sel) {
            if (sel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sel", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "addSels"));
            }
            return new Proxy(sel);
        }

        @NotNull
        protected DdlOperationGenerator<?> create(@NotNull Class<? extends DdlOperationGenerator<?>> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "create"));
            }
            DdlOperationGenerator<?> ddlOperationGenerator = myOpsCache.get(clazz);
            if (ddlOperationGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "create"));
            }
            return ddlOperationGenerator;
        }

        @NotNull
        public DdlOperations build() {
            DdlOperations operations = new DdlOperations();
            for (DdlOperationGenerator<?> operation : this.myOperations.values()) {
                operations.add(operation);
            }
            MultiMap collected = MultiMap.create();
            for (Map.Entry<Trinity<DdlOperation, Class<? extends DeObject>, Condition<DeObject>>, DdlOperation> entry : this.mySelectionOps.entrySet()) {
                collected.putValue(entry.getKey().first, (Object)Pair.create((Object)Conditions.and2((Condition)Conditions.instanceOf((Class)((Class)entry.getKey().second)), (Condition)((Condition)entry.getKey().third)), (Object)entry.getValue()));
            }
            for (Map.Entry<Object, DdlOperation> entry : collected.entrySet()) {
                OperationSelector selector = new OperationSelector((DdlOperation)entry.getKey());
                for (Pair operation : (Collection)((Object)entry.getValue())) {
                    selector.add((Condition<DeObject>)((Condition)operation.first), (DdlOperation)operation.second);
                }
                operations.add(selector);
            }
            DdlOperations ddlOperations = operations;
            if (ddlOperations == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder", "build"));
            }
            return ddlOperations;
        }

        public class Proxy {
            private final DdlOperation mySelector;

            public Proxy(DdlOperation selector) {
                if (selector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy", "<init>"));
                }
                this.mySelector = selector;
            }

            public Proxy add(@NotNull Class<? extends DeObject> clazz, @NotNull DdlOperation value, @NotNull Condition<DeObject> cond) {
                if (clazz == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy", "add"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy", "add"));
                }
                if (cond == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cond", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy", "add"));
                }
                Trinity key = Trinity.create((Object)this.mySelector, clazz, cond);
                DefaultDdlOperationsBuilder.this.mySelectionOps.remove(key);
                DefaultDdlOperationsBuilder.this.mySelectionOps.put((Trinity<DdlOperation, Class<? extends DeObject>, Condition<DeObject>>)key, value);
                return this;
            }

            public Proxy add(@NotNull Class<? extends DeObject> clazz, @NotNull DdlOperation value) {
                if (clazz == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy", "add"));
                }
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DefaultDdlOperationsBuilder$Proxy", "add"));
                }
                return this.add(clazz, value, (Condition<DeObject>)Conditions.alwaysTrue());
            }
        }
    }

    public static class DropCreateForeignKeyOperation
    extends DropCreateOperation<DeForeignKey> {
        public DropCreateForeignKeyOperation() {
            super(ALTER_FOREIGN_KEY, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    public static class DropCreateConstraintOperation
    extends DropCreateOperation<DeConstraint> {
        public DropCreateConstraintOperation() {
            super(ALTER_CONSTRAINT, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    public static class DropCreateTableKeyOperation
    extends DropCreateOperation<DeTableKey> {
        public DropCreateTableKeyOperation() {
            super(ALTER_TABLE_KEY, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    public static class DropCreateIndexOperation
    extends DropCreateOperation<DeIndex> {
        public DropCreateIndexOperation() {
            super(ALTER_INDEX, DdlOperation.DROP, DdlOperation.CREATE);
        }
    }

    static class CreateForeignKeyOperation
    extends DdlOperationGenerator<DeForeignKey> {
        public CreateForeignKeyOperation() {
            super(CREATE_FOREIGN_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeForeignKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddForeignKey(builder, object, true, false).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeForeignKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation", "getDependencies"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.getColumns())).append(DasDdlOperations.getObjectRenameNCreateKeys(object.target)).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.getTargetColumns()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateForeignKeyOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    static class DropForeignKeyOperation
    extends DdlOperationGenerator<DeForeignKey> {
        public DropForeignKeyOperation() {
            super(DROP_FOREIGN_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeForeignKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropForeignKey(builder, object.getTable(), object, object.getName()).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeForeignKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation", "getDependants"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.getColumns())).append(DasDdlOperations.getObjectRenameNDropKeys(object.target)).append(DasDdlOperations.getObjectsRenameNDropKeys(object.getTargetColumns()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropForeignKeyOperation", "getDependants"));
            }
            return jBIterable;
        }
    }

    static class CreateConstraintOperation
    extends DdlOperationGenerator<DeConstraint> {
        public CreateConstraintOperation() {
            super(CREATE_CONSTRAINT);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeConstraint object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddUniqueConstraint(builder, object.getTable(), object, object.getName(), JBIterable.from((Iterable)object.getColumnsRef().resolveObjects()).filter(DasColumn.class).toList()).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeConstraint object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation", "getDependencies"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.columns));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateConstraintOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    static class DropConstraintOperation
    extends DdlOperationGenerator<DeConstraint> {
        public DropConstraintOperation() {
            super(DROP_CONSTRAINT);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeConstraint object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropConstraint(builder, object.getTable(), object, object.getName()).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeConstraint object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation", "getDependants"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.columns));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropConstraintOperation", "getDependants"));
            }
            return jBIterable;
        }
    }

    static class CreateAltKeyOperation
    extends DdlOperationGenerator<DeTableKey> {
        public CreateAltKeyOperation() {
            super(CREATE_ALT_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddUniqueConstraint(builder, object.table, object, object.name, ContainerUtil.newArrayList(object.getColumns())).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation", "getDependencies"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.columns));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateAltKeyOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    static class CreatePrimaryKeyOperation
    extends DdlOperationGenerator<DeTableKey> {
        public CreatePrimaryKeyOperation() {
            super(CREATE_PRIMARY_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddPrimaryKey(builder, object).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "getDependencies"));
            }
            DeTable table = (DeTable)ObjectUtils.tryCast((Object)object.table.editedObject, DeTable.class);
            JBIterable drop_pk_deps = table != null && table.keys.getPrimaryKey() != null ? JBIterable.of((Object)new DdlOperationKey(table.keys.getPrimaryKey(), DROP_PRIMARY_KEY)) : JBIterable.empty();
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append((Iterable)drop_pk_deps).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.columns));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "getDependencies"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTableKey das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "addToBuilder"));
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreatePrimaryKeyOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }
    }

    static class DropPrimaryKeyOperation
    extends DdlOperationGenerator<DeTableKey> {
        public DropPrimaryKeyOperation() {
            super(DROP_PRIMARY_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropPrimaryKey(builder, object).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation", "getDependants"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.columns));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropPrimaryKeyOperation", "getDependants"));
            }
            return jBIterable;
        }
    }

    static class DropAltKeyOperation
    extends DdlOperationGenerator<DeTableKey> {
        public DropAltKeyOperation() {
            super(DROP_ALT_KEY);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTableKey object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropConstraint(builder, object.table, object, object.name).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeTableKey object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation", "getDependants"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.columns));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropAltKeyOperation", "getDependants"));
            }
            return jBIterable;
        }
    }

    static class CreateIndexOperation
    extends DdlOperationGenerator<DeIndex> {
        public CreateIndexOperation() {
            super(CREATE_INDEX);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeIndex object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlCreateIndex(builder, object, "", "", "").newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeIndex object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation", "getDependencies"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table).append(DasDdlOperations.getObjectsRenameNCreateKeys(object.getColumns()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateIndexOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    static class DropIndexOperation
    extends DdlOperationGenerator<DeIndex> {
        public DropIndexOperation() {
            super(DROP_INDEX);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeIndex object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropIndex(builder, object.getTable(), object, object.getName(), false).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeIndex object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation", "getDependants"));
            }
            JBIterable jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table).append(DasDdlOperations.getObjectsRenameNDropKeys(object.getColumns()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropIndexOperation", "getDependants"));
            }
            return jBIterable;
        }
    }

    public static class AlterColumnOperation
    extends DdlOperationGenerator<DeColumn> {
        public AlterColumnOperation() {
            super(ALTER_COLUMN);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeColumn object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "generate"));
            }
            DeColumn target = this.getTarget(data);
            DdlBuilder ddlBuilder = builder.getDialect().sqlAlterColumnDefinition(builder, object, target, false).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeColumn das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "addToBuilder"));
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (!to.isAltered(das)) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "addToBuilder"));
                }
                return ddlGenerator;
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeColumn object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "getImplemented"));
            }
            JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "getImplemented"));
            }
            return jBIterable;
        }

        @NotNull
        public DeColumn getTarget(@Nullable UserDataHolder data) {
            DeColumn deColumn = (DeColumn)ObjectUtils.assertNotNull((Object)ObjectUtils.tryCast((Object)DdlGraph.ALTER_TO.get(data), DeColumn.class));
            if (deColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterColumnOperation", "getTarget"));
            }
            return deColumn;
        }
    }

    public static class CreateColumnOperation
    extends DdlOperationGenerator<DeColumn> {
        public CreateColumnOperation() {
            super(CREATE_COLUMN);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeColumn object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlAddColumn(builder, object, object.getTable().getColumnAttrs((DasColumn)object)).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeColumn object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation", "getDependencies"));
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object.table);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateColumnOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    static class DropColumnOperation
    extends DdlOperationGenerator<DeColumn> {
        public DropColumnOperation() {
            super(DROP_COLUMN);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeColumn object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropColumn(builder, object).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependants(@NotNull DeColumn object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation", "getDependants"));
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNDropKeys(object.table);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropColumnOperation", "getDependants"));
            }
            return jBIterable;
        }
    }

    static class RenameTableOperation
    extends DdlOperationGenerator<DeTable> {
        public RenameTableOperation() {
            super(RENAME_TABLE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "generate"));
            }
            DeObject target = this.getTarget(data);
            String name = target.getName();
            DdlBuilder ddlBuilder = builder.getDialect().sqlRenameTable(builder, object, name).newStatement().renameObject(object, name);
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "getImplemented"));
            }
            JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "getImplemented"));
            }
            return jBIterable;
        }

        @NotNull
        public DeObject getTarget(@Nullable UserDataHolder data) {
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (deObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$RenameTableOperation", "getTarget"));
            }
            return deObject;
        }
    }

    public static class AlterTableOperation
    extends DdlOperationGenerator<DeTable> {
        public AlterTableOperation() {
            super(ALTER_TABLE);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable from, @Nullable UserDataHolder data) {
            boolean rename;
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "addToBuilder"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "addToBuilder"));
            }
            assert (data != null);
            DeTable to = (DeTable)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            boolean bl = rename = !StringUtil.equals((CharSequence)from.getName(), (CharSequence)to.getName());
            if (from.isTemporary() != to.isTemporary()) {
                throw new UnsupportedOperationException("Can not change temporariness of existing table");
            }
            if (rename) {
                generator.addOperation(builder, RENAME_TABLE, from, data);
            }
            LinkedHashSet alter = ContainerUtil.newLinkedHashSet();
            LinkedHashSet drop = ContainerUtil.newLinkedHashSet();
            LinkedHashSet create = ContainerUtil.newLinkedHashSet();
            ArrayList order = ContainerUtil.newArrayList();
            AlterTableOperation.classifyChildren(from, to, create, alter, drop, order);
            for (DeObject object : create) {
                generator.addOperation(builder, DdlOperation.CREATE, object, null);
            }
            for (DeObject object : alter) {
                generator.addOperation(builder, DdlOperation.ALTER, (DeObject)object.editedObject, DasDdlOperations.set(builder.newData(null), DdlGraph.ALTER_TO, object));
            }
            for (DeObject object : drop) {
                generator.addOperation(builder, DdlOperation.DROP, object, null);
            }
            generator.addOperation(builder, REORDER_COLUMNS, to, DasDdlOperations.set(builder.newData(null), ReorderColumnsOperation.FROM_ORDER, order));
            if (!Comparing.equal((String)from.comment, (String)to.comment)) {
                generator.addOperation(builder, DdlOperation.ALTER_COMMENT, from, DasDdlOperations.set(builder.newData(null), DdlGraph.ALTER_TO, to));
            }
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }

        protected static void classifyChildren(@NotNull DeTable from, @NotNull DeTable to, @NotNull Set<DeObject> create, @NotNull Set<DeObject> alter, @NotNull Set<DeObject> drop, @NotNull List<DeColumn> order) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "classifyChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "classifyChildren"));
            }
            if (create == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "create", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "classifyChildren"));
            }
            if (alter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alter", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "classifyChildren"));
            }
            if (drop == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drop", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "classifyChildren"));
            }
            if (order == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterTableOperation", "classifyChildren"));
            }
            HashMap altered = ContainerUtil.newHashMap();
            for (DeObject object : to.getChildren()) {
                DeObject altering = (DeObject)object.editedObject;
                if (altering == null) {
                    create.add(object);
                    continue;
                }
                alter.add(object);
                altered.put(altering, object);
            }
            for (DeObject object : from.getChildren()) {
                if (altered.containsKey(object)) continue;
                drop.add(object);
            }
            for (DeColumn column : from.columns) {
                if (drop.contains(column)) continue;
                order.add((DeColumn)altered.get(column));
            }
            for (DeColumn column : to.columns) {
                if (!create.contains(column)) continue;
                order.add(column);
            }
        }
    }

    public static class ReorderColumnsOperation
    extends DdlOperationGenerator<DeTable> {
        public static final Key<List<DeColumn>> FROM_ORDER = Key.create((String)"FROM_ORDER");
        public static final Key<TIntArrayList> REORDER_INSERTIONS = Key.create((String)"REORDER_INSERTIONS");

        public ReorderColumnsOperation() {
            super(REORDER_COLUMNS);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable to, @Nullable UserDataHolder data) {
            ArrayList listTo;
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "addToBuilder"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "addToBuilder"));
            }
            assert (data != null);
            List listFrom = (List)ObjectUtils.assertNotNull((Object)FROM_ORDER.get(data));
            TIntArrayList list = ReorderColumnsOperation.generateInsertions(listFrom, listTo = ContainerUtil.newArrayList(to.columns));
            if (list.isEmpty()) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "addToBuilder"));
                }
                return ddlGenerator;
            }
            DdlGenerator ddlGenerator = this.addSelfToBuilder(generator, builder, to, DasDdlOperations.set(data, REORDER_INSERTIONS, list));
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }

        @NotNull
        public static <T> TIntArrayList generateInsertions(@NotNull List<T> fromList, @NotNull List<T> toList) {
            if (fromList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromList", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generateInsertions"));
            }
            if (toList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toList", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generateInsertions"));
            }
            assert (fromList.size() == toList.size());
            TObjectIntHashMap numeration = new TObjectIntHashMap();
            for (int i = 0; i < toList.size(); ++i) {
                numeration.put(toList.get(i), i);
            }
            int[] p = new int[fromList.size()];
            for (int i = 0; i < fromList.size(); ++i) {
                T t = fromList.get(i);
                assert (numeration.containsKey(t));
                p[i] = numeration.get(t);
            }
            TIntArrayList res = new TIntArrayList();
            while (true) {
                int offs;
                for (offs = 0; offs < p.length && p[offs] == offs; ++offs) {
                }
                if (offs >= p.length) break;
                int maxi = offs;
                int maxj = offs;
                int maxb = 0;
                for (int i = offs; i < p.length; ++i) {
                    int j;
                    int b = 0;
                    for (j = i - 1; j >= 0; --j) {
                        if ((b += p[j] > p[i] ? 1 : -1) <= maxb) continue;
                        maxi = i;
                        maxj = j;
                        maxb = b;
                    }
                    b = 0;
                    for (j = i + 1; j < p.length; ++j) {
                        if ((b += p[j] < p[i] ? 1 : -1) <= maxb) continue;
                        maxi = i;
                        maxj = j + 1;
                        maxb = b;
                    }
                }
                assert (maxb != 0);
                res.add(maxi);
                res.add(maxj);
                ReorderColumnsOperation.performInsertion(p, maxi, maxj);
            }
            TIntArrayList tIntArrayList = res;
            if (tIntArrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generateInsertions"));
            }
            return tIntArrayList;
        }

        public static void performInsertion(int[] p, int f, int t) {
            if (f < t) {
                ReorderColumnsOperation.rotateLeft(p, f, t - 1);
            } else {
                ReorderColumnsOperation.rotateRight(p, t, f);
            }
        }

        public static void rotateLeft(@NotNull int[] array, int i1, int i2) {
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "rotateLeft"));
            }
            int t = array[i1];
            System.arraycopy(array, i1 + 1, array, i1, i2 - i1);
            array[i2] = t;
        }

        public static void rotateRight(@NotNull int[] array, int i1, int i2) {
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "rotateRight"));
            }
            int t = array[i2];
            System.arraycopy(array, i1, array, i1 + 1, i2 - i1);
            array[i1] = t;
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.comment("Column reordering is unsupported!\n");
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "getDependencies"));
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectsRenameNCreateKeys(object.columns);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$ReorderColumnsOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    public static class CreateTableOperation
    extends DdlOperationGenerator<DeTable> {
        public static final Key<Set<DeForeignKey>> DEFERRED_FKS = Key.create((String)"DEFERRED_FKS");

        public CreateTableOperation() {
            super(CREATE_TABLE);
        }

        protected CreateTableOperation(@NotNull DdlOperation op) {
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "<init>"));
            }
            super(op);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlCreateTable(builder, Collections.singletonList(this.getView(object, data)), false, CreateTableOperation.getDeferredFks(data)).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "generate"));
            }
            return ddlBuilder;
        }

        @NotNull
        protected DeTable getView(@NotNull DeTable table, @Nullable UserDataHolder data) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getView"));
            }
            DeTable deTable = table;
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getView"));
            }
            return deTable;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getImplemented(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getImplemented"));
            }
            JBIterable res = super.getImplemented(object, data);
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key : object.foreignKeys) {
                if (deferredFks.contains(key)) continue;
                res = res.append((Object)new DdlOperationKey(key, CREATE_FOREIGN_KEY));
            }
            JBIterable jBIterable = res;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getImplemented"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeTable object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getDependencies"));
            }
            JBIterable res = JBIterable.empty();
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key : object.foreignKeys) {
                if (deferredFks.contains(key)) continue;
                res = res.append(DasDdlOperations.getObjectsRenameNCreateKeys(key.getTargetColumns()));
                if (key.target == object) continue;
                res = res.append(DasDdlOperations.getObjectRenameNCreateKeys(key.target));
            }
            JBIterable jBIterable = res;
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getDependencies"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "addToBuilder"));
            }
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key : das.foreignKeys) {
                if (!deferredFks.contains(key)) continue;
                generator.addOperation(builder, CREATE_FOREIGN_KEY, key, null);
            }
            if (das.comment != null) {
                generator.addOperation(builder, DdlOperation.ALTER_COMMENT, das, null);
            }
            DdlGenerator ddlGenerator = super.addToBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }

        @Override
        @NotNull
        public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeTable das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "removeFromBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "removeFromBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "removeFromBuilder"));
            }
            Set<DeForeignKey> deferredFks = CreateTableOperation.getDeferredFks(data);
            for (DeForeignKey key : das.foreignKeys) {
                if (!deferredFks.contains(key)) continue;
                generator.removeOperation(builder, CREATE_FOREIGN_KEY, key, null);
            }
            if (das.comment != null) {
                generator.removeOperation(builder, DdlOperation.ALTER_COMMENT, das, null);
            }
            DdlGenerator ddlGenerator = super.removeFromBuilder(generator, builder, das, data);
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "removeFromBuilder"));
            }
            return ddlGenerator;
        }

        @NotNull
        public static Set<DeForeignKey> getDeferredFks(@Nullable UserDataHolder data) {
            Set keys = (Set)DEFERRED_FKS.get(data);
            Set set = keys == null ? Collections.emptySet() : keys;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$CreateTableOperation", "getDeferredFks"));
            }
            return set;
        }
    }

    public static class AlterCommentOperation
    extends DdlOperationGenerator<DeObject> {
        public AlterCommentOperation() {
            super(DdlOperation.ALTER_COMMENT);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeObject from, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation", "generate"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation", "generate"));
            }
            DeObject to = (DeObject)DdlGraph.ALTER_TO.get(data);
            DdlBuilder ddlBuilder = builder.getDialect().sqlAlterObjectComment(builder, (DasObject)ObjectUtils.chooseNotNull((Object)to, (Object)from));
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation", "generate"));
            }
            return ddlBuilder;
        }

        @Override
        @NotNull
        public JBIterable<DdlOperationKey> getDependencies(@NotNull DeObject object, @Nullable UserDataHolder data) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation", "getDependencies"));
            }
            JBIterable<DdlOperationKey> jBIterable = DasDdlOperations.getObjectRenameNCreateKeys(object);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$AlterCommentOperation", "getDependencies"));
            }
            return jBIterable;
        }
    }

    public static class TemporaryRenameOperation
    extends DdlOperationGenerator<DeObject> {
        public static final Key<Boolean> TEMPORARY = Key.create((String)"TEMPORARY");

        public TemporaryRenameOperation() {
            super(DdlOperation.TEMPORARY_RENAME);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeObject das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$TemporaryRenameOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$TemporaryRenameOperation", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$TemporaryRenameOperation", "addToBuilder"));
            }
            DeObject from = DasDdlOperations.getAlterFrom(das, data);
            DeObject to = DasDdlOperations.getAlterTo(das, data);
            DeObject tmp = from.emptyClone(from.model).copyFrom(from, true, DeObject.DeCopier.SHALLOW);
            tmp.name = tmp.name + "_temp";
            tmp.editedObject = from;
            UserDataHolder awayData = builder.newData(data);
            UserDataHolder backData = builder.newData(data);
            DdlGraph.ALTER_FROM.set(awayData, null);
            DdlGraph.ALTER_FROM.set(backData, null);
            DdlGraph.ALTER_TO.set(awayData, (Object)tmp);
            DdlGraph.ALTER_TO.set(backData, (Object)to);
            TEMPORARY.set(awayData, (Object)Boolean.TRUE);
            TEMPORARY.set(backData, (Object)Boolean.TRUE);
            generator.addOperation(builder, DdlOperation.ALTER, from, awayData);
            generator.addOperation(builder, DdlOperation.ALTER, tmp, backData);
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$TemporaryRenameOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }
    }

    static class DropTableOperation
    extends DdlOperationGenerator<DeTable> {
        public DropTableOperation() {
            super(DROP_TABLE);
        }

        @Override
        @NotNull
        public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTableOperation", "generate"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTableOperation", "generate"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTableOperation", "generate"));
            }
            DdlBuilder ddlBuilder = builder.getDialect().sqlDropTable(builder, object, false, false, DasUtil.emptyModel()).newStatement();
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropTableOperation", "generate"));
            }
            return ddlBuilder;
        }
    }

    static class OperationSelector
    extends DdlOperationGenerator<DeObject> {
        private final List<Pair<Condition<DeObject>, DdlOperation>> myList;

        public OperationSelector(@NotNull DdlOperation operation) {
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "<init>"));
            }
            super(operation);
            this.myList = ContainerUtil.newArrayList();
        }

        @NotNull
        public OperationSelector add(@NotNull Class<? extends DeObject> clazz, @NotNull DdlOperation op) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            OperationSelector operationSelector = this.add(clazz, op, (Condition<DeObject>)Conditions.alwaysTrue());
            if (operationSelector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            return operationSelector;
        }

        @NotNull
        public OperationSelector add(@NotNull Class<? extends DeObject> clazz, @NotNull DdlOperation op, @NotNull Condition<DeObject> check) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            if (check == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            OperationSelector operationSelector = this.add((Condition<DeObject>)Conditions.and2((Condition)Conditions.instanceOf(clazz), check), op);
            if (operationSelector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            return operationSelector;
        }

        @NotNull
        public OperationSelector add(@NotNull Condition<DeObject> check, @NotNull DdlOperation op) {
            if (check == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            if (op == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            this.myList.add((Pair<Condition<DeObject>, DdlOperation>)Pair.create(check, (Object)op));
            OperationSelector operationSelector = this;
            if (operationSelector == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "add"));
            }
            return operationSelector;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeObject das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "addToBuilder"));
            }
            List found = ContainerUtil.newSmartList();
            for (Pair<Condition<DeObject>, DdlOperation> pair : this.myList) {
                if (!((Condition)pair.first).value((Object)das)) continue;
                found.add(pair.second);
            }
            if (found.size() == 1) {
                generator.addOperation(builder, (DdlOperation)found.get(0), das, data);
            } else if (found.isEmpty()) {
                this.myLogger.error("Operation " + this.getOperation() + " for object " + das.getKind() + " not found");
            } else {
                this.myLogger.error("Operation " + this.getOperation() + " for object " + das.getKind() + " is non unique");
            }
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$OperationSelector", "addToBuilder"));
            }
            return ddlGenerator;
        }
    }

    static class DummyOperation
    extends DdlOperationGenerator<DeObject> {
        public DummyOperation(@NotNull DdlOperation operation) {
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DummyOperation", "<init>"));
            }
            super(operation);
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeObject das, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DummyOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DummyOperation", "addToBuilder"));
            }
            if (das == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DummyOperation", "addToBuilder"));
            }
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DummyOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }
    }

    public static class DropCreateOperation<De extends DeObject>
    extends DdlOperationGenerator<De> {
        @NotNull
        private final DdlOperation myDrop;
        @NotNull
        private final DdlOperation myCreate;

        public DropCreateOperation(@NotNull DdlOperation alter, @NotNull DdlOperation drop, @NotNull DdlOperation create) {
            if (alter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alter", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "<init>"));
            }
            if (drop == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "drop", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "<init>"));
            }
            if (create == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "create", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "<init>"));
            }
            super(alter);
            this.myDrop = drop;
            this.myCreate = create;
        }

        @Override
        @NotNull
        public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull De from, @Nullable UserDataHolder data) {
            if (generator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "addToBuilder"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "addToBuilder"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "addToBuilder"));
            }
            assert (data != null);
            DeObject to = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
            if (!to.isAltered((DeObject)from)) {
                DdlGenerator ddlGenerator = generator;
                if (ddlGenerator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "addToBuilder"));
                }
                return ddlGenerator;
            }
            DasDdlOperations.set(data, DdlGraph.ALTER_TO, null);
            generator.addOperation(builder, this.myDrop, (DeObject)from, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_TO, to));
            generator.addOperation(builder, this.myCreate, to, DasDdlOperations.set(builder.newData(data), DdlGraph.ALTER_FROM, from));
            builder.addDependency(new DdlOperationKey(to, this.myCreate), new DdlOperationKey((DeObject)from, this.myDrop));
            DdlGenerator ddlGenerator = generator;
            if (ddlGenerator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/DasDdlOperations$DropCreateOperation", "addToBuilder"));
            }
            return ddlGenerator;
        }
    }
}

