/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.oracle;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.ConfigurableDdlGenerator;
import com.intellij.database.schemaEditor.operations.oracle.DeInnerObject;
import com.intellij.database.schemaEditor.operations.oracle.OracleRecompileOperationStuff;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmMatView;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraPackage;
import com.intellij.openapi.util.UserDataHolder;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J*\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R:\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003\u00a8\u0006\""}, d2={"Lcom/intellij/database/schemaEditor/operations/oracle/OracleRecompileOperation;", "Lcom/intellij/database/schemaEditor/operations/ConfigurableDdlGenerator;", "Lcom/intellij/database/schemaEditor/model/DeObject;", "()V", "supportedKinds", "Lcom/google/common/collect/ImmutableSet;", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "supportedKinds$annotations", "addToBuilder", "Lcom/intellij/database/schemaEditor/generation/DdlGenerator;", "generator", "builder", "Lcom/intellij/database/schemaEditor/generation/DdlGraphBuilder;", "das", "data", "Lcom/intellij/openapi/util/UserDataHolder;", "generate", "Lcom/intellij/database/util/DdlBuilder;", "object", "context", "Lcom/intellij/database/schemaEditor/generation/DdlBuildingContext;", "generateCode", "", "o", "Lcom/intellij/dbm/common/DbmObject;", "invalidOnly", "", "isSupported", "obj", "Lcom/intellij/database/model/DasObject;", "makeTheGraph", "deObject", "graphMaker", "database-impl"})
public final class OracleRecompileOperation
extends ConfigurableDdlGenerator<DeObject> {
    private static final ImmutableSet<ObjectKind> supportedKinds;
    public static final OracleRecompileOperation INSTANCE;

    @JvmStatic
    private static final /* synthetic */ void supportedKinds$annotations() {
    }

    @JvmStatic
    public static final boolean isSupported(@NotNull DasObject obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        return supportedKinds.contains((Object)obj.getKind()) && Intrinsics.areEqual((Object)obj.getName(), (Object)DasUtil.NO_NAME) ^ true;
    }

    @Override
    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DeObject das, @Nullable UserDataHolder data) {
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)das, (String)"das");
        this.makeTheGraph(das, generator, builder, data);
        return generator;
    }

    private final void makeTheGraph(DeObject deObject, DdlGenerator graphMaker, DdlGraphBuilder builder, UserDataHolder data) {
        OraBody oraBody;
        DbmObject o = OracleRecompileOperationStuff.access$getDbmObject$p(deObject);
        if (o instanceof DbmSourceAware) {
            this.addSelfToBuilder(graphMaker, builder, deObject, data);
        }
        if (o instanceof DbmLikeTable) {
            for (DbmTrigger dbmTrigger : ((DbmLikeTable)o).getTriggers()) {
                DbmObject dbmObject = dbmTrigger;
                Intrinsics.checkExpressionValueIsNotNull((Object)dbmObject, (String)"trigger");
                DeInnerObject<DbmObject> deTrigger = new DeInnerObject<DbmObject>(dbmObject, deObject);
                graphMaker.addOperation(builder, OracleRecompileOperationStuff.ORACLE_RECOMPILE_OPERATION, deTrigger, data);
            }
        }
        if (o instanceof OraModule && (oraBody = ((OraModule)o).getBody()) != null && !((OraModule)o).isInvalid()) {
            DeInnerObject<DbmObject> deBody = new DeInnerObject<DbmObject>(oraBody, deObject);
            graphMaker.addOperation(builder, OracleRecompileOperationStuff.ORACLE_RECOMPILE_OPERATION, deBody, data);
        }
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeObject object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        Boolean bl;
        Object userOption;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DbmObject dbmObject = OracleRecompileOperationStuff.access$getDbmObject$p(object);
        if (dbmObject == null) {
            return builder;
        }
        DbmObject o = dbmObject;
        Object object2 = data;
        if (object2 == null || (object2 = (Iterable)object2.getUserData(ConfigurableDdlGenerator.OPTION_VALUES)) == null) {
            object2 = userOption = (Iterable)SetsKt.emptySet();
        }
        if ((bl = (Boolean)OracleRecompileOperation.access$findOption$s-2094669248((Iterable)userOption, OracleRecompileOperationStuff.INVALID_ONLY_OPTION)) == null) {
            bl = Boolean.FALSE;
        }
        Boolean invalidOnly = bl;
        this.generateCode(builder, o, invalidOnly);
        return builder;
    }

    private final void generateCode(DdlBuilder builder, DbmObject o, boolean invalidOnly) {
        String statement;
        if (!(o instanceof DbmSourceAware)) {
            return;
        }
        if (invalidOnly && !((DbmSourceAware)((Object)o)).isInvalid()) {
            return;
        }
        String string = o.getNameOrNull();
        if (string == null) {
            return;
        }
        String objectName = string;
        String schemaName = o.getSchema().getNameOrNull();
        String prefix = schemaName != null ? schemaName + '.' : "";
        String name = prefix + objectName;
        DbmObject dbmObject = o;
        String string2 = dbmObject instanceof OraObjectType ? "alter type " + name + " compile reuse settings" : (dbmObject instanceof OraPackage ? "alter package " + name + " compile reuse settings" : (dbmObject instanceof OraBody ? "alter " + (((OraBody)o).getDbParent() instanceof OraObjectType ? "type" : "package") + " " + name + " compile body reuse settings" : (dbmObject instanceof DbmSingleRoutine ? "alter " + (Intrinsics.areEqual((Object)((DbmSingleRoutine)o).getRoutineKind(), (Object)DasRoutine.Kind.PROCEDURE) ? "procedure" : "function") + " " + name + " compile reuse settings" : (dbmObject instanceof DbmTrigger ? "alter trigger " + name + " compile reuse settings" : (dbmObject instanceof DbmView ? "alter view " + name + " compile" : (statement = dbmObject instanceof DbmMatView ? "alter materialized view " + name + " compile" : (String)null))))));
        if (statement != null) {
            builder.plain(statement);
            builder.newStatement();
        }
    }

    private OracleRecompileOperation() {
        super(OracleRecompileOperationStuff.ORACLE_RECOMPILE_OPERATION, OracleRecompileOperationStuff.INVALID_ONLY_OPTION);
        INSTANCE = this;
        supportedKinds = ImmutableSet.of((Object)ObjectKind.OBJECT_TYPE, (Object)ObjectKind.PACKAGE, (Object)ObjectKind.BODY, (Object)ObjectKind.ROUTINE, (Object)ObjectKind.TABLE, (Object)ObjectKind.VIEW, (Object[])new ObjectKind[]{ObjectKind.TRIGGER});
    }

    static {
        new OracleRecompileOperation();
    }

    @Nullable
    public static final /* synthetic */ Object access$findOption$s-2094669248(@NotNull Iterable values, @NotNull ConfigurableDdlGenerator.Option option) {
        return ConfigurableDdlGenerator.findOption(values, option);
    }
}

