/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.sql.Connection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRefactoringHandler
extends AbstractDatabaseModifier {
    private static final String INDICATOR_TITLE = "Updating Database...";
    @NotNull
    private final RefactoringExecutor myRefactoringExecutor;

    public DatabaseRefactoringHandler(@NotNull DbDataSource dataSource, @Nullable DasNamespace defaultNs) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/DatabaseRefactoringHandler", "<init>"));
        }
        super(dataSource, defaultNs, INDICATOR_TITLE);
        this.myRefactoringExecutor = new RefactoringExecutor(dataSource);
    }

    @NotNull
    public DatabaseRefactoringHandler setStatement(@NotNull String statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/view/DatabaseRefactoringHandler", "setStatement"));
        }
        this.myRefactoringExecutor.setStatement(statement);
        DatabaseRefactoringHandler databaseRefactoringHandler = this;
        if (databaseRefactoringHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "setStatement"));
        }
        return databaseRefactoringHandler;
    }

    @NotNull
    public String getStatement() {
        String string = this.myRefactoringExecutor.getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "getStatement"));
        }
        return string;
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        RefactoringExecutor refactoringExecutor = this.myRefactoringExecutor;
        if (refactoringExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler", "getExecutor"));
        }
        return refactoringExecutor;
    }

    /*
     * Exception decompiling
     */
    private static int executeQueries(@NotNull Project project, @NotNull Connection connection, @NotNull List<String> queries, @NotNull ErrorHandler errorHandler, @NotNull ProgressIndicator indicator) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class RefactoringExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        @NotNull
        private String myStatement;
        @NotNull
        private final DbDataSource myDataSource;

        public RefactoringExecutor(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "<init>"));
            }
            this.myStatement = "";
            this.myDataSource = dataSource;
        }

        public void setStatement(@NotNull String statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "setStatement"));
            }
            this.myStatement = statement;
        }

        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "getStatement"));
            }
            return string;
        }

        @Override
        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull Connection connection, @NotNull Project project, @NotNull ErrorHandler errorHandler) throws Exception {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "execute"));
            }
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "execute"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "execute"));
            }
            if (errorHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "com/intellij/database/view/DatabaseRefactoringHandler$RefactoringExecutor", "execute"));
            }
            List<String> queries = DbSqlUtil.getQueries(this.myStatement, this.myDataSource.getProject(), (Language)DbSqlUtil.getSqlDialect((DbElement)this.myDataSource));
            return queries.size() == DatabaseRefactoringHandler.executeQueries(project, connection, queries, errorHandler, indicator);
        }
    }
}

