/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceNameComponent;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.view.ui.DatabaseConfigController;
import com.intellij.database.view.ui.DatabaseDriverGeneralPanel;
import com.intellij.database.view.ui.DatabaseDriverPropertiesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TabbedPaneWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseDriverConfigurable
extends AbstractDatabaseConfigurable<DatabaseDriverImpl> {
    private final DatabaseDriverImpl myDriver;
    @NotNull
    private final DatabaseDriverImpl myTempDriver;
    private DataSourceNameComponent myNameComponent;
    private DatabaseDriverPropertiesPanel myPropertiesPanel;
    private DatabaseDriverGeneralPanel myGeneralPanel;
    private TabbedPaneWrapper myTabbedPane;

    DatabaseDriverConfigurable(@NotNull Project project, @NotNull DatabaseDriverImpl driver, @NotNull DatabaseConfigController editorController) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "<init>"));
        }
        if (editorController == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorController", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "<init>"));
        }
        super(project, driver);
        this.setController(editorController);
        this.myDriver = driver;
        this.myTempDriver = driver.copy(null, true);
    }

    @Nls
    public String getDisplayName() {
        return this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        JPanel rootPanel = new JPanel(new BorderLayout(0, 5));
        this.myNameComponent = new DataSourceNameComponent(this, this.myController);
        rootPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new TabbedPaneWrapper((Disposable)this);
        this.createGeneralOptionsTab(this.myTabbedPane);
        this.createDriverPropertiesTab(this.myTabbedPane);
        rootPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        return rootPanel;
    }

    @NotNull
    public DatabaseDriverImpl getTempDriver() {
        this.saveDriver(this.myTempDriver);
        DatabaseDriverImpl databaseDriverImpl = this.myTempDriver;
        if (databaseDriverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "getTempDriver"));
        }
        return databaseDriverImpl;
    }

    @NotNull
    public DatabaseDriverImpl getTempDriverRef() {
        DatabaseDriverImpl databaseDriverImpl = this.myTempDriver;
        if (databaseDriverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "getTempDriverRef"));
        }
        return databaseDriverImpl;
    }

    private void createDriverPropertiesTab(TabbedPaneWrapper tabbedPane) {
        this.myPropertiesPanel = new DatabaseDriverPropertiesPanel(this.myProject, this.myDriver.getDriverProperties(), this.myDriver.getVmOptions(), (Configurable)this, this.myController);
        tabbedPane.addTab("Advanced", (JComponent)this.myPropertiesPanel.getComponent());
    }

    private void createGeneralOptionsTab(TabbedPaneWrapper tabbedPane) {
        this.myGeneralPanel = new DatabaseDriverGeneralPanel(this, this.myTempDriver);
        tabbedPane.addTab("Settings", this.myGeneralPanel.getComponent());
    }

    private boolean isNewDriver() {
        return !DatabaseDriverManager.getInstance().getDrivers().contains(this.myDriver);
    }

    public void apply() throws ConfigurationException {
        this.saveDriver(this.myTempDriver);
        this.saveDriver(this.myDriver);
        DatabaseDriverManager.getInstance().updateDriver(this.myDriver);
    }

    private void saveDriver(DatabaseDriverImpl driver) {
        driver.setName(this.myNameComponent.getNameValue());
        if (this.myGeneralPanel != null && this.myPropertiesPanel != null) {
            this.myGeneralPanel.saveDriver(driver);
            this.myPropertiesPanel.saveProperties(driver.getDriverProperties());
            driver.setVmOptions(this.myPropertiesPanel.getVmOptions());
            driver.setVmEnv(this.myPropertiesPanel.getVmEnv());
        }
    }

    public void reset() {
        this.reset(this.myDriver);
    }

    public void reset(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "reset"));
        }
        this.myNameComponent.setNameValue(driver.getName());
        if (this.myGeneralPanel != null && this.myPropertiesPanel != null) {
            this.myGeneralPanel.reset(driver);
            this.myPropertiesPanel.setVmEnv(driver.getVmEnv());
        }
    }

    public boolean isModified() {
        if (this.isNewDriver()) {
            return true;
        }
        return !this.getTempDriver().equalConfiguration(this.myDriver);
    }

    @NotNull
    public DatabaseDriverImpl getDriver() {
        DatabaseDriverImpl databaseDriverImpl = this.myDriver;
        if (databaseDriverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "getDriver"));
        }
        return databaseDriverImpl;
    }

    public void addNewUrlTemplate(@NotNull String template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseDriverConfigurable", "addNewUrlTemplate"));
        }
        if (this.myGeneralPanel != null && this.myTabbedPane != null) {
            this.myTabbedPane.setSelectedComponent(this.myGeneralPanel.getComponent());
            this.myGeneralPanel.addNewUrlTemplate(template);
        }
    }

    public void focusDriverClassSelector() {
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.focusDriverClassSelector();
        }
    }
}

