/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.util.ClassInheritorsScanner;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DriverClasspathPanel;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.StringRowTableModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverGeneralPanel {
    private JComponent myTemplatesComponent;
    private JCheckBox myAutoCommitCheckBox;
    private JCheckBox myAutoSyncCheckBox;
    private JPanel myClasspathComponent;
    private JPanel myPanel;
    private JBScrollPane myScrollPane;
    private JComboBox myClassName;
    private JComboBox myDialect;
    private TemplatesTable myTemplatesTable;
    private final DatabaseDriverConfigurable myConfigurable;
    private final DatabaseDriver myTempDriver;
    private DriverClasspathPanel myClasspathPanel;
    private final ClassInheritorsScanner myScanner;

    public DatabaseDriverGeneralPanel(@NotNull DatabaseDriverConfigurable configurable, @NotNull DatabaseDriver tempDriver) {
        if (configurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "<init>"));
        }
        if (tempDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDriver", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "<init>"));
        }
        this.myConfigurable = configurable;
        this.myTempDriver = tempDriver;
        this.myScanner = new ClassInheritorsScanner(this.myConfigurable.getProject(), Driver.class);
        Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myScanner);
        this.$$$setupUI$$$();
        ((JComponent)this.myScrollPane.getViewport().getView()).setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myScrollPane.setBorder(null);
        this.myTemplatesComponent.add((Component)this.createUrlTemplatesPanel(), "Center");
        this.myClasspathComponent.add((Component)this.myClasspathPanel.createComponent(), "Center");
        JBEmptyBorder border = JBUI.Borders.emptyLeft((int)10);
        this.myTemplatesComponent.setBorder((Border)border);
        this.myClasspathComponent.setBorder((Border)border);
        this.setUrlTemplates((DatabaseDriverImpl)this.myTempDriver);
    }

    private JComponent createUrlTemplatesPanel() {
        this.myTemplatesTable = new TemplatesTable(new StringRowTableModel(new String[]{"Name", "Template"}, true));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((Object)this.myTemplatesTable));
        Dimension pref = new Dimension(150, 120);
        JPanel p = decorator.createPanel();
        p.setMinimumSize(pref);
        p.setPreferredSize(pref);
        return p;
    }

    private void createUIComponents() {
        this.myClassName = new ComboBox();
        this.myDialect = new ComboBox();
        this.myDialect.setEditable(false);
        DbImplUtil.initLanguageComboBox(this.myDialect, true);
        this.myClassName.setEditable(false);
        this.myClasspathPanel = new DriverClasspathPanel(this.myConfigurable.getProject(), (Configurable)this.myConfigurable, this.myTempDriver, null, this.myConfigurable.getController());
        Disposer.register((Disposable)this.myConfigurable, (Disposable)this.myClasspathPanel);
        this.myClasspathPanel.setOnUpdate(() -> {
            Set names = ContainerUtil.newConcurrentSet();
            this.myScanner.scanClasses(SimpleClasspathElementFactory.convertToFiles(this.myClasspathPanel.getClasspath()), (Consumer<String>)((Consumer)names::add)).doWhenProcessed(() -> ApplicationManager.getApplication().invokeLater(() -> {
                String cls = this.myTempDriver.getDriverClass();
                this.myClassName.setModel(DatabaseDriverGeneralPanel.createModel(names, cls));
            }));
        });
        this.myClassName.setModel(DatabaseDriverGeneralPanel.createModel(Collections.emptyList(), this.myTempDriver.getDriverClass()));
    }

    public void focusDriverClassSelector() {
        UIUtil.requestFocus((JComponent)this.myClassName);
    }

    @NotNull
    private static CollectionComboBoxModel<String> createModel(@NotNull Collection<String> items, @Nullable String item) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "createModel"));
        }
        ArrayList res = ContainerUtil.newArrayList(items);
        if (!items.contains(item)) {
            res.add(item);
        }
        ContainerUtil.sort((List)res);
        CollectionComboBoxModel collectionComboBoxModel = new CollectionComboBoxModel((List)res, (Object)item);
        if (collectionComboBoxModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "createModel"));
        }
        return collectionComboBoxModel;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public String getDriverClass() {
        String string = String.valueOf(this.myClassName.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "getDriverClass"));
        }
        return string;
    }

    @NotNull
    private List<String> currentClasses() {
        ArrayList res = ContainerUtil.newArrayList();
        for (int i = 0; i < this.myClassName.getItemCount(); ++i) {
            res.add(String.valueOf(this.myClassName.getItemAt(i)));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "currentClasses"));
        }
        return arrayList;
    }

    public void reset(DatabaseDriverImpl driver) {
        this.myClassName.setModel(DatabaseDriverGeneralPanel.createModel(this.currentClasses(), driver.getDriverClass()));
        this.setUrlTemplates(driver);
        String driverDialect = driver.getDialect();
        this.myDialect.setSelectedItem(Language.findLanguageByID((String)driverDialect));
        this.myAutoCommitCheckBox.setSelected(driver.getOption(DatabaseDriver.OPTION_AUTO_COMMIT));
        this.myAutoSyncCheckBox.setSelected(driver.getOption(DatabaseDriver.OPTION_AUTO_SYNC));
        ((DatabaseDriverImpl)this.myTempDriver).loadState(driver.getState(true), false, false, Integer.MAX_VALUE);
        this.myClasspathPanel.setDriver(driver);
    }

    private void setUrlTemplates(DatabaseDriverImpl driver) {
        this.myTemplatesTable.getModel().clear();
        for (UrlTemplate t : driver.getUrlTemplates()) {
            this.myTemplatesTable.getModel().addNewRow(new String[]{t.getName(), t.getTemplate()});
        }
    }

    public void saveDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "saveDriver"));
        }
        driver.setDriverClass(this.getDriverClass());
        ArrayList<UrlTemplate> templates = new ArrayList<UrlTemplate>(this.myTemplatesTable.getModel().getRowCount());
        for (String[] r : this.myTemplatesTable.getModel().getRows()) {
            if (StringUtil.isEmpty((String)r[0])) continue;
            templates.add(new UrlTemplate(r[0], r[1]));
        }
        driver.setURLTemplates(templates);
        Object dialect = this.myDialect.getSelectedItem();
        driver.setDialect(dialect instanceof Language ? ((Language)dialect).getID() : null);
        driver.setOption(DatabaseDriver.OPTION_AUTO_COMMIT, this.myAutoCommitCheckBox.isSelected());
        driver.setOption(DatabaseDriver.OPTION_AUTO_SYNC, this.myAutoSyncCheckBox.isSelected());
        driver.setAdditionalClasspathElements(this.myClasspathPanel.getClasspath());
        driver.setArtifact(this.myClasspathPanel.getArtifactName(), this.myClasspathPanel.getArtifactVersion(), this.myClasspathPanel.isRolling());
        driver.setUseArtifact(this.myClasspathPanel.isUseArtifact());
    }

    public void addNewUrlTemplate(@NotNull String template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel", "addNewUrlTemplate"));
        }
        this.myTemplatesTable.getModel().addNewRow(new String[]{"new", template});
        this.myTemplatesTable.requestFocus();
        IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTemplatesTable)).doWhenFocusSettlesDown(() -> this.myTemplatesTable.editCellAt(this.myTemplatesTable.getModel().getRowCount() - 1, this.myTemplatesTable.getModel().getColumnCount() - 1));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBScrollPane jBScrollPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel2.add((Component)jBScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel3);
        JLabel jLabel = new JLabel();
        jLabel.setText("Class:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myClassName;
        jPanel3.add((Component)jComboBox, new GridConstraints(0, 1, 1, 2, 8, 1, 7, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Dialect:");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = this.myDialect;
        jPanel3.add((Component)jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 0, 0));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 0, null, null, null));
        this.myAutoCommitCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Auto commit");
        Component component = jPanel4.add(jCheckBox2);
        this.myAutoSyncCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Auto sync");
        Component component2 = jPanel4.add(jCheckBox);
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(5, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel5, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("URL templates");
        jPanel5.add((Component)titledSeparator, "North");
        JPanel jPanel6 = new JPanel();
        this.myTemplatesComponent = jPanel6;
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel7, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("JDBC drivers");
        jPanel7.add((Component)titledSeparator2, "North");
        this.myClasspathComponent = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class MyTableCellEditor
    extends AbstractTableCellEditor {
        private final FieldPanel myEditor = new FieldPanel(null, "Edit template", null, null);

        private MyTableCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myEditor.setText(StringUtil.notNullize((String)String.valueOf(value)));
            this.myEditor.getTextField().setBorder(new LineBorder((Color)JBColor.BLACK));
            this.myEditor.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    myEditor.getTextField().requestFocusInWindow();
                }
            });
            return this.myEditor;
        }

        public Object getCellEditorValue() {
            return this.myEditor.getText();
        }
    }

    private static class TemplatesTable
    extends JBTable {
        public TemplatesTable(@NotNull StringRowTableModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$TemplatesTable", "<init>"));
            }
            super((TableModel)model);
            this.setRowHeight(new MyTableCellEditor().getTableCellEditorComponent((JTable)((Object)this), (Object)"", (boolean)true, (int)1, (int)1).getMinimumSize().height + this.getRowMargin());
            this.getColumnModel().getColumn(0).setMinWidth(100);
            this.getColumnModel().getColumn(1).setPreferredWidth(10000);
            this.setAutoResizeMode(3);
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            this.getInputMap(1).put(enter, "stopEditing");
            this.getActionMap().put("stopEditing", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableUtil.stopEditing((JTable)((Object)this));
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && this.rowAtPoint(e.getPoint()) == -1) {
                        TableUtil.stopEditing((JTable)((Object)this));
                        this.getModel().addRow();
                        int index = this.getModel().getRowCount() - 1;
                        this.setRowSelectionInterval(index, index);
                        this.setColumnSelectionInterval(0, 0);
                        this.editCellAt(index, 0);
                    }
                }
            });
            this.getEmptyText().setText("No URL templates");
        }

        @NotNull
        public StringRowTableModel getModel() {
            StringRowTableModel stringRowTableModel = (StringRowTableModel)super.getModel();
            if (stringRowTableModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseDriverGeneralPanel$TemplatesTable", "getModel"));
            }
            return stringRowTableModel;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            return column == 0 ? super.getCellEditor(row, column) : new MyTableCellEditor();
        }
    }
}

