/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreviewPanel
extends JPanel {
    private EditorTextField myPreviewEditor;
    private EventDispatcher<OpenInConsoleListener> myDispatcher;

    public SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource, @NotNull String query, @NotNull String propertyKey) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myDispatcher = EventDispatcher.create(OpenInConsoleListener.class);
        this.myPreviewEditor = DatabaseDialogsHelper.createLanguageEditorArea(project, dataSource, query);
        final String expansionProperty = propertyKey + ".previewExpanded";
        boolean isExpanded = PropertiesComponent.getInstance().getBoolean(expansionProperty, true);
        JComponent open = this.openInConsole(project, dataSource.getDelegate());
        HideableDecorator decorator = new HideableDecorator(this, "S&QL Preview", true, open){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue(expansionProperty, this.isExpanded());
            }
        };
        decorator.setContentComponent((JComponent)this.myPreviewEditor);
        decorator.setOn(isExpanded);
    }

    public SqlPreviewPanel(@NotNull Project project, @NotNull DbDataSource dataSource, @NotNull String query, @NotNull String propertyKey, final @NotNull Runnable closeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        if (closeDialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeDialog", "com/intellij/database/view/ui/SqlPreviewPanel", "<init>"));
        }
        this(project, dataSource, query, propertyKey);
        this.subscribeOpenInConsole(new OpenInConsoleListener(){

            @Override
            public void open() {
                closeDialog.run();
            }
        });
    }

    public void subscribeOpenInConsole(@NotNull OpenInConsoleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/SqlPreviewPanel", "subscribeOpenInConsole"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Nullable
    public JComponent openInConsole(final Project project, final Object delegate) {
        if (!(delegate instanceof LocalDataSource)) {
            return null;
        }
        String title = "Open query in console";
        JBLabel openInConsole = new JBLabel(AllIcons.Actions.MoveTo2);
        openInConsole.setToolTipText("Open query in console");
        openInConsole.setBorder(IdeBorderFactory.createEmptyBorder());
        openInConsole.setCursor(Cursor.getPredefinedCursor(12));
        openInConsole.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/SqlPreviewPanel$3", "mouseClicked"));
                }
                VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)((LocalDataSource)((Object)delegate)));
                Object[] editors = FileEditorManager.getInstance((Project)project).openFile(file, true);
                FileEditor fe = (FileEditor)ArrayUtil.getFirstElement((Object[])editors);
                if (fe instanceof TextEditor) {
                    Editor ed = ((TextEditor)fe).getEditor();
                    IdeFocusManager fm = IdeFocusManager.getInstance((Project)project);
                    fm.doWhenFocusSettlesDown(() -> {
                        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
                            Document document = ed.getDocument();
                            ed.getCaretModel().moveToOffset(document.getTextLength());
                            EditorModificationUtil.insertStringAtCaret((Editor)ed, (String)((StringUtil.isEmpty((String)document.getText()) ? "" : "\n") + SqlPreviewPanel.this.getQuery()));
                        }, "Open query in console", null));
                        fm.requestFocus((Component)ed.getContentComponent(), true);
                    });
                }
                ((OpenInConsoleListener)SqlPreviewPanel.this.myDispatcher.getMulticaster()).open();
            }
        });
        return openInConsole;
    }

    public void updatePreview(String query) {
        this.myPreviewEditor.setText(query);
        Editor editor = this.myPreviewEditor.getEditor();
        if (editor != null) {
            editor.getScrollingModel().scrollVertically(0);
            editor.getCaretModel().moveToOffset(0);
        }
    }

    public String getQuery() {
        return this.myPreviewEditor.getText();
    }

    public static interface OpenInConsoleListener
    extends EventListener {
        public void open();
    }
}

