/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.BaseFamily;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WrappedException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BasicFamily<@NotNull C extends DbmObject>
extends BaseFamily<C> {
    @NotNull
    private final DbmObject myOwner;
    @NotNull
    private final Constructor<C> myChildConstructor;
    private final boolean myOverloads;

    public BasicFamily(@NotNull DbmObject owner, @NotNull ObjectKind childKind, @NotNull Class<C> childClass) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/BasicFamily", "<init>"));
        }
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/BasicFamily", "<init>"));
        }
        if (childClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClass", "com/intellij/dbm/common/BasicFamily", "<init>"));
        }
        super(childKind, childClass);
        this.myOwner = owner;
        this.myChildConstructor = this.obtainChildConstructor(childClass);
        this.myOverloads = DbmOverloadable.class.isAssignableFrom(this.myChildClass);
    }

    @Override
    @NotNull
    public DbmObject getOwner() {
        DbmObject dbmObject = this.myOwner;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BasicFamily", "getOwner"));
        }
        return dbmObject;
    }

    @NotNull
    private Constructor<C> obtainChildConstructor(@NotNull Class<C> childClass) {
        if (childClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClass", "com/intellij/dbm/common/BasicFamily", "obtainChildConstructor"));
        }
        List constructors = ContainerUtil.filter((Object[])childClass.getDeclaredConstructors(), (Condition)new Condition<Constructor<?>>(){

            public boolean value(Constructor<?> constructor) {
                Class<?>[] types = constructor.getParameterTypes();
                return types.length == 2 && types[0].isAssignableFrom(BasicFamily.this.myOwner.getClass()) && types[1].isAssignableFrom(String.class);
            }
        });
        assert (constructors.size() == 1) : "The class " + childClass.getSimpleName() + " should have a declared constructor (" + this.myOwner.getClass().getSimpleName() + ", String)";
        Constructor constructor = (Constructor)constructors.get(0);
        constructor.setAccessible(true);
        Constructor constructor2 = constructor;
        if (constructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BasicFamily", "obtainChildConstructor"));
        }
        return constructor2;
    }

    @Override
    @NotNull
    public C create(@Nullable String name) {
        DbmObject child;
        Class childClass = this.getChildClass();
        assert (this.myChildKind != ObjectKind.NONE) : "The " + this.myOwner.getClass().getSimpleName() + " cannot have children typed " + childClass.getSimpleName();
        this.modifying();
        try {
            child = (DbmObject)this.myChildConstructor.newInstance(this.myOwner, name);
            this.doAddChild(child);
            child.setParentFamily(this);
            this.myOwner.childBorn(child);
        }
        catch (InvocationTargetException ite) {
            Throwable realCause = ite.getTargetException();
            if (realCause == null) {
                realCause = ite.getCause();
            }
            if (realCause == null) {
                realCause = ite;
            }
            throw new WrappedException(realCause);
        }
        catch (InstantiationException ie) {
            String exceptionClassName;
            String message;
            Throwable e = ie.getCause();
            if (e != null) {
                message = e.getMessage();
                exceptionClassName = e.getClass().getSimpleName();
            } else {
                message = "<empty-message>";
                exceptionClassName = "<unknown-exception>";
            }
            String msg = String.format("Failed to instantiate a model object %s class %s (for parent %s): exception %s: %s", this.myChildKind.toString(), childClass.getSimpleName(), this.myOwner.toString(), exceptionClassName, message);
            throw new WrappedException(msg, ie);
        }
        catch (Exception e) {
            String msg = String.format("Failed to instantiate a model object %s class %s (for parent %s): exception %s: %s", this.myChildKind.toString(), childClass.getSimpleName(), this.myOwner.toString(), e.getClass().getSimpleName(), e.getMessage());
            throw new WrappedException(msg, e);
        }
        this.myOwner.model.doingObjectCreate(child);
        DbmObject dbmObject = child;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BasicFamily", "create"));
        }
        return (C)dbmObject;
    }

    @Override
    public String getFamilyDescription() {
        return this.myOwner.identity() + "." + StringUtil.pluralize((String)this.myChildKind.toString());
    }

    @Override
    @Nullable
    public C getOverload(@NotNull String name, String[] specItems, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BasicFamily", "getOverload"));
        }
        if (this.myOverloads) {
            return this.getRealOverload(name, specItems, caseSensitively);
        }
        if (specItems == null || specItems.length == 0) {
            return (C)this.get(name, caseSensitively);
        }
        throw new IllegalStateException(String.format("Family of kind %s (class %s) doesn't support overloads", this.myChildKind.code(), this.myChildClass.getSimpleName()));
    }

    @Nullable
    private C getRealOverload(@NotNull String name, String[] specItems, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BasicFamily", "getRealOverload"));
        }
        int m = specItems == null ? 0 : specItems.length;
        ImmutableList children = this.asList();
        for (DbmObject child : children) {
            DbmOverloadable ovChild;
            String childName = child.getNameOrEmpty();
            boolean matched = caseSensitively ? childName.equals(name) : childName.equalsIgnoreCase(name);
            if (!matched || !(ovChild = (DbmOverloadable)((Object)child)).isApplicableTo(specItems)) continue;
            return (C)child;
        }
        return null;
    }

    @Override
    protected void modifying() {
        this.myOwner.modifyingFamily(this);
    }

    @Override
    @Nullable
    public DbmObject getParentNode() {
        return this.myOwner;
    }

    @Override
    public boolean isPopulatable() {
        return true;
    }

    @Override
    public DbmModel getModel() {
        return this.myOwner.getModel();
    }
}

