/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DomEnsembleObjectsRef;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.StateProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public class DbmCheck
extends DbmConstraint
implements BasicCheck {
    @StateProperty
    public String myPredicate;

    public DbmCheck(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmCheck", "<init>"));
        }
        super(table, name);
    }

    @Override
    protected DomObjectsRef<DbmLikeColumn> createColumnsRef(@NotNull DbmLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmCheck", "createColumnsRef"));
        }
        return new DomEnsembleObjectsRef<DbmLikeColumn>(this, table.columnResolver);
    }

    @Override
    @NotNull
    public final ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.CHECK;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmCheck", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        String p = this.myPredicate;
        if (p != null) {
            p = p.replace('\r', ' ').replace('\n', ' ');
            String string = "check (" + p + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmCheck", "description"));
            }
            return string;
        }
        if ("check" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmCheck", "description"));
        }
        return "check";
    }

    @Override
    protected char getConstraintKindOrderPrefix() {
        return '4';
    }

    @Override
    @Nullable
    public String getPredicate() {
        return this.myPredicate;
    }

    public void setPredicate(@Nullable String predicate) {
        if (Strings.eq((String)this.myPredicate, (String)predicate)) {
            return;
        }
        this.modifying();
        this.myPredicate = predicate;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmCheck", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "predicate", this.myPredicate);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.myPredicate;
    }
}

