/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.CascadeRule;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.DomOrderedObjectsRef;
import com.intellij.dbm.common.ObjectRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmForeignKey
extends DbmConstraint
implements BasicForeignKey {
    @StateProperty
    public final ObjectRef<DbmForeignKey, DbmKey> refKey;
    @StateProperty
    public CascadeRule myCascadeUpdateRule;
    @StateProperty
    public CascadeRule myCascadeDeleteRule;

    public DbmForeignKey(@NotNull DbmTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmForeignKey", "<init>"));
        }
        super(table, name);
        this.myCascadeUpdateRule = CascadeRule.restrict;
        this.myCascadeDeleteRule = CascadeRule.restrict;
        this.refKey = new ObjectRef<DbmForeignKey, DbmKey>(this, table.getSchema().keyResolver());
    }

    @Override
    protected DomObjectsRef<DbmLikeColumn> createColumnsRef(@NotNull DbmLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmForeignKey", "createColumnsRef"));
        }
        return new DomOrderedObjectsRef<DbmLikeColumn>(this, table.columnResolver);
    }

    @Override
    @NotNull
    public DbmObject getDbParent() {
        DbmLikeTable dbmLikeTable = this.table;
        if (dbmLikeTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmForeignKey", "getDbParent"));
        }
        return dbmLikeTable;
    }

    @Override
    @NotNull
    public final ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmForeignKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(80);
        List<String> columnNames = this.myColumns.namesOrdered();
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            String columnName = columnNames.get(i);
            b.append(i == 0 ? "(" : ", ");
            b.append(columnName);
        }
        b.append(") --> ");
        DbmLikeTable refTable = this.getRefTable();
        if (refTable != null) {
            b.append(refTable.identity(includeSurrogates));
        } else {
            b.append("?");
        }
        DbmKey refKey = this.getRefKeyObject();
        if (refKey != null) {
            b.append(' ');
            List<String> refColumnNames = refKey.myColumns.namesOrdered();
            int size2 = refColumnNames.size();
            for (int i = 0; i < size2; ++i) {
                String refColumnName = refColumnNames.get(i);
                b.append(i == 0 ? "(" : ", ");
                b.append(refColumnName);
            }
            b.append(')');
        }
        if (this.myCascadeUpdateRule != CascadeRule.restrict) {
            b.append(" u:").append((Object)this.myCascadeUpdateRule);
        }
        if (this.myCascadeDeleteRule != CascadeRule.restrict) {
            b.append(" d:").append((Object)this.myCascadeDeleteRule);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmForeignKey", "description"));
        }
        return string;
    }

    @Override
    protected char getConstraintKindOrderPrefix() {
        return '3';
    }

    public void resolve() {
        this.refKey.resolveObject();
    }

    @NotNull
    public CascadeRule getCascadeUpdateRule() {
        CascadeRule cascadeRule = this.myCascadeUpdateRule;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmForeignKey", "getCascadeUpdateRule"));
        }
        return cascadeRule;
    }

    public void setCascadeUpdateRule(@NotNull CascadeRule cascadeUpdateRule) {
        if (cascadeUpdateRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cascadeUpdateRule", "com/intellij/dbm/common/DbmForeignKey", "setCascadeUpdateRule"));
        }
        if (this.myCascadeUpdateRule == cascadeUpdateRule) {
            return;
        }
        this.modifying();
        this.myCascadeUpdateRule = cascadeUpdateRule;
    }

    @NotNull
    public CascadeRule getCascadeDeleteRule() {
        CascadeRule cascadeRule = this.myCascadeDeleteRule;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmForeignKey", "getCascadeDeleteRule"));
        }
        return cascadeRule;
    }

    public void setCascadeDeleteRule(@NotNull CascadeRule cascadeDeleteRule) {
        if (cascadeDeleteRule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cascadeDeleteRule", "com/intellij/dbm/common/DbmForeignKey", "setCascadeDeleteRule"));
        }
        if (this.myCascadeDeleteRule == cascadeDeleteRule) {
            return;
        }
        this.modifying();
        this.myCascadeDeleteRule = cascadeDeleteRule;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmForeignKey", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "ref-identity", this.getRefIdentity());
        if (this.myCascadeUpdateRule != CascadeRule.restrict) {
            this.putState(stateBuilder, "cascade_update", this.myCascadeUpdateRule.name());
        }
        if (this.myCascadeDeleteRule != CascadeRule.restrict) {
            this.putState(stateBuilder, "cascade_delete", this.myCascadeDeleteRule.name());
        }
    }

    @Nullable
    public DbmKey getRefKeyObject() {
        return this.refKey.resolveObject();
    }

    @Override
    @Nullable
    public DbmLikeTable getRefTable() {
        DbmKey rKey = this.refKey.resolveObject();
        return rKey != null ? rKey.table : null;
    }

    @Override
    @Nullable
    public String getRefTableName() {
        DbmKey rKey = this.refKey.resolveObject();
        return rKey != null ? rKey.table.getName() : null;
    }

    @Override
    @Nullable
    public String getRefTableSchema() {
        DbmKey key = this.refKey.resolveObject();
        return key != null ? key.table.getSchema().getName() : null;
    }

    @Override
    public String getRefTableCatalog() {
        DbmLikeTable refTable = this.getRefTable();
        return DasUtil.getCatalog((DasObject)refTable);
    }

    @Override
    @NotNull
    public MultiRef<? extends BasicColumn> getRefColumns() {
        DbmKey key = this.refKey.resolveObject();
        MultiRef multiRef = key == null ? DasUtil.asRef(Collections.emptyList()) : key.getColumnsRef();
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmForeignKey", "getRefColumns"));
        }
        return multiRef;
    }

    @Nullable
    public String getRefIdentity() {
        String[] rSubItems;
        String[] rPath;
        DbmKey rKey = this.getRefKeyObject();
        if (rKey != null) {
            rPath = ((DbmObject)((Object)rKey.getTable())).getPathInContextOf(this.table);
            rSubItems = (String[])Iterables.toArray((Iterable)rKey.myColumns.names(), String.class);
        } else {
            rPath = this.refKey.getPath();
            rSubItems = this.refKey.getArguments();
        }
        String rIdentity = StringUtil.join((String[])rPath, (String)".");
        if (rSubItems != null && rSubItems.length > 0) {
            rIdentity = rIdentity + '(' + StringUtil.join((String[])rSubItems, (String)".") + ')';
        }
        return rIdentity;
    }

    @Override
    public DasForeignKey.RuleAction getUpdateRule() {
        return this.myCascadeUpdateRule.action;
    }

    @Override
    public DasForeignKey.RuleAction getDeleteRule() {
        return this.myCascadeDeleteRule.action;
    }

    @Override
    public DasForeignKey.Deferrability getDeferrability() {
        return this.isDeferrable() ? (this.isInitiallyDeferred() ? DasForeignKey.Deferrability.INITIALLY_DEFERRED : DasForeignKey.Deferrability.INITIALLY_IMMEDIATE) : DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    public String toString() {
        String str = this.getName();
        String rId = this.refKey.getPathString();
        if (rId != null) {
            str = str + " -> " + rId;
        }
        return str;
    }
}

