/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmTableElement;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.dbm.common.Resolver;
import com.intellij.dbm.common.StateProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmLikeTable
extends DbmMajor
implements BasicModLikeTable {
    protected final Family<? extends DbmColumn> myColumns;
    protected final Family<? extends DbmIndex> myIndices;
    protected final Family<? extends DbmKey> myKeys;
    protected final Family<? extends DbmForeignKey> myForeignKeys;
    protected final Family<? extends DbmCheck> myChecks;
    protected final Family<? extends DbmTrigger> myTriggers;
    @StateProperty
    public boolean myIsSystem;
    final Resolver<DbmLikeColumn> columnResolver;
    private static final Consumer<DbmTableElement> ourDisplayOrderInvalidator = element -> element.invalidateDisplayOrder();

    @NotNull
    public Family<? extends DbmColumn> getColumns() {
        Family<? extends DbmColumn> family = this.myColumns;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getColumns"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmIndex> getIndices() {
        Family<? extends DbmIndex> family = this.myIndices;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getIndices"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmKey> getKeys() {
        Family<? extends DbmKey> family = this.myKeys;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getKeys"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmForeignKey> getForeignKeys() {
        Family<? extends DbmForeignKey> family = this.myForeignKeys;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getForeignKeys"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmCheck> getChecks() {
        Family<? extends DbmCheck> family = this.myChecks;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getChecks"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmTrigger> getTriggers() {
        Family<? extends DbmTrigger> family = this.myTriggers;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getTriggers"));
        }
        return family;
    }

    protected DbmLikeTable(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmLikeTable", "<init>"));
        }
        super(schema, name);
        this.columnResolver = new Resolver.Base<DbmLikeColumn>(){

            @Override
            @Nullable
            public DbmLikeColumn resolve(@NotNull RelativeReference p) {
                if (p == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/DbmLikeTable$1", "resolve"));
                }
                if (p.args != null) {
                    return null;
                }
                return p.path.length == 1 ? DbmLikeTable.this.resolveColumn(p.path[0]) : null;
            }

            @Override
            @Nullable
            public DbmLikeColumn resolve2(@NotNull String[] path, @Nullable String[] args) {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/DbmLikeTable$1", "resolve2"));
                }
                return path.length == 1 ? DbmLikeTable.this.resolveColumn(path[0]) : null;
            }
        };
        this.myColumns = Family.of(this, ObjectKind.COLUMN);
        this.myIndices = Family.of(this, ObjectKind.INDEX);
        this.myKeys = Family.of(this, ObjectKind.KEY);
        this.myForeignKeys = Family.of(this, ObjectKind.FOREIGN_KEY);
        this.myChecks = Family.of(this, ObjectKind.CHECK);
        this.myTriggers = Family.of(this, ObjectKind.TRIGGER);
        this.assignFamilies(this.myColumns, this.myIndices, this.myKeys, this.myForeignKeys, this.myChecks, this.myTriggers);
    }

    @Nullable
    public DbmLikeColumn resolveColumn(@Nullable String name) {
        return name != null ? (DbmLikeColumn)((Family)this.getColumns()).get(name) : null;
    }

    @Override
    protected void modifyingChild(@NotNull DbmElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmLikeTable", "modifyingChild"));
        }
        super.modifyingChild(element);
        if (element instanceof DbmColumn) {
            this.myIndices.forEach(ourDisplayOrderInvalidator);
            this.myKeys.forEach(ourDisplayOrderInvalidator);
            this.myForeignKeys.forEach(ourDisplayOrderInvalidator);
            this.myChecks.forEach(ourDisplayOrderInvalidator);
        }
    }

    @Nullable
    public DbmConstraint getConstraint(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmLikeTable", "getConstraint"));
        }
        DbmConstraint c = (DbmConstraint)((Family)this.getKeys()).get(name);
        if (c != null) {
            return c;
        }
        c = (DbmConstraint)((Family)this.getForeignKeys()).get(name);
        if (c != null) {
            return c;
        }
        c = (DbmConstraint)((Family)this.getChecks()).get(name);
        if (c != null) {
            return c;
        }
        return null;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmLikeTable", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "comment", this.myComment);
    }

    @Override
    @Nullable
    public DbmKey getPrimaryKey() {
        for (DbmKey key : this.getKeys()) {
            if (!key.isPrimary()) continue;
            return key;
        }
        return null;
    }

    @Nullable
    public DbmKey getKeyByColumns(@NotNull List<String> columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/dbm/common/DbmLikeTable", "getKeyByColumns"));
        }
        int n = columnNames.size();
        if (n < 1) {
            return null;
        }
        ImmutableList<? extends DbmKey> keys = this.myKeys.asList();
        for (DbmKey key : keys) {
            List<String> names = key.myColumns.namesOrdered();
            if (!DbmLikeTable.listsAreEqueal(names, columnNames)) continue;
            return key;
        }
        return null;
    }

    private static <T> boolean listsAreEqueal(List<T> listA, List<T> listB) {
        int n = listA.size();
        if (listB.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Objects.equals(listA.get(i), listB.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSystem() {
        return this.myIsSystem;
    }

    public void setIsSystem(boolean isSystem) {
        if (this.myIsSystem == isSystem) {
            return;
        }
        this.modifying();
        this.myIsSystem = isSystem;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn column) {
        if (column == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getColumnAttrs"));
            }
            return set;
        }
        String name = column.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (column instanceof DbmColumn && ((DbmColumn)column).getSequenceIdentity() != null) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        if (this.getPrimaryKey() != null && DasUtil.containsName((String)name, (MultiRef)this.getPrimaryKey().getColumnsRef())) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (DbmTableElement o : this.getForeignKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)((DbmConstraint)o).getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DbmTableElement o : this.getIndices()) {
            if (!DasUtil.containsName((String)name, (MultiRef)((DbmIndex)o).getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getColumnAttrs"));
        }
        return enumSet;
    }
}

