/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmMultiDatabaseRoot<D extends DbmDatabase, S extends DbmSchema>
extends DbmRoot<D>
implements BasicModMultiDatabaseRoot {
    protected final Family<D> myDatabases;
    @Nullable
    private D myCurrentDatabase;

    public DbmMultiDatabaseRoot(@NotNull DbmModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/DbmMultiDatabaseRoot", "<init>"));
        }
        super(model);
        this.myDatabases = Family.of(this, ObjectKind.DATABASE);
        this.assignFamilies(this.myDatabases);
    }

    @NotNull
    public Family<D> getDatabases() {
        Family<D> family = this.myDatabases;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMultiDatabaseRoot", "getDatabases"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<D> getNamespaces() {
        Family<D> family = this.myDatabases;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMultiDatabaseRoot", "getNamespaces"));
        }
        return family;
    }

    @Override
    @NotNull
    public Iterable<S> getAllSchemas() {
        JBIterable jBIterable = JBIterable.from(this.myDatabases).flatten(DbmDatabase::getSchemas).transform(s -> s);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmMultiDatabaseRoot", "getAllSchemas"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public DbmSchema findSchema(String name) {
        for (DbmDatabase database : this.myDatabases) {
            for (DbmSchema schema : database.getSchemas()) {
                if (!schema.getName().equals(name)) continue;
                return schema;
            }
        }
        return null;
    }

    @Nullable
    public D getCurrentDatabase() {
        return this.myCurrentDatabase;
    }

    @Override
    @Nullable
    public D getCurrentNamespace() {
        return this.getCurrentDatabase();
    }

    public void setCurrentDatabase(@Nullable DbmDatabase currentDatabase) {
        if (this.myCurrentDatabase == currentDatabase) {
            return;
        }
        assert (currentDatabase == null || this.myDatabases.contains(currentDatabase));
        this.modifying();
        this.myCurrentDatabase = currentDatabase;
    }

    @Override
    public void setCurrentNamespace(@Nullable DbmNamespace currentNamespace) {
        if (currentNamespace == null || currentNamespace instanceof DbmDatabase) {
            this.setCurrentDatabase((DbmDatabase)currentNamespace);
        }
    }

    @Nullable
    public S getCurrentSchema() {
        D db = this.getCurrentDatabase();
        if (db == null) {
            return null;
        }
        return (S)((DbmDatabase)db).getCurrentSchema();
    }
}

