/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.NaturalPositioned;
import com.intellij.dbm.common.StateProperty;
import com.intellij.util.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmPositionedIndex
extends DbmIndex
implements NaturalPositioned {
    @StateProperty
    public short myPosition;

    public DbmPositionedIndex(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmPositionedIndex", "<init>"));
        }
        super(table, name);
    }

    @Override
    public short getPosition() {
        return this.myPosition;
    }

    @Override
    public void setPosition(short position) {
        this.myPosition = position;
    }

    @Override
    @NotNull
    public String calculateDisplayOrder() {
        String string = Numbers.toFixLengthNumber(this.myPosition, 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmPositionedIndex", "calculateDisplayOrder"));
        }
        return string;
    }
}

