/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.MetaModel;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleDatabaseRoot;
import com.intellij.dbm.common.Family;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmSingleDatabaseModel<@NotNull S extends DbmSchema>
extends DbmModel<DbmSingleDatabaseRoot<S>, S> {
    private final ConcurrentLongObjectMap<DbmObject> myObjectsById;

    public DbmSingleDatabaseModel(@NotNull MetaModel<DbmObject> meta) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/common/DbmSingleDatabaseModel", "<init>"));
        }
        super(meta);
        this.myObjectsById = ContainerUtil.createConcurrentLongObjectMap();
    }

    @Override
    protected DbmSingleDatabaseRoot<S> createRoot() {
        return new DbmSingleDatabaseRoot(this);
    }

    @NotNull
    public Family<S> schemas() {
        ModNamingFamily modNamingFamily = ((DbmSingleDatabaseRoot)this.getRoot()).getSchemas();
        if (modNamingFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSingleDatabaseModel", "schemas"));
        }
        return modNamingFamily;
    }

    @Nullable
    public S getCurrentSchema() {
        return ((DbmSingleDatabaseRoot)this.getRoot()).getCurrentSchema();
    }

    public void setCurrentSchema(@Nullable DbmSchema schema) {
        ((DbmSingleDatabaseRoot)this.getRoot()).setCurrentSchema(schema);
    }

    public void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        if (oldId != 0L) {
            this.myObjectsById.remove(oldId, (Object)object);
        }
        if (newId != 0L) {
            this.myObjectsById.put(newId, (Object)object);
        }
    }

    @Nullable
    public DbmObject getObjectById(long id) {
        return (DbmObject)this.myObjectsById.get(id);
    }
}

